from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/部门管理模块/部门新增.csv')

class Department_Add_000x:
    tags = ['部门管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 部门新增测试报告 --test 部门新增_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以部门管理主流程功能。
            本函数根据参数输入部门名称，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        department_name, department_type, check_add_text = self.para

        # 步骤1: 点击部门新增按钮
        STEP(1, "点击部门新增按钮")
        if department_type == "父级部门":
            # 安全点击操作，找到新增按钮并点击
            safe_click((By.XPATH, "//button[@class='el-button el-button--primary el-button--medium']"), wd)
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), department_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)
            STEP(2, "检查父级部门新增提示文本信息")
            # 获取新增后的通知文本
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Add", f"{name}部门新增")
            # 检查新增提示文本是否与预期相符
            INFO(f"父级部门新增提示文本:{notify_text}")
            CHECK_POINT("父级部门新增提示文本", notify_text == check_add_text)

        elif department_type == "二级子部门":
            # 安全点击操作，找到新增父部门按钮并点击
            safe_click((By.XPATH, "//button[@class='el-button el-button--primary el-button--medium']"), wd)
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), department_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)
            STEP(2, "检查父级部门新增提示文本信息")
            # 获取新增后的通知文本
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Department_Manage",
                                          "Department_Add", f"{name}部门新增")
            # 检查新增提示文本是否与预期相符
            INFO(f"父级部门新增提示文本:{notify_text}")
            CHECK_POINT("父级部门新增提示文本", notify_text == check_add_text)

            # 安全点击操作，找到新增子部门按钮并点击
            safe_click((By.XPATH, "(//span[contains(text(),'添 加')])[4]"), wd)
            sleep(1)
            STEP(2, "检查二级子部门新增提示文本信息")
            # 获取新增后的通知文本
            notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Add", f"{name}部门新增")
            # 检查新增提示文本是否与预期相符
            INFO(f"二级子部门新增提示文本:{notify_text}")
            CHECK_POINT("二级子部门新增提示文本", notify_text == check_add_text)

            # 清除测试数据
            if name == "部门新增_002":
                safe_click((By.XPATH, "(//span[contains(text(),'删除')])[4]"),wd)
                sleep(1)
                safe_click((By.XPATH, "(//span[contains(text(),'确定')])[4]"), wd)
                sleep(1)
                # 获取新增后的通知文本
                notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Department_Manage",
                                              "Department_Add", f"{name}部门新增")
                # 检查新增提示文本是否与预期相符
                INFO(f"检查清除数据的提示文本:{notify_text}")
                CHECK_POINT("校验清除数据提示文本", notify_text == check_add_text)

        if name == '部门新增_002':
            wd.refresh()