from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/部门管理模块/部门主流程.csv')

class Main_Department_Manage_000x:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 部门主流程测试报告 --test 部门主流程_0**
    """
    tags = ['部门管理功能' , '后台管理功能','预定系统功能']
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以部门管理主流程功能。
            本函数根据参数输入部门名称，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        department_name, check_add_text, check_edit_text, check_del_text = self.para

        # 步骤1: 点击部门新增按钮
        STEP(1, "点击部门新增按钮")
        # 安全点击操作，找到新增按钮并点击
        safe_click((By.XPATH, "//button[@class='el-button el-button--primary el-button--medium']"), wd)
        sleep(1)
        # 获取新增后的通知文本
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Main", f"{name}部门新增")
        # 检查新增提示文本是否与预期相符
        INFO(f"部门新增提示文本:{notify_text}")
        CHECK_POINT("部门新增提示文本", notify_text == check_add_text)

        # 步骤2: 修改部门名称
        STEP(2, "修改部门名称")
        # 输入默认部门名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), "默认部门名称", wd)
        # 发送回车键
        INFO("输入部门名称：默认部门名称 查询")
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(2)
        INFO("点击编辑按钮")
        # 安全点击编辑按钮
        safe_click((By.XPATH,
                    "(//span[contains(text(),'编 辑')])[3]"),wd)
        INFO(f"输入部门名称：{department_name}")
        # 输入新的部门名称
        safe_send_keys((By.XPATH,
                        "//input[@placeholder='输入关键字搜索']"),
                       department_name, wd)
        INFO("点击确定按钮")
        # 点击确定按钮
        safe_click((By.XPATH, "//div[@aria-label='编 辑']//span[contains(text(),'确定')]"), wd)
        sleep(1)
        # 获取编辑后的通知文本
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Main", f"{name}部门编辑")
        INFO(f"部门编辑提示文本:{notify_text}")
        # 检查编辑提示文本是否与预期相符
        CHECK_POINT("部门编辑提示文本", notify_text == check_edit_text)

        # 步骤3: 查询部门名称
        STEP(3, "查询部门名称")
        # 输入部门名称进行查询
        INFO(f"输入部门名称：{department_name}，进行查询")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), department_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)
        # 获取查询结果的部门名称文本
        department_name_text = elment_get_text((By.XPATH, f"//span[@title='{department_name}']"), wd)
        INFO(f"部门名称查询结果：{department_name_text}")
        sleep(1)
        # 检查查询结果是否与输入的部门名称一致
        CHECK_POINT("部门名称查询结果", department_name in department_name_text)

        # 步骤4: 删除部门
        STEP(4, "删除部门")
        INFO(f"点击删除按钮")
        # 安全点击删除按钮
        safe_click((By.XPATH, "//div[@class='el-tree-node is-expanded is-focusable']//span[contains(text(),'删除')]"),
                   wd)
        # 点击确认删除按钮
        safe_click((By.XPATH,
                    "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                   wd)
        sleep(1)
        # 获取删除后的通知文本
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Main", f"{name}部门删除")
        INFO(f"部门删除提示文本:{notify_text}")
        # 检查删除提示文本是否与预期相符
        CHECK_POINT("部门删除提示文本", notify_text == check_del_text)
        sleep(3)

        if name == '部门主流程_005':
            wd.refresh()