from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/部门管理模块/部门编辑.csv')

class Department_Edit_000x:
    tags = ['部门管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 部门编辑测试报告 --test 部门编辑_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以部门管理主流程功能。
            本函数根据参数输入部门名称，并检查新增后的提示信息是否与预期相符。
        """
        sleep(5)
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        department_name, new_department_name, department_user, check_text = self.para

        # 步骤1：查询部门
        STEP(1, "查询部门")
        # 在搜索框中输入部门名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), department_name, wd)
        # 触发键盘事件以启动搜索
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(3)
        # 获取查询结果的部门名称文本
        department_name_text = elment_get_text((By.XPATH, f"//span[@title='{department_name}']"), wd)
        INFO(f"部门名称查询结果：{department_name_text}")
        # 检查查询结果是否与输入的部门名称一致
        CHECK_POINT("部门名称查询结果", department_name in department_name_text)

        # 步骤2：选择部门并点击编辑按钮
        STEP(2, f"选择：{department_name}，点击编辑按钮")
        safe_click((By.XPATH, "(//span[contains(text(),'编 辑')])[2]"), wd)
        # 检查编辑页面标题是否为“编辑”
        notify_text = elment_get_text((By.XPATH, "//span[@class='el-dialog__title'][contains(text(),'编 辑')]"), wd)
        CHECK_POINT("部门编辑页标题", notify_text == "编 辑")

        # 步骤3：在部门编辑页查询部门负责人
        STEP(3, f"进入部门编辑页，查询部门负责人：{department_user}")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入用户名称搜索']"), department_user, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入用户名称搜索']"), wd)
        sleep(2)
        department_user_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{department_user}']"), wd)
        CHECK_POINT("部门负责人查询结果", department_user in department_user_text)

        # 步骤4：勾选部门负责人
        STEP(4, f"勾选部门负责人：{department_user}")
        department_user_text = elment_get_text((By.CSS_SELECTOR, "div[class='currentDep'] div"), wd)
        INFO(f"部门负责人查询结果：{department_user_text}")
        if department_user_text != department_user:
            safe_click((By.XPATH, "//div[@class='department-item user']"), wd)
            sleep(2)
            department_user_text = elment_get_text((By.XPATH, "//div[@class='selectionsuser-name']"), wd)
            CHECK_POINT("部门负责人选择结果", department_user in department_user_text)

        # 步骤5：删除部门负责人
        STEP(5, f"删除部门负责人：{department_user}")
        safe_click((By.XPATH, "//i[@class='el-icon-delete']"), wd)
        # 检查删除后的提示信息
        notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'暂未选择人员')]"), wd)
        INFO(f"部门负责人删除提示：{notify_text}")
        CHECK_POINT("部门负责人删除结果", notify_text == "暂未选择人员")

        # 步骤6：再次勾选部门负责人
        STEP(6, f"勾选部门负责人：{department_user}")
        safe_click((By.XPATH, "//div[@class='department-item user']"), wd)
        sleep(1)
        department_user_text = elment_get_text((By.XPATH, "//div[@class='selectionsuser-name']"), wd)
        CHECK_POINT("检查部门负责人选择结果", department_user in department_user_text)

        # 步骤7：输入新的部门名称并点击确定
        STEP(7, f"输入部门名称：{new_department_name}，点击【确定】按钮")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), new_department_name, wd)
        safe_click((By.XPATH, "//div[@aria-label='编 辑']//span[contains(text(),'确定')]"), wd)
        sleep(1)
        # 获取并检查编辑部门后的提示信息
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"),"Department_Manage", "Department_Edit", name)
        INFO(f"部门编辑提示：{notify_text}")
        sleep(4)
        CHECK_POINT("检查部门编辑提示", notify_text == check_text)

        # 步骤8：检查部门负责人
        STEP(8, f"检查部门负责人：{department_user}")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), new_department_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)
        safe_click((By.XPATH, "(//span[contains(text(),'编 辑')])[2]"), wd)
        notify_text = elment_get_text(
            (By.XPATH, f"//div[@class='currentDep']//div[contains(text(),'{department_user}')]"), wd)
        CHECK_POINT("检查部门负责人查询结果", department_user in notify_text)
        safe_click((By.XPATH, "//div[@aria-label='编 辑']//i[@class='el-dialog__close el-icon el-icon-close']"), wd)
        sleep(2)

        if name == '部门编辑_009':
            wd.refresh()