from time import sleep
from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户编辑.csv')


class User_Edit_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户编辑测试报告 --test 用户编辑_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        sleep(5)
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        username, new_username, department, gender, phone, email, check_text, back_check_text = self.para

        # 根据条件判断是否执行编辑用户的操作
        if name == '用户编辑_001' or back_check_text == '修改成功':
            # 执行编辑用户操作的步骤
            STEP(1, f'选择用户：{username}，点击编辑按钮')
            INFO(f'输入用户名：{username}进行搜索')
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), username, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            INFO('点击编辑按钮')
            safe_click((By.XPATH, "//i[@class='el-icon-edit']"), wd)
            sleep(1)
            notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'编辑用户')]"), wd)
            INFO(f'校验编辑界面UI：{notify_text}')
            CHECK_POINT('校验编辑界面', "编辑用户" in notify_text)
            sleep(2)

        # 执行输入用户信息的步骤
        STEP(2, f'输入用户名：{new_username}')
        sleep(2)
        INFO(f'修改用户信息：{new_username, department, gender, phone, email}')
        safe_send_keys((By.XPATH, "//input[@placeholder='用户名']"), new_username, wd)

        # 清除下拉框数据
        # if name != '用户编辑_001':
        safe_click((By.XPATH, "//i[@class='el-tag__close el-icon-close']"), wd)
        sleep(2)
        # 点击部门下拉框
        safe_click((By.XPATH, "//div[@class='el-input el-input--suffix']//input[@placeholder='请选择']"), wd)
        sleep(2)
        # 选择部门
        safe_click((By.XPATH, "/html[1]/body[1]/div[4]/div[1]/div[1]/div[1]/ul[1]/li[1]/label[1]/span[1]/span[1]"), wd)

        # 选择性别
        safe_click((By.XPATH, f"//span[contains(text(),'{gender}')]"), wd)
        # 输入手机和邮箱
        safe_send_keys((By.XPATH, "//input[@placeholder='手机']"), phone, wd)
        safe_send_keys((By.XPATH, "//input[@placeholder='邮箱']"), email, wd)
        sleep(2)
        # 截图记录用户信息输入界面
        SELENIUM_LOG_SCREEN(wd, '50%', 'User_Manage', 'User_Edit', f'{name}用户信息输入')

        # 点击确定按钮提交用户信息
        STEP(3, '点击确定按钮')
        safe_click((By.XPATH, "//div[@aria-label='编辑用户']//span[contains(text(),'确定')]"), wd)

        # 检查操作后的提示信息
        sleep(2)
        STEP(4, '检查提示信息')
        notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), 'User_Manage', 'User_Chanage_Pwd',
                                      f'{name}检查提示信息')
        CHECK_POINT('校验编辑用户提示信息', notify_text == check_text)

        # if name == '用户编辑_018':
        #     # 清除浏览器，再重新打开浏览器
        #     wd.get(login_url)
        #     # 最大化浏览器窗口
        #     wd.maximize_window()
        #     admin_login()
        #     enter_the_backend()
        #
        #     INFO("打开账号管理下拉菜单")
        #     safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)
        #
        #     INFO("进入用户管理模块")
        #     safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)