from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户删除.csv')

class Delete_User_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户删除测试报告 --test 用户删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户删除功能。
            本函数根据参数输入账号，并检查删除后的数据是否减少。
        """
        notify_text = ""
        sleep(5)
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        account, expected = self.para

        STEP(1, f"搜索用户：{account}")
        #输入关键字查询
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), account, wd)
        sleep(1)

        #发送回车键
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        STEP(2, f"选择用户：{account}点击删除按钮")
        #点击删除按钮
        safe_click((By.XPATH, "//i[@class='el-icon-delete']"), wd)
        #屏幕截图
        sleep(1)
        SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Delete",f"{name}_点击删除")

        if expected == "删除成功":
            STEP(3, "点击确认按钮")
            #点击【确定】按钮
            safe_click((By.XPATH,
                        "//button[@class='el-button el-button--default el-button--small el-button--primary ']//span[contains(text(),'确定')]"),
                       wd)
            sleep(2)

        else:
            STEP(3, "点击取消按钮")
            # 点击【取消】按钮
            safe_click((By.XPATH,
                        "//span[contains(text(),'取消')]"),wd)

        STEP(4, "检查删除结果")
        #输入关键字查询
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), account, wd)
        #发送回车键
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)

        #获取列表中显示的文本
        check_text = elment_get_text((By.XPATH, "//span[@class='el-table__empty-text']"),wd)
        CHECK_POINT("检查删除结果", check_text == "暂无数据")
        sleep(2)
        #屏幕截图
        SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Delete",f"{name}_查看删除结果")