import csv
from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户查询.csv')

class Query_User_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户查询测试报告 --test 用户查询_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名进行查询，并检查查询后列表数据是否符合。
            query_text：查询文本
            query_type：查询类型
        """
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出查询文本以及查询类型
        name = self.name
        query_text, query_type = self.para

        STEP(1, f"搜索用户：{query_text}")
        # 输入关键字查询
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), query_text, wd)
        sleep(1)

        # 发送回车键
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        STEP(2, "检查搜索结果")
        # 判断查询类型
        if query_type == 'account':
            check_text = elment_get_text(
                (By.CSS_SELECTOR, "tbody tr[class='el-table__row'] td:nth-child(2) div:nth-child(1)"), wd)
            # INFO输出获取的文本
            INFO(f"检查搜索结果：{check_text}")
            # 截屏显示
            SELENIUM_LOG_SCREEN(wd,"50%","User_Manage","User_Query",f"{name}_检查搜索结果")
            CHECK_POINT("检查搜索结果", check_text == query_text)

        elif query_type == 'username':
            check_text = elment_get_text(
                (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(3) > div:nth-child(1)"), wd)
            # INFO输出获取的文本
            INFO(f"检查搜索结果：{check_text}")
            # 截屏显示
            SELENIUM_LOG_SCREEN(wd, "50%", "User_Manage", "User_Query", f"{name}_检查搜索结果")
            CHECK_POINT("检查搜索结果", check_text == query_text)

        elif query_type == 'departname':
            check_text = elment_get_text(
                (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(3) > div:nth-child(1)"), wd)
            # INFO输出获取的文本
            INFO(f"检查搜索结果：{check_text}")
            # 截屏显示
            SELENIUM_LOG_SCREEN(wd, "50%", "User_Manage", "User_Query", f"{name}_检查搜索结果")
            CHECK_POINT("检查搜索结果", query_text in check_text)

        elif query_type == 'vague_account':
            check_text = elment_get_text(
                (By.CSS_SELECTOR, "tbody tr[class='el-table__row'] td:nth-child(2) div:nth-child(1)"), wd)
            # INFO输出获取的文本
            INFO(f"检查搜索结果：{check_text}")
            # 截屏显示
            SELENIUM_LOG_SCREEN(wd, "50%", "User_Manage", "User_Query", f"{name}_检查搜索结果")
            CHECK_POINT("检查搜索结果", query_text in check_text)

        elif query_type == 'vague_username':
            check_text = elment_get_text(
                (By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(3) > div:nth-child(1)"), wd)
            INFO(f"检查搜索结果：{check_text}")
            # 截屏显示
            SELENIUM_LOG_SCREEN(wd, "50%", "User_Manage", "User_Query", f"{name}_检查搜索结果")
            CHECK_POINT("检查搜索结果", query_text in check_text)

        if name == '用户查询_044':
            login_url = get_login_url_from_config("标准版预定系统")
            # 清除浏览器，再重新打开浏览器
            wd.get(login_url)
            # 最大化浏览器窗口
            wd.maximize_window()
            user_login("admin@ZDH", "Ubains@4321")
            enter_the_backend()

            INFO("打开账号管理下拉菜单")
            safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

            INFO("进入用户管理模块")
            safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)