from time import sleep
from hytest import *
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/账号管理/用户管理模块/用户修改密码.csv')

class User_Chanage_Pwd_000x:
    tags = ['用户管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 用户修改密码测试报告 --test 用户修改密码_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        username, new_password, check_password, check_text, back_check_text = self.para
        sleep(5)
        # 根据条件判断是否执行编辑用户的操作
        if name == '用户修改密码_001' or back_check_text == '修改成功':
            # 执行编辑用户操作的步骤
            STEP(1, f'选择用户：{username}，点击【修改密码】按钮')
            INFO(f'输入用户名：{username}进行搜索')
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), username, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            INFO('点击【修改密码】按钮')
            safe_click((By.XPATH, "//span[@class='el-tag el-tag--warning el-tag--light']"), wd)
            sleep(1)
            STEP(2, '检查二次确认弹窗UI')
            notify_text = elment_get_text((By.XPATH,
                                           "//body/div[contains(@class,'el-dialog__wrapper')]/div[contains(@aria-label,'修改密码')]/div[contains(@class,'el-dialog__header')]/span[1]"),
                                          wd)
            INFO(f'校验二次确认弹窗UI：{notify_text}')
            CHECK_POINT('校验二次确认弹窗UI', '修改密码' in notify_text)

        sleep(1)
        STEP(3, f'输入新密码：{new_password}，确认密码：{check_password}')
        # is_valid_password函数用于检查密码是否符合规范：11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合
        flag = is_valid_password(new_password)

        if flag == True or new_password == "":
            # 输入新密码和确认密码
            safe_send_keys((By.XPATH,
                            "//input[contains(@placeholder,'11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合')]"),
                           new_password, wd)
            safe_send_keys((By.XPATH, "//input[@placeholder='确认密码']"), check_password, wd)
            STEP(4, '点击确定按钮')
            INFO('点击确定按钮')
            safe_click((By.XPATH,
                        "//body/div[@class='el-dialog__wrapper']/div[@aria-label='修改密码']/div[@class='el-dialog__footer']/span[@class='dialog-footer']/button[1]"),
                       wd)
            sleep(2)
            STEP(5, '检查提示信息')
            if new_password == check_password:
                notify_text = get_notify_text(wd, (By.XPATH,"//p[@class='el-message__content']"), 'User_Manage',
                                              'User_Chanage_Pwd',
                                              f'{name}检查提示信息')
            else:
                notify_text = get_notify_text(wd, (By.XPATH,"//div[@class='el-message el-message--error']"), 'User_Manage',
                                              'User_Chanage_Pwd',
                                              f'{name}检查提示信息')

            INFO(f'校验修改密码提示信息：{notify_text}')
            CHECK_POINT('校验修改密码提示信息', notify_text == check_text)

        else:
            # 如果密码校验失败，输入密码并检查错误提示
            safe_send_keys((By.XPATH,
                            "//input[contains(@placeholder,'11位及以上的大小写字母和数字且连续3位及以上不重复和不连续组合')]"),
                           new_password, wd)
            safe_send_keys((By.XPATH, "//input[@placeholder='确认密码']"), check_password, wd)
            sleep(2)
            STEP(4, '检查提示信息')
            notify_text = get_notify_text(wd, (By.XPATH,"//div[@class='el-message el-message--error']"), 'User_Manage',
                                          'User_Chanage_Pwd',
                                          f'{name}检查提示信息')
            INFO(f'校验修改密码提示信息：{notify_text}')
            CHECK_POINT('校验修改密码提示信息', notify_text == check_text)

        if name == '用户修改密码_022':
            login_url = get_login_url_from_config("标准版预定系统")
            # 清除浏览器，再重新打开浏览器
            wd.get(login_url)
            # 最大化浏览器窗口
            wd.maximize_window()
            user_login("admin@ZDH", "Ubains@4321")
            enter_the_backend()
            # wd.refresh()
            INFO("打开账号管理下拉菜单")
            safe_click((By.XPATH, "//span[@class='aside_menu menu_account']"), wd)

            INFO("进入用户管理模块")
            safe_click((By.XPATH, "//li[contains(text(),'用户管理')]"), wd)