from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *
from 预定系统.Base.Mqtt_Send import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/MQTT模块/MQTT安卓上报_2000条.csv')
# csv_file_path = os.path.join(current_dir, '../../测试数据/MQTT模块/MQTT心跳上报_2000条.csv')

if __name__ == "__main__":
    # 读取配置文件
    configs = Mqtt.read_config_from_csv(csv_file_path)
    broker_address = "192.168.5.218"
    username = "mqtt@cmdb"  # 你的MQTT用户名
    password = "mqtt@webpassw0RD"  # 你的MQTT密码
    port = 1883
    num_repeats = 200  # 重复执行的次数
    interval_between_repeats = 1  # 每次重复之间的间隔时间（秒）

    # 创建 MQTT 客户端实例
    mqtt_client = Mqtt(broker_address, port, username, password)

    # 设置 MQTT 服务器的用户名和密码
    mqtt_client.connect()

    try:
        # 连接到 MQTT 服务器
        mqtt_client.connect()

        print('连接成功')

        for repeat in range(num_repeats):
            logging.info(f"开始第 {repeat + 1} 次上报")

            # 遍历配置文件中的每一行数据
            for config in configs:
                #打印当前MQTT消息配置信息
                Mqtt.print_current_config(config)
                # 构建消息内容
                topic = config["topic"]
                current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                print(config)
                message = Mqtt.build_message(config, current_time, topic)

                # 发送消息
                mqtt_client.publish(topic, message)

                # 每次发送之间可以设置一个间隔时间
                time.sleep(interval_between_repeats)

            # 每次重复之间设置一个间隔时间
            time.sleep(interval_between_repeats)

    except Exception as e:
        logging.error(f"发送消息时发生错误: {e}")

    finally:
        # 断开与 MQTT 服务器的连接
        mqtt_client.disconnect()