from appium.webdriver.common.appiumby import AppiumBy
import logging
from time import sleep
from hytest import *
import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *

# 配置日志记录
logging.basicConfig(level=logging.DEBUG, format='%(asctime)s - %(levelname)s - %(message)s')

class Exhibition_hall_NoPaperinspection_000x:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 无纸化会议操作测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 无纸化1.0测试
    """
    tags = ['无纸化1.0测试']

    def teststeps(self):
        app_drive = None
        wd = GSTORE['wd']
        try:
            # 腾讯："com.tencent.wemeet.app"   ".StartupActivity"
            # 无纸化1.0："com.ubains.system.develop.mqtt" "com.ubains.system.activity.RouterActivity"
            app_drive = app_setup_driver("Android", "7.1.2", "展厅无纸化设备1.0", "com.ubains.system.develop.mqtt", "com.ubains.system.activity.RouterActivity","192.168.5.158:5555")
            app_drive.implicitly_wait(20)  # 设置缺省等待时间

            # 使用显式等待来等待元素出现
            logging.info("等待登录页加载...")
            sleep(10)
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "无纸化首页截图")
            app_drive.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\无纸化首页截图.png")

            # 定位【会议签到】按钮元素，并点击按钮
            logging.info("尝试定位【会议签到】按钮元素，并点击按钮")
            meeting_button = app_drive.find_element(AppiumBy.XPATH,
                                                        "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.LinearLayout[2]/android.widget.RelativeLayout/android.widget.TextView")
            logging.info("定位【会议签到】成功")
            # 点击【会议签到】按钮
            meeting_button.click()
            logging.info("点击【会议签到】按钮成功")
            sleep(2)
            STEP(2, "无纸化会议信息")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "无纸化会议信息截图")
            app_drive.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\无纸化会议信息截图.png")

            logging.info("定位【会议议题】按钮")
            meeting_issue_button = app_drive.find_element(AppiumBy.XPATH,
                                                              "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.RadioGroup/android.widget.RadioButton[2]")
            logging.info("定位【会议议题】按钮成功")
            meeting_issue_button.click()
            logging.info("点击【会议议题】按钮成功")
            sleep(2)

            logging.info("定位议题名称元素")
            issue_file_button = app_drive.find_element(AppiumBy.XPATH,
                                                            "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.TextView")
            logging.info("定位议题名称元素成功")
            issue_file_button.click()
            logging.info("点击议题名称元素成功")
            sleep(5)

            issue_file_locator = [
                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout[2]/android.widget.RelativeLayout/android.widget.Button",
                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout[3]/android.widget.RelativeLayout/android.widget.Button",
                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout[4]/android.widget.RelativeLayout/android.widget.Button",
                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout[5]/android.widget.RelativeLayout/android.widget.Button",
                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/androidx.drawerlayout.widget.DrawerLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.view.ViewGroup/androidx.recyclerview.widget.RecyclerView/android.widget.RelativeLayout[6]/android.widget.RelativeLayout/android.widget.Button"
            ]

            STEP(3, "无纸化议题信息")
            INFO("请查看议题显示")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "议题文件截图")
            app_drive.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\议题文件截图.png")
            for i in range(1,4):
                logging.info(f"定位议题文件{i}的【查看】按钮元素")
                issue_file = app_drive.find_element(AppiumBy.XPATH,
                                                    issue_file_locator[i-1])
                logging.info(f"定位议题文件{i}的【查看】按钮元素成功")
                issue_file.click()
                logging.info(f"点击议题文件{i}的【查看】按钮元素成功")
                sleep(5)
                INFO(f"请查看议题文件{i}显示")
                SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", f"议题文件{i}截图")
                app_drive.get_screenshot_as_file(
                    fr"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\议题文件{i}截图.png")
                sleep(2)
                app_drive.back()
                sleep(2)
                app_drive.back()
                sleep(2)
                issue_file_button.click()
                # sleep(2)
                # 调用方法实现界面向下滚动效果
                # swipe_up(app_drive)
                sleep(2)

        except Exception as e:
            logging.error(f"发生错误: {e}", exc_info=True)