import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *

class same_screen_share_000x:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 无纸化同屏测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 无纸化1.0同屏
    """
    tags = ['无纸化1.0同屏', '无纸化1.0测试']

    def teststeps(self):
        wd = GSTORE['wd']
        app_drive1 = None
        app_drive2 = None

        try:
            # 初始化第一个设备
            app_drive1 = app_setup_driver("Android", "7.1.2", "展厅无纸化设备1.0", "com.ubains.system.develop.mqtt", "com.ubains.system.activity.RouterActivity","192.168.5.156:5555")
            app_drive1.implicitly_wait(20)  # 设置缺省等待时间

            # 初始化第二个设备
            app_drive2 = app_setup_driver("Android", "7.1.2", "展厅无纸化设备1.0", "com.ubains.system.develop.mqtt", "com.ubains.system.activity.RouterActivity","192.168.5.157:5555")
            app_drive2.implicitly_wait(20)  # 设置缺省等待时间

            # 使用显式等待来等待元素出现
            logging.info(f"等待登录页加载.")
            sleep(10)

            # 进入后台设置界面
            logging.info(f"尝试进入后台设置")
            back_setting_button = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                               '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout/android.widget.LinearLayout[1]/android.widget.RelativeLayout[3]')
            back_setting_button.click()
            sleep(5)
            setting_button = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                          '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.RelativeLayout[2]')
            setting_button.click()
            sleep(5)

            # 输入管理员密码点击【确定】按钮
            logging.info(f"尝试输入管理员密码点击【确定】")
            admin_pwd_input = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                           '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.RelativeLayout/androidx.appcompat.widget.LinearLayoutCompat/android.widget.EditText')
            admin_pwd_input.send_keys("000000")
            sleep(3)

            # 点击确定按钮
            confirm_button = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                          '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.view.ViewGroup/android.widget.Button[2]')
            confirm_button.click()
            sleep(5)

            # 先截取另一台设备的界面做参照物
            INFO(f"这是设备B的界面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "同屏前-无纸化设备B界面截屏")
            app_drive2.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\同屏前-无纸化设备B界面截屏.png")

            # 进入【同屏和视频服务】界面
            logging.info(f"进入【同屏和视频服务】")
            same_screen_module = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                              '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.RelativeLayout/android.widget.LinearLayout/android.widget.RelativeLayout[5]/android.widget.TextView')
            same_screen_module.click()
            sleep(2)

            # 点击右上角【开始】按钮
            same_screen_button = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                              '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.view.ViewGroup/android.widget.FrameLayout[2]/android.view.ViewGroup/android.widget.FrameLayout/android.view.ViewGroup/android.widget.Button[1]')
            same_screen_button.click()
            sleep(3)

            # 截取设备A和设备B的同屏画面截屏
            INFO(f"这是设备A同屏共享的界面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "同屏后-无纸化设备A界面截屏")
            app_drive1.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\同屏后-无纸化设备A界面截屏.png")

            INFO(f"这是设备B同屏共享的界面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "同屏后-无纸化设备B界面截屏")
            app_drive2.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\同屏后-无纸化设备B界面截屏.png")

            # 调用图片对比函数判断相似度
            # image1_path = r"/预定系统/reports/imgs/Exhibit_Inspect/No_PaperLess/同屏后-无纸化设备A界面截屏.png"
            # image2_path = r"/预定系统/reports/imgs/Exhibit_Inspect/No_PaperLess/同屏后-无纸化设备B界面截屏.png"
            #
            # if not os.path.exists(image1_path):
            #     logging.error(f"图片 {image1_path} 不存在")
            #     exit(1)
            # if not os.path.exists(image2_path):
            #     logging.error(f"图片 {image2_path} 不存在")
            #     exit(1)
            #
            #     # 对比两张截图的相似度
            # result1 = classify_hist_with_split(image1_path, image2_path)
            #
            # # 确保 result1 是一个标量值
            # if isinstance(result1, numpy.ndarray):
            #     result1 = result1.item()
            # # 输出相似度
            # INFO("相似度为：" + "%.2f%%" % (result1 * 100))

            sleep(1)
            # 退出同屏操作
            share_quit_button = self.find_element_with_retry(app_drive1, AppiumBy.XPATH,
                                                             '/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.view.ViewGroup/android.widget.FrameLayout[2]/android.view.ViewGroup/android.widget.FrameLayout/android.view.ViewGroup/android.widget.Button[2]')
            INFO("执行退出同屏操作")
            share_quit_button.click()
            # 退出同屏后截屏操作
            INFO(f"这是设备A关闭同屏共享的界面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "取消同屏-无纸化设备A界面截屏")
            app_drive1.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\取消同屏-无纸化设备A界面截屏.png")

            INFO(f"这是设备B关闭同屏共享的界面")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "No_PaperLess", "取消同屏-无纸化设备B界面截屏")
            app_drive2.get_screenshot_as_file(
                r"D:\GithubData\自动化\ubains-module-test\预定系统\reports\imgs\Exhibit_Inspect\No_PaperLess\取消同屏-无纸化设备B界面截屏.png")
            sleep(10)


        except Exception as e:
            logging.error(f"发生错误: {e}", exc_info=True)

    def find_element_with_retry(self, driver, by, value, max_retries=3, retry_delay=5):
        for _ in range(max_retries):
            try:
                return driver.find_element(by, value)
            except Exception as e:
                logging.warning(f"Failed to find element")