import sys
import os

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/展厅巡检/会议预约.csv')
# 定义时间格式
time_format = "%H:%M"

class ExhibitionHallInspection:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 展厅会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 展厅巡检会议系统
    """
    tags = ['展厅巡检','展厅巡检会议系统']
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              conference_name:会议室名称
              message_name:会议名称
              message_type:会议类型
              book_type:预约类型
              book_start_time:会议开始时间
              book_end_time:会议结束时间
              message_notification:消息提醒时间
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name,message_name,book_type,issue_name,book_start_time,book_end_time,message_notification,check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"),wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"),conference_name,wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"),wd)
        sleep(1)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"),wd)
        sleep(1)

        # 在会议预定第一步界面进行数据填入
        STEP(3,"会议第一步数据填写")
        INFO(f"输入会议名称：{message_name}，选择会议类型：视讯融合会议，选择预约类型：{book_type}，选择会议开始时间：{book_start_time}，选择会议结束时间：{book_end_time}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"),message_name,wd)

        # 判断会议类型
        safe_click((By.XPATH, f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='SMC3.0视频会议']"),wd)
        safe_click((By.XPATH, f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='讯飞语音转录']"),wd)
        safe_click((By.XPATH, f"//div[@class='reserve_input']//span[@class='el-checkbox__label'][normalize-space()='腾讯会议']"),wd)
        sleep(2)

        # 选择普通会议
        safe_click((By.XPATH, f"//span[contains(text(),'{book_type}')]"), wd)
        sleep(1)

        # 调用函数添加议题
        INFO("添加议题文件")
        issue_send_and_upload(wd, 2, issue_name)
        sleep(2)

        # 选择签到时间
        INFO("选择提前30分钟开始签到")
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[2]"),wd)
        safe_click((By.XPATH, "(//span[@class='el-switch__core'])[3]"),wd)
        sleep(1)
        safe_send_keys((By.XPATH, "//input[@id='input_checkin']"), "30", wd)

        # 选择会议开始时间
        current_time = get_current_time_formatted()
        INFO(f"获取当前的时间{current_time}")
        safe_click((By.XPATH, f"//div[normalize-space()='{current_time}']"), wd)
        sleep(1)

        # 在会议预定第二步界面进行数据填入
        STEP(4, "会议第二步数据填写")
        # 点击【下一步】进入会议预定第二步界面
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"),wd)
        sleep(1)

        # 根据参会人名称搜搜对应参会人
        ipn = ['赵嘉诚','CZJ','马晓丽','王兵','陈林','李立键','丁海洪','刘建胜','潘松林','卢培锽','黄史恭','罗一龙','彭甘宇','黄丞锋']#
        for i in range(0, 13):
            safe_send_keys((By.XPATH, "//input[@placeholder='账号/用户名']"), ipn[i], wd)
            send_keyboard((By.XPATH, "//input[@placeholder='账号/用户名']"), wd)
            sleep(1)
            # 选择内部参会人
            safe_click((By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"), wd)
            # 获取已选的参会人名称
            # notify_text = elment_get_text((By.XPATH, f"//span[normalize-space()='{ipn[i]}']"), wd)
        INFO(f"已选择参会人：{ipn}")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Meeting_Message", "选择内部参会人")

        # 点击【下一步】按钮
        safe_click((By.XPATH,"//div[contains(text(),'下一步')]"),wd)
        sleep(1)
        safe_click((By.XPATH,"//div[contains(text(),'下一步')]"),wd)

        # 进入会议预约第三步进行填写
        STEP(5, "会议第三步数据填写")

        # 选择消息提醒时间
        INFO(f"选择消息提醒时间：{message_notification}")
        # 判断消息提醒时间是否为全选
        if message_notification == "全选":
            # 点击【全选】按钮
            safe_click((By.XPATH,"//div[@class='Reminds']//span[@class='el-checkbox__label'][contains(text(),'全选')]"),wd)
            sleep(1)
        else:
            # 选择对应的消息提醒时间
            safe_click((By.XPATH, f"//span[contains(text(),'{message_notification}')]"), wd)
            sleep(1)

        # 点击【确定】按钮
        STEP(6, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(text(),'确定')]"),wd)

        # 点击最后【确定】按钮，预定成功后会跳转至已预定界面
        STEP(7, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(@aria-label,'会议信息')]//span[contains(text(),'确定')]"),wd)
        sleep(3)

        # 搜索会议名称
        safe_send_keys((By.XPATH,"//input[@placeholder='输入关键字搜索']"),message_name,wd)
        send_keyboard((By.XPATH,"//input[@placeholder='输入关键字搜索']"), wd)

        # 在已预定列表界面【提前开始】会议
        INFO("提前开始会议")
        safe_click((By.XPATH,"//span[contains(text(),'更多操作')]"),wd)
        safe_click((By.XPATH,"//li[contains(text(),'会议状态')]"),wd)
        sleep(2)
        safe_click((By.XPATH,"//div[@slot='footer']//span[contains(text(),'确定')]"),wd)
        sleep(10)

        STEP(8, "检查门口屏会议显示")
        # 进入后台-安卓信息界面截屏查看门口屏显示
        safe_click((By.XPATH,"(//img[contains(@title,'后台系统')])[1]"),wd)
        sleep(5)
        # 切换到新打开的窗口
        wd.switch_to.window(wd.window_handles[1])
        sleep(4)
        safe_click((By.XPATH,"(//span[contains(text(),'设备管理')])[1]"),wd)
        safe_click((By.XPATH,"(//li[contains(text(),'安卓信息')])[1]"),wd)
        INFO("进入安卓信息界面，查看门口屏设备列表，请查看设备列表状态显示是否正常")
        sleep(5)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Android", "门口屏设备列表")

        # 点击【应用截屏】按钮
        safe_click((By.XPATH,"(//span[contains(text(),'应用截屏')])[1]"),wd)
        sleep(30)
        INFO("查看门口屏截屏显示，请查看门口屏截屏功能是否正常")
        # 截屏查看门口屏的显示
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Android", "门口屏截屏")
        # 返回上一级界面
        safe_click((By.XPATH,"//div[@aria-label='门口屏截屏']//i[@class='el-dialog__close el-icon el-icon-close']"), wd)

        STEP(9, "检查会控界面功能")
        # 返回前台已预定列表界面
        # safe_click((By.XPATH,"//img[@title='返回预定首页']"),wd)
        # 切换到初始的窗口
        wd.switch_to.window(wd.window_handles[0])
        sleep(5)
        safe_click((By.XPATH,"//span[contains(text(),'已预订会议')]"),wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "查看会控按钮")

        # 判断是否存在会控按钮
        INFO("判断是否存在【进入会控】按钮")
        MeetingControlButton = ""
        MeetingControlButton = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.XPATH, "//span[contains(text(),'进入会控')]"))
        )
        if MeetingControlButton  is not None:
            INFO("存在【进入会控】按钮")
            CHECK_POINT("检查是否存在【进入会控】按钮", True)
            MeetingControlButton.click()
        else:
            INFO("不存在【进入会控】按钮")
            CHECK_POINT("检查是否存在【进入会控】按钮", False)
        sleep(5)

        # 切换窗口2，转到会控界面
        wd.switch_to.window(wd.window_handles[2])

        # 会控操作
        STEP(10, "检查会控界面功能")
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "检查会控界面功能")
        INFO("请检查会控界面功能是否正常")

        # 添加SMC会场
        INFO("点击【添加与会人】按钮")
        safe_click((By.XPATH,"//body/div[@id='app']/div[@id='Energy']/div[@class='main']/div[@class='mainList']/div[@class='main_l']/div[@class='mainFNC']/img[1]"),wd)
        safe_send_keys((By.XPATH,"//input[@placeholder='搜索与会方']"),"指挥",wd)
        sleep(1)
        send_keyboard((By.XPATH,"//input[@placeholder='搜索与会方']"), wd)
        sleep(1)
        safe_click((By.XPATH,"//div[contains(@class,'el-table el-table--fit el-table--enable-row-hover el-table--enable-row-transition')]//div[contains(@class,'el-table__header-wrapper')]//span[contains(@class,'el-checkbox__inner')]"),wd)

        # 添加展厅指挥中心
        INFO("添加腾讯会场")
        safe_click((By.XPATH,"//div[@id='tab-TencentUser']"),wd)
        safe_click((By.XPATH,"//li[normalize-space()='6']"),wd)
        sleep(1)
        safe_click((By.XPATH,"//li[normalize-space()='8']"),wd)
        sleep(1)
        safe_click((By.XPATH,"//body[1]/div[1]/div[1]/div[3]/div[1]/div[2]/div[1]/div[1]/div[1]/div[2]/div[3]/div[1]/div[1]/div[1]/div[3]/table[1]/tbody[1]/tr[4]/td[1]/div[1]/label[1]/span[1]/span[1]"),wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "添加会场功能")
        safe_click((By.XPATH,"//div[contains(text(),'确定')]"),wd)
        sleep(2)
        # 点击右上角【X】按钮返回上一级界面
        # safe_click((By.XPATH,"//div[@class='el-dialog myDialog addDialog']//i[@class='el-dialog__close el-icon el-icon-close']"), wd)
        sleep(1)

        # 一键呼叫会场
        # safe_click((By.XPATH,"//body/div[@id='app']/div[@id='Energy']/div[contains(@class,'main')]/div[contains(@class,'mainList')]/div[contains(@class,'main_l')]/div[contains(@class,'mainFNC')]/img[1]"),wd)

        # 选择分屏功能
        INFO("选择分屏功能")
        sleep(20)
        safe_click((By.XPATH, "//li[4]//img[1]"), wd)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "分屏功能")

        # 将左侧会场拖拽到右侧画面进行播放
        INFO("将左侧会场拖拽到右侧画面进行播放")
        # 拖拽展厅会议室
        single_click_and_drag((By.XPATH,"//span[contains(text(),'展厅会议室')]"), (By.XPATH,"(//div)[118]") , wd)
        sleep(5)
        wd.refresh()
        sleep(5)
        # 拖拽指挥中心会场终端
        single_click_and_drag((By.XPATH,"//span[contains(text(),'展厅指挥室TE40')]"), (By.XPATH,"(//div)[119]") , wd)
        sleep(5)
        # 拖拽第一个SMC连接器
        single_click_and_drag((By.CSS_SELECTOR,"body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(2) > div:nth-child(1) > div:nth-child(1) > div:nth-child(1) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1) > span:nth-child(1)"),(By.XPATH,"(//div)[120]"), wd)
        sleep(4)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "会场画面控制")

        STEP(11, "检查会控界面功能")
        INFO("开启展厅会议室麦克风")
        sleep(2)
        safe_click((By.XPATH,"(//img[@title='解除静音'])[2]"),wd)
        SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "MeetingControl", "会场画面控制")