import logging
from time import sleep
from hytest import *
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..')))
from 预定系统.Base.app_base import *

# 配置日志记录
logging.basicConfig(level=logging.DEBUG, format='%(asctime)s - %(levelname)s - %(message)s')

class ExhibitionhallControl:
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 展厅中控屏测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 展厅中控屏
    """
    tags = ['展厅中控屏' , '展厅巡检']

    def teststeps(self):
        """
        执行测试步骤以自动化测试腾讯会议应用的登录和会议加入流程。
        该方法初始化应用驱动，等待应用加载，定位并点击会议按钮，加入会议，并截取会议画面。
        """
        app_drive = None
        wd = GSTORE['wd']
        try:
            # 初始化应用驱动，连接到指定的设备和应用
            app_drive = app_setup_driver("Android", "5.1.1", "UT-13", "com.ubains.local.gviewer",
                                         "com.ubains.ub.gview.SplashActivity", "192.168.5.112:5555")
            app_drive.implicitly_wait(60)  # 设置缺省等待时间

            # 使用显式等待来等待元素出现
            logging.info("等待首页加载...")

            STEP(2, "检查灯光控制功能")
            # 这是灯光开启前的截图
            INFO("请检查灯光开启前的监控视频状态是否正常")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Control_Manage", "light_down")

            # 先截取当前空间的灯光状态图片
            light_rtsp_url = "rtsp://admin:huawei@123@192.168.4.15/LiveMedia/ch1/Media2"  # 替换为你的RTSP流地址
            logging.info("开始捕获RTSP流中的帧")
            if capture_frame_from_rtsp(light_rtsp_url, "light_down.png"):
                logging.info("帧捕获成功")
            else:
                logging.error("帧捕获失败")

            # 这是全部灯光关闭后在软件界面上的状态显示
            INFO("请检查中控屏软件的灯光关闭状态显示是否正常")
            # 截图获取当前软件的灯光控制界面
            get_screenshot_with_retry(wd,app_drive, "Exhibit_Inspect","Control_Manage", "light_all_off")
            # 调用灯光控制函数
            light_control(app_drive)

            # 这是全部灯光开启后在软件界面上的状态显示
            INFO("请检查中控屏软件的灯光开启状态显示是否正常")
            # 截图获取当前软件的灯光控制界面
            get_screenshot_with_retry(wd,app_drive, "Exhibit_Inspect","Control_Manage", "light_all_on")

            # 这是灯光开启后的截图
            INFO("请检查灯光开启后的监控视频状态是否正常")
            SELENIUM_LOG_SCREEN(wd, "75%", "Exhibit_Inspect", "Control_Manage", "light_on")

            # 先截取当前空间的灯光状态图片
            light_rtsp_url = "rtsp://admin:huawei@123@192.168.4.15/LiveMedia/ch1/Media2"  # 替换为你的RTSP流地址
            logging.info("开始捕获RTSP流中的帧")
            if capture_frame_from_rtsp(light_rtsp_url, "light_on.png"):
                logging.info("帧捕获成功")
            else:
                logging.error("帧捕获失败")

            # 切换灯光控制界面
            # 灯光测试结束后关闭灯光
            logging.info("尝试定位【灯光控制】按钮元素，并点击按钮")
            light_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                        "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.Button[3]")
            logging.info("定位成功")
            # 点击【灯光控制】按钮
            click_with_retry(light_button)
            sleep(10)
            # 调用灯光控制函数
            light_control(app_drive)

            STEP(3, "检查窗帘的升降功能")
            # 切换至窗帘控制界面
            logging.info("尝试定位【窗帘控制】按钮元素，并点击按钮")
            curtain_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                      "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.Button[4]")
            click_with_retry(curtain_button)
            sleep(10)
            # 调用窗口上升下降的函数
            curtain_control(app_drive, wd)

            STEP(3, "检查空调控制是否正常")
            # 切换至空调控制界面
            logging.info("尝试定位【空调控制】按钮元素，并点击按钮")
            air_conditioner_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                                  "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout[2]/android.widget.Button[5]")
            click_with_retry(air_conditioner_button)
            sleep(10)
            # 调用空调控制的函数
            air_condition_control(app_drive, wd)

            STEP(4, "检查指挥大屏控制是否正常")
            # 切换至指挥中心控制界面
            # 打开指挥中心大屏幕
            logging.info("尝试定位【开启指挥中心控制】按钮元素，并点击按钮")
            center_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                        "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout[3]/android.widget.Button[8]")
            click_with_retry(center_button)
            sleep(10)
            # 调用指挥中心控制函数
            command_centre_control(light_rtsp_url, app_drive, wd)

            STEP(5, "检查音乐控制功能是否正常")
            # 切换至音乐区域
            logging.info("尝试定位【音乐】按钮元素，并点击按钮")
            music_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                        "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout[4]/android.widget.Button[9]")
            click_with_retry(music_button)
            sleep(2)
            # 调用音乐控制函数
            music_control(app_drive, wd)
            sleep(10)

            STEP(6, "检查信息发布界面发布内容功能是否正常")
            logging.info("尝试定位【发布屏】按钮元素，并点击按钮")
            information_delivery = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                                "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout[5]/android.widget.Button[7]")
            logging.info("定位成功")
            click_with_retry(information_delivery)
            sleep(5)

            # 打开信息发布播放
            information_on_button = find_element_with_retry(app_drive, AppiumBy.XPATH,
                                                                 "/hierarchy/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.LinearLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout/android.widget.FrameLayout[6]/android.widget.Button[19]")
            logging.info("定位“发布屏”开启按钮")
            click_with_retry(information_on_button)
            sleep(5)
            logging.info("信息发布播放开启成功")
            # 调用信息发布控制函数
            information_control(app_drive, wd)

        except Exception as e:
            # 捕获并记录任何发生的错误
            logging.error(f"发生错误: {e}", exc_info=True)