import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/会议模板/会议模板再次预定.csv')
# 定义时间格式
time_format = "%H:%M"

class MessageTemplate_Book_000x:
    tags = ['会议模板功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --test 会议模板再次预定_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              query_message_name:查询的会议名称
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        query_template_name, book_start_time, book_end_time, check_text = self.para

        STEP(2, f'输入会议模板名称进行搜索：{query_template_name}')
        # 输入会议模板名称并进行搜索
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), query_template_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_Template", "Template_Book", f"{name}_查询结果")
        sleep(2)

        notify_text = elment_get_text(
            (By.CSS_SELECTOR, "tbody tr[class='el-table__row'] td:nth-child(1) div:nth-child(1)"), wd)
        INFO(f"查询结果为：{notify_text}")
        CHECK_POINT("查询结果是否正确", query_template_name in notify_text)

        STEP(3, f'选择模板点击【再次预定】按钮')
        safe_click((By.XPATH, "//span[contains(text(),'再次预定')]"), wd)
        sleep(2)

        SELENIUM_LOG_SCREEN(wd, "50%", "Message_Template", "Template_Book", f"{name}_再次预定")

        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"), "模板会议", wd)

        # 选择会议时间
        # 将字符串转换为时间对象
        start_time = datetime.strptime(book_start_time, time_format)
        end_time = datetime.strptime(book_end_time, time_format)

        # 如果需要将时间差转换为分钟数
        time_diff_minutes = (end_time - start_time).total_seconds() / 60
        INFO(f"时间差为：time_diff_minutes")

        # 判断如果开始时间与结束时间相等，则不重复点击
        if book_start_time == book_end_time:
            INFO(f"开始时间与结束时间相等，选择时间块：{book_start_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
        elif book_start_time != book_end_time:
            INFO(f"开始时间与结束时间不相等，选择时间块：{book_start_time}，{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
        sleep(2)

        # 判断时间差是否大于最大预约时长1小时，即60分钟
        if time_diff_minutes > 60:
            INFO(f"时间差大于最大预约时长1小时，选择【超出预约时长】")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}_超出预约时长")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("超出预约时长提示是否正确", "最大预定时间 1 小时" in notify_text)
            sleep(2)

            # 不选时间点击【下一步】查看提示信息
            INFO("不选时间点击【下一步】查看提示信息")
            safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}请选择会议时间提示信息")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("未选时间提示是否正确", "请选择会议时间" in notify_text)
            sleep(1)

            # 重新选择时间，将字符串转换为时间对象
            time_obj = datetime.strptime(book_end_time, time_format)
            time_obj_minus_5_minutes = time_obj - timedelta(minutes=30)

            # 将时间对象转换回字符串
            book_end_time = time_obj_minus_5_minutes.strftime(time_format)
            INFO(f"重新选择结束时间为：{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
            sleep(2)

        STEP(5, "连续点击【下一步】按钮创建会议")
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        # safe_click((By.XPATH, "//div[@class='header_Quick']"), wd)
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        sleep(2)

        INFO("点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(text(),'确定')]"), wd)

        safe_click((By.XPATH, "//div[@aria-label='会议信息']//span[contains(text(),'确定')]"), wd)
        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                      "Message_History", "Message_Book", f"{name}预定成功提示信息")
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_History", "Message_Book", f"{name}_再次预定提示信息")
        INFO(f"预定成功提示信息为：{notify_text}")
        CHECK_POINT("预定成功提示是否正确", notify_text == check_text)

        # 清除数据
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), "模板会议", wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(2)
        safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
        sleep(2)
        safe_click((By.XPATH, "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"), wd)
        sleep(2)