import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/会议模板/会议模板查询.csv')
# 定义时间格式
time_format = "%H:%M"

class MessageTemplate_Query_000x:
    tags = ['会议模板功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --test 会议模板查询_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              query_message_name:查询的会议名称
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        query_template_name, query_type = self.para

        STEP(2, f'输入会议模板名称进行搜索：{query_template_name}')
        # 输入会议模板名称并进行搜索
        safe_send_keys((By.XPATH,"//input[@placeholder='输入关键字搜索']"), query_template_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_Template", "Template_Query", f"{name}_查询结果")
        sleep(2)

        STEP(3, f'检查查询结果')
        if query_type == "错误查询":
            notify_text = elment_get_text((By.XPATH, "//span[contains(@class,'el-table__empty-text')]"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果是否正确", "暂无数据" in notify_text)
        else:
            notify_text = elment_get_text(
                (By.CSS_SELECTOR, "tbody tr[class='el-table__row'] td:nth-child(1) div:nth-child(1)"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果是否正确", query_template_name in notify_text)