import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/区域管理模块/区域编辑.csv')

class Area_Edit_000x:
    tags = ['区域管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 区域编辑测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 区域编辑_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以区域新增功能。
            本函数根据点击区域右侧【编辑】按钮，输入区域名称，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出区域名称和检查文本
        name = self.name
        area_name, new_area_name, check_text = self.para

        if name == "区域编辑_001":
            # 步骤1：点击父级【添加】按钮
            STEP(1, f"点击父级【添加】按钮")
            safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)
            sleep(2)
            # 获取并检查父级区域新增提示信息
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage",
                                          "Area_Edit",
                                          f"{name}_检查父级区域新增提示信息")
            INFO(f"获取到父级区域新增提示文本：{notify_text}")
            CHECK_POINT("新增提示文本是否与预期相符", notify_text == "添加成功")

        # 步骤2：检查区域新增的默认名称
        STEP(2, f"检查区域新增的默认名称")
        sleep(1)
        notify_text = elment_get_text((By.XPATH, f"//span[contains(text(),'{area_name}')]"), wd)
        INFO(f"获取到新增区域的名称：{notify_text}")
        CHECK_POINT("新增区域的默认名称是否与预期相符", area_name in notify_text)

        STEP(3,"选择区域点击【重命名】按钮")
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'重命名')]"), wd)
        sleep(1)
        notify_text = elment_get_text((By.XPATH, "//span[@class='el-dialog__title'][contains(text(),'重命名')]"),wd)
        INFO(f"获取到重命名弹窗标题：{notify_text}")
        CHECK_POINT("重命名弹窗标题是否与预期相符", notify_text == "重命名")

        STEP(4,f"输入区域名称{new_area_name}")
        INFO(f"输入区域名称：{new_area_name}")
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入区域名称']"),new_area_name,wd)
        sleep(1)
        safe_click((By.XPATH, "(//span[contains(text(),'确定')])[4]"), wd)
        sleep(2)

        STEP(5,f"检查编辑后的区域名称")
        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage", "Area_Edit",
                                      f"{name}_检查编辑提示信息")
        INFO(f"获取到编辑提示信息：{notify_text}")
        CHECK_POINT("编辑提示信息是否与预期相符", notify_text == check_text )

        # 清除数据
        if name == "区域编辑_005":
            INFO("清除测试数据")
            safe_click((By.XPATH, "//span[contains(text(),'删除')]"),wd)
            sleep(1)
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[5]"), wd)
            sleep(2)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage", "Area_Edit",
                                         f"{name}_检查删除提示信息")
            INFO(f"获取到删除提示信息：{notify_text}")
            CHECK_POINT("删除提示信息是否与预期相符", notify_text == "删除成功")