import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/区域管理模块/区域删除.csv')

class Area_Delete_000x:
    tags = ['区域管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 区域删除测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 区域删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以区域新增功能。
            本函数根据点击【新增】按钮，增加区域，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出区域名称和检查文本
        name = self.name
        del_type, check_text = self.para

        # 根据del_type的值，执行不同的测试步骤
        if del_type == "删除子区域":
            # 步骤1：点击子区域的【删除】按钮
            STEP(1, f"点击子区域的【删除】按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'删除')])[3]"), wd)
            sleep(1)

            # 步骤2：检查弹窗内容
            STEP(2, f"检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此区域?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容是否正确", notify_text == "是否要删除此区域?")

            # 步骤3：点击【确定】按钮
            STEP(3, f"点击【确定】按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[5]"), wd)
            sleep(1)

            # 步骤4：检查删除后的提示信息
            STEP(4, f"检查删除后的提示信息")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage",
                                          "Area_Del", f"{name}_检查子区域删除提示信息")
            INFO(f"删除后的提示信息：{notify_text}")
            CHECK_POINT("删除后的提示信息是否正确", notify_text == check_text)

        elif del_type == "删除父区域":
            # 步骤1：点击父区域的【删除】按钮
            STEP(1, f"点击父区域的【删除】按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'删除')])[1]"), wd)
            sleep(1)

            # 步骤2：检查弹窗内容
            STEP(2, f"检查弹窗内容")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'是否要删除此区域?')]"), wd)
            INFO(f"弹窗内容：{notify_text}")
            CHECK_POINT("弹窗内容是否正确", notify_text == "是否要删除此区域?")

            # 步骤3：点击【确定】按钮
            STEP(3, f"点击【确定】按钮")
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[5]"), wd)
            sleep(1)

            # 步骤4：检查父区域删除后的提示信息
            STEP(4, f"检查父区域删除后的提示信息")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Area_Manage",
                                          "Area_Del", f"{name}_检查父区域删除提示信息")
            INFO(f"删除后的提示信息：{notify_text}")
            CHECK_POINT("删除后的提示信息是否正确", notify_text == check_text)

            if name == "区域删除_002":
                wd.refresh()