import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/功能管理模块/功能查询.csv')

class Function_Query_000x:
    tags = ['会议室功能管理' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 功能查询测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 功能查询_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以用户新增功能。
            本函数根据参数输入账号、用户名、密码、确认密码、部门、性别、手机号和邮箱，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        function_name, query_type = self.para

        # 根据查询类型执行不同的测试步骤
        if query_type == "精确查询":
            INFO(f"精确查询功能：{function_name}")
            # 步骤1: 输入功能名称
            STEP(1, f"输入功能名称：{function_name}")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), function_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)

            # 步骤2: 检查查询结果
            STEP(2, "检查查询结果")
            notify_text = elment_get_text((By.XPATH, "//tbody/tr[1]/td[2]/div[1]"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果正确", notify_text == function_name)

        elif query_type == "模糊查询":
            INFO(f"模糊查询功能：{function_name}")
            # 步骤1: 输入功能名称
            STEP(1, f"输入功能名称：{function_name}")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), function_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)

            # 步骤2: 检查查询结果
            STEP(2, "检查查询结果")
            notify_text = elment_get_text((By.XPATH, "//tbody/tr[1]/td[2]/div[1]"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果正确", function_name in notify_text)

        elif query_type == "错误查询":
            INFO(f"错误查询功能：{function_name}")
            # 步骤1: 输入功能名称
            STEP(1, f"输入功能名称：{function_name}")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), function_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)

            # 步骤2: 检查查询结果
            STEP(2, "检查查询结果")
            notify_text = elment_get_text((By.XPATH, "//span[@class='el-table__empty-text']"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果正确", notify_text == "暂无数据")

        elif query_type == "分页查询":
            INFO(f"分页查询功能：{function_name}")
            # 步骤1: 切换分页
            STEP(1, f"切换分页")
            safe_click((By.XPATH, "//li[@class='number']"), wd)
            sleep(1)

            # 步骤2: 输入功能名称
            STEP(2, f"输入功能名称：{function_name}")
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), function_name, wd)
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
            sleep(1)

            # 步骤3: 检查查询结果
            STEP(2, "检查查询结果")
            notify_text = elment_get_text((By.XPATH, "//tbody/tr[1]/td[2]/div[1]"), wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果正确", notify_text in function_name)

        # 刷新页面元素
        if name == '功能查询_004':
            wd.refresh()