import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/会议室管理模块/会议室删除.csv')

class Conference_Delete_000x:
    tags = ['会议室管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议室删除测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 会议室删除_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室删除功能。
            本函数根据参数输入会议室名称进行搜索并删除会议室，并检查删除后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        conference_name, del_type, check_text = self.para

        STEP(1, f"在会议室列表查询：{conference_name}")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), conference_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
        sleep(1)

        if del_type == "单个删除":
            STEP(2, f"选择单个删除")
            safe_click((By.XPATH, "(//i[contains(@class,'el-icon-delete')][contains(text(),'删除')])[1]"),wd)
            sleep(1)

            STEP(3,"检查删除弹窗的文本提示语")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'确定删除此会议室?')]"),wd)
            INFO(f"删除弹窗的文本提示语为：{notify_text}")
            CHECK_POINT("删除弹窗的文本提示语检查", notify_text == "确定删除此会议室?")

            STEP(4, "点击确定按钮")
            safe_click((By.XPATH, "//button[@class='el-button el-button--default el-button--small el-button--primary ']//span[contains(text(),'确定')]"),wd)
            sleep(1)

            STEP(5, f"检查删除后的提示信息")
            notify_text = get_notify_text(wd,(By.XPATH, "//p[@class='el-message__content']"),'Conference_Manage','Conference_Del',f"{name}_会议室删除提示信息")
            INFO(f"删除后的提示信息为：{notify_text}")
            CHECK_POINT("删除后的提示信息检查", notify_text == check_text)

        elif del_type == "取消删除":
            STEP(2, f"选择单个删除")
            safe_click((By.XPATH, "(//i[contains(@class,'el-icon-delete')][contains(text(),'删除')])[1]"), wd)
            sleep(1)

            STEP(3, "检查删除弹窗的文本提示语")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'确定删除此会议室?')]"), wd)
            INFO(f"删除弹窗的文本提示语为：{notify_text}")
            CHECK_POINT("删除弹窗的文本提示语检查", notify_text == "确定删除此会议室?")

            STEP(4, "点击取消按钮")
            safe_click((By.XPATH, "//button[@class='el-button el-button--default el-button--small btn-custom-cancel']//span[contains(text(),'取消')]"),wd)
            sleep(1)

            STEP(5, f"检查取消删除后的提示信息")
            notify_text = get_notify_text(wd,(By.XPATH, "//p[@class='el-message__content']"),"Conference_Manage","Conference_Del",f"{name}_会议室取消删除提示信息")
            INFO(f"取消删除后的提示信息为：{notify_text}")
            CHECK_POINT("取消删除后的提示信息检查", notify_text == check_text)

        elif del_type == "批量删除":
            STEP(2, f"拓展分页")
            safe_click((By.XPATH, "//input[contains(@placeholder,'请选择')]"),wd)
            sleep(1)
            safe_click((By.XPATH,"//span[contains(text(),'20条/页')]"),wd)
            sleep(1)

            STEP(3, f"点击【全选】按钮")
            safe_click((By.XPATH,"//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"),wd)
            sleep(1)

            STEP(4, f"点击【批量删除】按钮")
            safe_click((By.XPATH,"//span[contains(text(),'批量删除')]"),wd)
            sleep(1)

            STEP(5, f"检查批量删除弹窗的文本提示语")
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'确定批量删除会议室?')]"),wd)
            INFO(f"批量删除弹窗的文本提示语为：{notify_text}")
            CHECK_POINT("批量删除弹窗的文本提示语检查", notify_text == "确定批量删除会议室?")

            STEP(6, "点击【确定】按钮")
            safe_click((By.XPATH,"//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),wd)
            sleep(1)

            STEP(7, f"检查批量删除后的提示信息")
            notify_text = get_notify_text(wd,(By.XPATH, "//p[@class='el-message__content']"),"Conference_Manage","Conference_Del",f"{name}_会议室批量删除提示信息")
            INFO(f"批量删除后的提示信息为：{notify_text}")
            CHECK_POINT("批量删除后的提示信息检查", notify_text == check_text)

        elif del_type == "不勾选数据，批量删除":
            sleep(1)
            STEP(2, f"点击【批量删除】按钮")
            safe_click((By.XPATH,"//span[contains(text(),'批量删除')]"),wd)
            sleep(1)

            STEP(3, f"检查不勾选数据批量删除弹窗的文本提示语")
            notify_text = get_notify_text(wd,(By.XPATH, "//p[@class='el-message__content']"),"Conference_Manage","Conference_Del",f"{name}_不勾选数据批量删除提示信息")
            INFO(f"不勾选数据批量删除弹窗的文本提示语为：{notify_text}")
            CHECK_POINT("不勾选数据批量删除弹窗的文本提示语检查", notify_text == check_text)

        if name == '会议室删除_011':
            wd.refresh()