import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/会议室管理模块/会议室查询.csv')

def text_query(wd,element_locator,query_text):
    """
    执行测试步骤以查询功能。
    本函数根据参数输入定位元素，查询文本，并检查查询后的数据是否与预期相符。
    """
    STEP(1, f"输入查询文本：{query_text}")
    INFO(f"输入查询文本：{query_text}")
    safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), query_text, wd)
    sleep(2)
    send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
    send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)
    sleep(2)

    STEP(2, "查看搜索结果")
    notify_text = elment_get_text(element_locator, wd)
    return notify_text


class Conference_Query_000x:
    tags = ['会议室管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：       
            1.cd 预定系统
            2.hytest --report_title 会议室查询测试报告 --report_url_prefix http://nat.ubainsyun.com:13233 --test 会议室查询_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室新增功能。
            本函数根据参数输入会议室名称、，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        conference_name, query_type, query_text = self.para

        if query_type == "模糊查询":
            notify_text = text_query(wd,(By.XPATH, "//tbody/tr[contains(@class,'el-table__row')]/td[2]/div[1]"),query_text)
            INFO(f"搜索结果为：{notify_text}")
            CHECK_POINT("搜索结果是否正确", query_text in notify_text)

        elif query_type == "精确查询":
            notify_text = text_query(wd, (By.XPATH, "//tbody/tr[contains(@class,'el-table__row')]/td[2]/div[1]"), query_text)
            INFO(f"搜索结果为：{notify_text}")
            CHECK_POINT("搜索结果是否正确", query_text in notify_text)

        elif query_type == "错误查询":
            notify_text = text_query(wd, (By.XPATH, "//span[@class='el-table__empty-text']"), query_text)
            INFO(f"搜索结果为：{notify_text}")
            CHECK_POINT("搜索结果是否正确", "暂无数据" in notify_text)

        elif query_type == "分页查询":
            # 切换分页
            safe_click((By.XPATH,"//li[normalize-space()='4']"),wd)
            notify_text = text_query(wd, (By.XPATH, "//tbody/tr[contains(@class,'el-table__row')]/td[2]/div[1]"), query_text)
            INFO(f"搜索结果为：{notify_text}")
            CHECK_POINT("搜索结果是否正确", query_text in notify_text)

        if name == '会议室查询_005':
            wd.refresh()