import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议室管理/会议室管理模块/会议室新增.csv')

class Conference_Add_000x:
    tags = ['会议室管理功能' , '后台管理功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议室新增测试报告 --test 会议室新增_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议室新增功能。
            本函数根据参数输入会议室名称、，并检查新增后的提示信息是否与预期相符。
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        # 从self.para中解构出用户名、密码、验证码和检查文本
        name = self.name
        conference_name, conference_token, conference_function, conference_capacity, check_text, back_check_text = self.para

        if back_check_text == "添加成功":
            # 步骤1：点击【新增】按钮，触发新增会议室的操作
            STEP(1, "点击【新增】按钮")

            # 使用safe_click方法点击新增按钮，确保操作的安全性和稳定性
            safe_click((By.XPATH, "//span[contains(text(),'添 加')]"), wd)

            # 暂停1秒，等待页面加载完成
            sleep(1)

            # 获取新增会议室弹窗的标题文本，用于验证弹窗是否正确显示
            notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'新增会议室')]"), wd)

            # 记录日志，检查新增会议室弹窗的标题是否正确
            INFO(f"检查新增会议室弹窗标题是否为：{notify_text}")

            # 再次暂停1秒，确保页面元素已经完全加载
            sleep(1)

        # 步骤2：在新增会议室弹窗中输入会议室名称
        STEP(2, f"输入会议室名称：{conference_name}")

        # 使用safe_send_keys方法在输入框中输入会议室名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入会议室名称']"), conference_name, wd)

        # 暂停1秒，等待输入操作完成
        sleep(1)

        # 步骤3：绑定会议室的授权码
        STEP(3, f"绑定会议室授权码：{conference_token}")

        # 点击授权码选择框，展开下拉菜单
        safe_click((By.XPATH,
                    "//div[@class='el-select authorize_input']//i[@class='el-select__caret el-input__icon el-icon-arrow-up']"),
                   wd)

        # 暂停1秒，等待下拉菜单加载完成
        sleep(1)

        # 从下拉菜单中选择指定的授权码
        safe_click((By.XPATH, f"//span[normalize-space()='{conference_token}']"), wd)

        # 暂停1秒，确保授权码绑定成功
        sleep(1)

        # 步骤4：选择会议室的功能设置
        STEP(4, f"选择会议室功能：{conference_function}")

        # 点击功能设置按钮，打开功能设置弹窗
        safe_click((By.XPATH, "(//span[contains(text(),'设置(0)')])[1]"), wd)

        # 暂停1秒，等待功能设置弹窗加载完成
        sleep(1)

        # 获取功能设置弹窗的标题文本，用于验证弹窗是否正确显示
        notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'会议室功能')]"), wd)

        # 记录日志，检查功能设置弹窗的标题是否正确
        INFO(f"检查会议室功能设置弹窗标题是否为：{notify_text}")

        # 检查点：验证功能设置弹窗是否正确弹出
        CHECK_POINT("检查是否弹出功能设置弹窗", notify_text == "会议室功能")

        # 步骤5：在功能设置中搜索特定的会议室功能
        STEP(5, f"搜索会议室功能：{conference_function}")

        # 在搜索框中输入会议室功能的关键字
        safe_send_keys((By.XPATH, "(//input[@placeholder='输入关键字'])[1]"), conference_function, wd)

        # 发送键盘事件，触发搜索操作
        send_keyboard((By.XPATH, "(//input[@placeholder='输入关键字'])[1]"), wd)

        # 暂停1秒，等待搜索结果加载完成
        sleep(1)

        # 获取搜索结果的文本，用于验证是否找到指定的会议室功能
        notify_text = elment_get_text((By.XPATH, f"//span[contains(text(),'{conference_function}')]"), wd)

        # 记录日志，检查是否搜索到指定的会议室功能
        INFO(f"检查是否搜索到功能：{notify_text}")

        # 检查点：验证是否搜索到指定的会议室功能
        CHECK_POINT("检查是否搜索到功能", notify_text == conference_function)

        # 步骤6：选择并绑定会议室功能
        STEP(6, "勾选功能进行绑定")

        # 点击搜索结果中的会议室功能，选中它
        safe_click((By.XPATH, f"//span[contains(text(),'{conference_function}')]"), wd)

        # 点击右箭头按钮，将选中的功能绑定到会议室
        safe_click((By.XPATH, "//i[@class='el-icon-arrow-right']"), wd)

        # 暂停1秒，确保功能绑定成功
        sleep(1)

        # 步骤7：确认功能选择的结果
        STEP(7, f"查看功能选择结果")

        # 获取左侧列表的文本，用于验证是否清空
        notify_text = elment_get_text((By.XPATH, "(//p[contains(text(),'无匹配数据')])[1]"), wd)

        # 记录日志，检查左侧列表是否清空
        INFO(f"检查左侧列表是否清空：{notify_text}")

        # 检查点：验证左侧列表是否清空
        CHECK_POINT("检查左侧列表是否清空", notify_text == "无匹配数据")

        # 获取右侧列表的文本，用于验证是否绑定功能
        notify_text = elment_get_text((By.XPATH, f"//span[contains(text(),'{conference_function}')]"), wd)

        # 记录日志，检查右侧列表是否绑定功能
        INFO(f"检查右侧列表是否绑定功能：{notify_text}")

        # 检查点：验证右侧列表是否绑定功能
        CHECK_POINT("检查右侧列表是否绑定功能", notify_text == conference_function)

        # 步骤8：在会议室功能界面点击确定按钮
        STEP(8, "会议室功能界面点击【确定】按钮")

        # 点击确定按钮，关闭功能设置弹窗
        safe_click((By.XPATH, "//div[@aria-label='会议室功能']//span[contains(text(),'确定')]"), wd)

        # 步骤9：输入会议室可容纳的人数
        STEP(9, f"输入会议室容纳人数：{conference_capacity}")

        # 在输入框中输入会议室可容纳的人数
        safe_send_keys((By.XPATH, "//input[@placeholder='2']"), conference_capacity, wd)

        # 步骤10：在新增会议室界面点击保存按钮
        STEP(10, "会议室新增界面点击【保存】按钮")

        # 点击保存按钮，提交新增会议室的信息
        safe_click((By.XPATH, "//span[contains(text(),'保 存')]"), wd)

        # 暂停2秒，等待保存操作完成
        sleep(2)

        # 如果会议室名称为空，执行以下步骤
        if conference_name == "":
            # 步骤11：检查新增会议室的结果
            STEP(11, f"检查新增结果是否为：{check_text}")

            # 获取提示信息的文本，用于验证新增结果
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Conference_Manage",
                                          "Conference_Add", f"{name}_查看提示信息")

            # 记录日志，检查新增结果是否正确
            INFO(f"检查新增结果为：{notify_text}")

            # 检查点：验证新增结果是否正确
            CHECK_POINT("检查新增结果", notify_text == check_text)

            # 步骤12：点击【重置】按钮
            STEP(12, "点击【重置】按钮")

            # 使用safe_click方法点击重置按钮
            safe_click((By.XPATH, "//span[contains(text(),'重置')]"), wd)

            # 暂停1秒，等待重置操作完成
            sleep(1)

            # 获取重置弹窗的标题文本，用于验证弹窗是否正确显示
            notify_text = elment_get_text((By.XPATH, "//p[contains(text(),'确定重置?')]"), wd)

            # 记录日志，检查重置弹窗的标题是否正确
            INFO(f"检查重置弹窗标题是否为：{notify_text}")

            # 检查点：验证重置弹窗的标题是否正确
            CHECK_POINT("检查重置弹窗标题", notify_text == "确定重置?")

            # 步骤13：点击【确定】按钮
            STEP(13, "点击【确定】按钮")

            # 使用safe_click方法点击确定按钮，确认重置操作
            safe_click((By.XPATH, "(//span[contains(text(),'确定')])[12]"), wd)

            # 暂停1秒，等待重置操作完成
            sleep(1)

        else:
            # 步骤11：检查新增会议室的结果
            STEP(11, f"检查新增结果是否为：{check_text}")

            # 获取提示信息的文本，用于验证新增结果
            notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Conference_Manage",
                                          "Conference_Add", f"{name}_查看提示信息")

            # 记录日志，检查新增结果是否正确
            INFO(f"检查新增结果为：{notify_text}")

            # 检查点：验证新增结果是否正确
            CHECK_POINT("检查新增结果", notify_text == check_text)

            # 暂停1秒，等待提示信息消失
            sleep(1)

            # 步骤12：在会议室列表中查询新增的会议室
            STEP(12, f"在会议室列表查询：{conference_name}")

            # 在搜索框中输入会议室名称
            safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字']"), conference_name, wd)

            # 发送键盘事件，触发搜索操作
            send_keyboard((By.XPATH, "//input[@placeholder='输入关键字']"), wd)

            # 暂停1秒，等待搜索结果加载完成
            sleep(1)

            # 步骤13：检查会议室新增后的数据回显
            STEP(13, f"检查会议室新增后的数据回显")

            # 暂停1秒，确保数据加载完成
            sleep(1)

            # 获取会议室名称的文本，用于验证是否正确回显
            conference_name_text = elment_get_text((By.XPATH, "//tbody/tr[1]/td[2]/div[1]"), wd)

            # 获取会议室功能的文本，用于验证是否正确回显
            conference_function_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{conference_function}']"),
                                                       wd)

            # 获取会议室容纳人数的文本，用于验证是否正确回显
            conference_capacity_text = elment_get_text((By.XPATH, f"//div[normalize-space()='{conference_capacity}']"),
                                                       wd)

            # 记录日志，检查新增会议室名称是否正确
            INFO(f"检查新增会议室名称为：{conference_name_text}")
            CHECK_POINT("检查新增会议室名称", conference_name_text == conference_name)

            # 记录日志，检查新增会议室功能是否正确
            INFO(f"检查新增会议室功能为：{conference_function_text}")
            CHECK_POINT("检查新增会议室功能", conference_function_text == conference_function)

            # 记录日志，检查新增会议室容纳人数是否正确
            INFO(f"检查新增会议室容纳人数为：{conference_capacity_text}")
            CHECK_POINT("检查新增会议室容纳人数", conference_capacity_text == conference_capacity)

        if name == '会议室新增_101':
            wd.refresh()