import sys
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/会议历史记录/历史会议再次预定.csv')
# 定义时间格式
time_format = "%H:%M"

class History_Book_000x:
    tags = ['历史会议功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --test 历史会议再次预定_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以历史会议再次预定功能。
            本函数根据参数输入会议室名称进行搜索会议，并检查再次预定后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              query_message_name:查询的会议名称
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        query_message_name, book_start_time, book_end_time, check_text = self.para

        # 输入会议名称进行筛选
        STEP(2, "点击筛选条下拉展开筛选项，输入查询文本：{}".format(query_message_name))
        sleep(1)
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"), wd)
        sleep(5)
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), query_message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        # 关闭下拉
        safe_click((By.XPATH, "//i[@class='el-icon-arrow-up']"), wd)
        sleep(2)
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_History", "Message_Book", f"{name}_查询结果")
        sleep(2)

        STEP(3, "检查提示文本")
        # 检查查询结果
        notify_text = elment_get_text((By.CSS_SELECTOR,
                                       "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1)"),
                                      wd)
        INFO(f"查询结果为：{notify_text}")
        CHECK_POINT("查询结果是否正确", query_message_name in notify_text)
        sleep(1)

        STEP(4, "点击【再次预定】按钮")
        # 点击【再次预定】按钮
        safe_click((By.CSS_SELECTOR, "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(2) > div:nth-child(4) > div:nth-child(2) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(11) > div:nth-child(1) > div:nth-child(1) > button:nth-child(1) > span:nth-child(1)"), wd)
        sleep(3)
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_History", "Message_Book", f"{name}_再次预定")

        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"), "历史记录会议", wd)
        # 选择会议时间
        # 将字符串转换为时间对象
        start_time = datetime.strptime(book_start_time, time_format)
        end_time = datetime.strptime(book_end_time, time_format)

        # 如果需要将时间差转换为分钟数
        time_diff_minutes = (end_time - start_time).total_seconds() / 60
        INFO(f"时间差为：time_diff_minutes")

        # 判断如果开始时间与结束时间相等，则不重复点击
        if book_start_time == book_end_time:
            INFO(f"开始时间与结束时间相等，选择时间块：{book_start_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
        elif book_start_time != book_end_time:
            INFO(f"开始时间与结束时间不相等，选择时间块：{book_start_time}，{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
        sleep(2)

        # 判断时间差是否大于最大预约时长1小时，即60分钟
        if time_diff_minutes > 60:
            INFO(f"时间差大于最大预约时长1小时，选择【超出预约时长】")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}_超出预约时长")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("超出预约时长提示是否正确", "最大预定时间 1 小时" in notify_text)
            sleep(2)

            # 不选时间点击【下一步】查看提示信息
            INFO("不选时间点击【下一步】查看提示信息")
            safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}请选择会议时间提示信息")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("未选时间提示是否正确", "请选择会议时间" in notify_text)
            sleep(1)

            # 重新选择时间，将字符串转换为时间对象
            time_obj = datetime.strptime(book_end_time, time_format)
            time_obj_minus_5_minutes = time_obj - timedelta(minutes=30)

            # 将时间对象转换回字符串
            book_end_time = time_obj_minus_5_minutes.strftime(time_format)
            INFO(f"重新选择结束时间为：{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
            sleep(2)

        STEP(5, "点击【快速预约】按钮")
        safe_click((By.XPATH, "//div[@class='header_Quick']"),wd)
        sleep(2)
        safe_click((By.XPATH, "//div[@class='header_Quick']"), wd)
        sleep(4)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'预定')]"),wd)
        sleep(2)
        notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                      "Message_History", "Message_Book", f"{name}预定成功提示信息")
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_History", "Message_Book", f"{name}_再次预定提示信息")
        INFO(f"预定成功提示信息为：{notify_text}")
        CHECK_POINT("预定成功提示是否正确", notify_text == check_text)

        # 清除数据
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), "历史记录会议", wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(2)
        safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
        sleep(2)
        safe_click((By.XPATH,
                    "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
                   wd)
        sleep(2)