import sys
import sys
import os

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../测试数据/会议历史记录/历史会议筛选.csv')
# 定义时间格式
time_format = "%H:%M"

class History_Query_000x:
    tags = ['历史会议功能','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --test 历史会议筛选_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以历史会议筛选功能。
            本函数根据参数输入会议室名称进行搜索会议，并检查筛选后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              query_message_name:查询的会议名称
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        query_message_name, query_type, check_text = self.para

        # 点击筛选条下拉展开筛选项
        STEP(2, "点击筛选条下拉展开筛选项，输入查询文本：{}".format(query_message_name))
        sleep(1)
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"), wd)
        sleep(5)
        safe_send_keys((By.XPATH,"//input[@placeholder='输入关键字搜索']"), query_message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(2)
        # 关闭下拉
        safe_click((By.XPATH, "//i[@class='el-icon-arrow-up']"), wd)
        sleep(5)
        SELENIUM_LOG_SCREEN(wd, "50%", "Message_History", "Message_Query", f"{name}_查询结果")
        sleep(2)

        # 判断查询方式
        if query_type == "错误查询":
            STEP(3, "检查提示文本")
            # 检查查询结果
            notify_text = elment_get_text((By.XPATH,
                                           "//span[contains(@class,'el-table__empty-text')]"),
                                          wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果是否正确", "暂无数据" in notify_text)

        else:
            # 检查查询结果
            notify_text = elment_get_text((By.CSS_SELECTOR,
                                           "body > div:nth-child(1) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > div:nth-child(1) > div:nth-child(2) > div:nth-child(3) > table:nth-child(1) > tbody:nth-child(2) > tr:nth-child(1) > td:nth-child(2) > div:nth-child(1)"),
                                          wd)
            INFO(f"查询结果为：{notify_text}")
            CHECK_POINT("查询结果是否正确", query_message_name in notify_text)
            sleep(1)