import sys
import os
from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议主流程/会议状态设置.csv')
# 定义时间格式
time_format = "%H:%M"

def message_update_status(wd):
    """
    更新消息的会议状态。

    参数:
    - wd: WebDriver实例，用于与浏览器交互。

    此函数无返回值。
    """
    # 等待1秒以确保页面元素加载完成
    sleep(1)
    # 日志记录点击【更多操作】以修改会议状态
    INFO("点击【更多操作】修改会议状态")
    # 点击【更多操作】按钮修改会议状态
    safe_click((By.XPATH, "//span[contains(text(),'更多操作')]"), wd)
    # 等待2秒以确保下拉菜单展开
    sleep(2)
    # 点击【会议状态】选项
    safe_click((By.XPATH, "//li[contains(text(),'会议状态')]"), wd)
    # 日志记录检查修改会议状态界面标题
    INFO("检查修改会议状态界面标题")
    # 获取弹窗页面标题
    notify_text = elment_get_text((By.XPATH, "//span[contains(text(),'修改会议状态：')]"), wd)
    # 日志记录修改会议状态界面标题
    INFO(f"修改会议状态界面标题为：{notify_text}")
    # 检查点：验证修改会议状态界面标题是否正确
    CHECK_POINT("修改会议状态界面标题是否正确", "修改会议状态：" in notify_text)
    # 等待1秒以确保后续操作稳定进行
    sleep(1)

def message_extend_meeting(time_value, wd, name):
    """
    延长会议时间的消息处理函数。

    该函数通过输入新的时间值来尝试延长会议时间，并捕获操作后的提示信息。
    它使用了安全操作函数来确保每个步骤的执行，并在操作后返回相关的通知文本。

    参数:
    - time_value: 新的时间值，用于延长会议时间。
    - wd: WebDriver实例，用于与浏览器交互。
    - name: 会议的名称，用于错误信息中。

    返回:
    - notify_text: 操作后的通知文本，用于进一步的断言或日志记录。
    """
    # 安全地输入延长会议的时间值
    safe_send_keys((By.XPATH, "//div[@class='el-input']//input[@type='text']"), time_value, wd)
    sleep(2)
    # 安全地点击确定按钮以应用新的时间设置
    safe_click((By.XPATH, "//div[@slot='footer']//span[contains(text(),'确定')]"), wd)
    # 等待一段时间以确保操作完成
    sleep(2)
    # 获取操作后的通知文本
    notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Message_Manage",
                                  "Message_Update_Status", f"{name}_修改状态失败提示信息")
    # 记录操作失败的提示信息
    INFO(f"修改状态失败提示信息为：{notify_text}")
    # 再次等待以确保系统更新
    sleep(2)
    # 返回通知文本以供进一步处理
    return notify_text


class Message_UpdateStatus_000x:
    tags = ['会议预约主流程','预定系统功能']
    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议状态设置测试报告 --test 会议状态设置_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议状态设置功能。
            本函数根据参数输入会议室名称进行搜索会议，并检查会议操作后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              conference_name:会议室名称
              message_name:会议名称
              book_start_time:会议开始时间
              book_end_time:会议结束时间
        """
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name, message_name, book_start_time, book_end_time, book_check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"), wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"), conference_name, wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"), wd)
        sleep(1)
        INFO("检查搜索结果")
        # 获取搜索出的会议室名称
        notify_text = elment_get_text((By.XPATH, "//span[@class='MeetingCityList_name']"), wd)
        INFO(f"搜索结果为：{notify_text}")
        CHECK_POINT("搜索结果是否正确", conference_name in notify_text)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"), wd)
        sleep(1)
        INFO("检查页面标题是否正确")
        # 获取页面标题
        notify_text = elment_get_text((By.XPATH, "//div[@class='reserve_Title']"), wd)
        INFO(f"页面标题为：{notify_text}")
        CHECK_POINT("页面标题是否正确", "会议预定" in notify_text)
        sleep(1)

        # 在会议预定第一步界面进行数据填入
        STEP(3, "会议第一步数据填写")
        INFO(
            f"输入会议名称：{message_name}，选择择会议开始时间：{book_start_time}，选择会议结束时间：{book_end_time}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"), message_name, wd)

        # 将字符串转换为时间对象
        start_time = datetime.strptime(book_start_time, time_format)
        end_time = datetime.strptime(book_end_time, time_format)

        # 如果需要将时间差转换为分钟数
        time_diff_minutes = (end_time - start_time).total_seconds() / 60
        INFO(f"时间差为：time_diff_minutes")

        # 判断如果开始时间与结束时间相等，则不重复点击
        if book_start_time == book_end_time:
            INFO(f"开始时间与结束时间相等，选择时间块：{book_start_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
        elif book_start_time != book_end_time:
            INFO(f"开始时间与结束时间不相等，选择时间块：{book_start_time}，{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
        sleep(2)

        # 判断时间差是否大于最大预约时长1小时，即60分钟
        if time_diff_minutes > 60:
            INFO(f"时间差大于最大预约时长1小时，选择【超出预约时长】")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}_超出预约时长")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("超出预约时长提示是否正确", "最大预定时间 1 小时" in notify_text)
            sleep(2)

            # 不选时间点击【下一步】查看提示信息
            INFO("不选时间点击【下一步】查看提示信息")
            safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"),
                                          "Message_Manage", "Message_Book", f"{name}请选择会议时间提示信息")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("未选时间提示是否正确", "请选择会议时间" in notify_text)
            sleep(1)

            # 重新选择时间，将字符串转换为时间对象
            time_obj = datetime.strptime(book_end_time, time_format)
            time_obj_minus_5_minutes = time_obj - timedelta(minutes=30)

            # 将时间对象转换回字符串
            book_end_time = time_obj_minus_5_minutes.strftime(time_format)
            INFO(f"重新选择结束时间为：{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
            sleep(2)

        STEP(4,"连续点击【下一步】按钮创建会议")
        INFO(f"点击【下一步】按钮创建会议")
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        # safe_click((By.XPATH, "//div[@class='header_Quick']"), wd)
        sleep(2)
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"), wd)
        sleep(2)

        INFO("点击【确定】按钮")
        safe_click((By.XPATH, "//div[contains(text(),'确定')]"), wd)

        safe_click((By.XPATH, "//div[@aria-label='会议信息']//span[contains(text(),'确定')]"), wd)
        sleep(2)

        # 查看是否显示加载中
        # notify_text = elment_get_text((By.XPATH, "//p[@class='el-loading-text']"), wd)
        # CHECK_POINT("是否显示加载中", "提交数据中" in notify_text)
        # sleep(5)

        # 获取提示信息
        notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"), "Message_Manage",
                                      "Message_Book", f"{name}_预定成功提示信息")
        INFO(f"预定成功提示信息为：{notify_text}")
        CHECK_POINT("预定成功提示是否正确", notify_text == book_check_text)

        # 查询会议
        STEP(5,f"查询会议：{message_name}")
        INFO(f"查询会议：{message_name}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), message_name, wd)
        sleep(1)
        # 敲击键盘回车键搜索
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(1)
        INFO("检查查询结果")
        # 获取查询结果
        notify_text = elment_get_text((By.XPATH, "//tbody/tr[@class='el-table__row']/td[2]/div[1]"), wd)
        INFO(f"查询结果为：{notify_text}")
        # 校验查询结果是否正确
        CHECK_POINT("查询结果是否正确", message_name in notify_text)

        # 点击【更多操作】按钮进入修改会议状态界面
        STEP(6,f"点击【更多操作】修改会议状态")
        message_update_status(wd)

        # 点击【提前开始】提前开始会议
        STEP(7,"提前开始会议")
        INFO("选择【提前开始】状态")
        # 选择【提前开始】
        safe_click((By.XPATH, "//span[contains(text(),'提前开始')]"), wd)
        sleep(1)
        # 点击【确定】按钮
        safe_click((By.XPATH, "//div[contains(@slot,'footer')]//span[contains(text(),'确定')]"), wd)
        sleep(3)
        # 获取提前开始的提示信息
        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Message_Manage",
                                      "Message_Update_Status", f"{name}_修改状态成功提示信息")
        INFO(f"修改状态成功提示信息为：{notify_text}")
        CHECK_POINT("修改状态成功提示是否正确", "会议提前开始成功" in notify_text)
        sleep(2)

        # 校验延长会议时间边界值
        STEP(8,"延长会议时间边界值测试")
        INFO("选择【延长时间】状态")
        # 调用更多操作的函数进入修改会议状态界面
        message_update_status(wd)
        INFO("选择【延长时间】为空")
        # 调用延长会议时间函数
        notify_text = message_extend_meeting("0", wd, name)
        CHECK_POINT("检查延长时间为空提示是否正确", "至少延长15分钟" in notify_text)
        sleep(2)

        INFO("选择【延长时间】为10分钟")
        # 调用延长会议时间函数
        notify_text = message_extend_meeting("10", wd, name)
        CHECK_POINT("检查延长时间为“10”分钟提示是否正确", "至少延长15分钟" in notify_text)
        sleep(2)

        INFO("选择【延长时间】为90分钟")
        # 调用延长会议时间函数
        notify_text = message_extend_meeting("90", wd, name)
        CHECK_POINT("检查延长时间为“90”分钟提示是否正确", "超过该会议室可预订的最大时长" in notify_text)
        sleep(2)

        INFO("选择【延长时间】为16分钟")
        # 调用延长会议时间函数
        notify_text = message_extend_meeting("16", wd, name)
        CHECK_POINT("检查延长时间为“16”分钟提示是否正确", "会议延长成功" in notify_text)
        sleep(2)

        # 结束会议
        STEP(9,"结束会议")
        # 调用更多操作界面函数
        message_update_status(wd)
        # 点击【提前结束】按钮
        safe_click((By.XPATH, "//span[contains(text(),'提前结束')]"),wd)
        sleep(1)
        # 点击【确定】按钮
        safe_click((By.XPATH, "//div[@slot='footer']//span[contains(text(),'确定')]"),wd)
        sleep(1)
        # 获取结束会议的结束提示信息
        notify_text = get_notify_text(wd, (By.XPATH, "//p[@class='el-message__content']"), "Message_Manage",
                                      "Message_Update_Status", f"{name}_修改状态成功提示信息")
        INFO(f"修改状态成功提示信息为：{notify_text}")
        CHECK_POINT("修改状态成功提示是否正确", "会议提前结束成功" in notify_text)

        # 检查会议是否正确结束
        STEP(10,"检查会议是否结束")
        sleep(1)
        INFO("查询已结束的会议：{message_name}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"),message_name,wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(1)
        notify_text = elment_get_text((By.XPATH, "//span[@class='el-table__empty-text']"), wd)
        INFO(f"查询结果为：{notify_text}")
        CHECK_POINT("查询结果是否正确", "暂无数据" in notify_text)