import sys
import os
from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..' , '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建CSV文件的绝对路径
csv_file_path = os.path.join(current_dir, '../../../测试数据/会议主流程/会议预约.csv')
# 定义时间格式
time_format = "%H:%M"

class Message_Book_000x:
    tags = ['会议预约主流程','预定系统功能']

    """
        执行指令：
            1.cd 预定系统
            2.hytest --report_title 会议预约测试报告 --test 会议预约_0**
    """
    ddt_cases = read_csv_data(csv_file_path)

    def teststeps(self):
        """
            执行测试步骤以会议预约功能。
            本函数根据参数输入会议室名称进行搜索并预约会议，并检查预约后的提示信息是否与预期相符。
            字段含义：
              name:用例名称
              conference_name:会议室名称
              message_name:会议名称
              book_type:预约类型
              repetitive_cycle:重复周期
              host_name:主持人名称
              message_content:会议内容
              book_start_time:会议开始时间
              book_end_time:会议结束时间
              inside_participant_name:内部参会人名称
              outside_participant_name:外部参会人名称
              outside_participant_phone:外部参会人手机号码
              message_notification:消息提醒时间
              notification_method:通知方式
              check_text:检查提示文本
        """
        # 初始化通知文本为空字符串
        notify_text = ""
        # 从全局存储中获取webdriver实例
        wd = GSTORE['wd']
        name = self.name
        conference_name, message_name, book_type, repetitive_cycle, host_name, message_content, issue_name, book_start_time, book_end_time, inside_participant_name, outside_participant_name, outside_participant_phone, save_template, template_name, message_notification, notification_method, check_text = self.para

        # 在会议室列表搜索会议室
        STEP(1, f"在会议室列表搜索：{conference_name}")
        # 展开筛选下拉框
        safe_click((By.XPATH, "//i[@class='el-collapse-item__arrow el-icon-arrow-right']"),wd)
        sleep(1)
        # 输入会议室名称，并点击【查询】按钮
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议室名称']"),conference_name,wd)
        safe_click((By.XPATH, "//button[@type='button']//span[contains(text(),'查询')]"),wd)
        sleep(1)
        INFO("检查搜索结果")
        # 获取搜索出的会议室名称
        notify_text = elment_get_text((By.XPATH, "//span[@class='MeetingCityList_name']"),wd)
        INFO(f"搜索结果为：{notify_text}")
        CHECK_POINT("搜索结果是否正确", conference_name in notify_text)

        # 点击【会议预定】按钮，进入会议预定界面
        STEP(2, "点击【会议预定】按钮")
        safe_click((By.XPATH, "//span[@class='MeetingCityList_t_btn']"),wd)
        sleep(1)
        INFO("检查页面标题是否正确")
        # 获取页面标题
        notify_text = elment_get_text((By.XPATH, "//div[@class='reserve_Title']"),wd)
        INFO(f"页面标题为：{notify_text}")
        CHECK_POINT("页面标题是否正确", "会议预定" in notify_text)
        sleep(1)

        # 在会议预定第一步界面进行数据填入
        STEP(3,"会议第一步数据填写")
        INFO(f"输入会议名称：{message_name}，选择预约类型：{book_type}，输入主持人：{host_name}，输入会议内容：{message_content}，选择会议开始时间：{book_start_time}，选择会议结束时间：{book_end_time}")
        # 输入会议名称
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议名称']"),message_name,wd)

        # 判断预约类型
        if book_type == "普通会议":
            INFO("预约类型为：普通会议")
            # 选择普通会议
            safe_click((By.XPATH, f"//span[contains(text(),'{book_type}')]"), wd)
            sleep(1)

        elif book_type == "周期会议":
            INFO("预约类型为：周期会议")
            # 选择周期会议
            safe_click((By.XPATH, f"//span[contains(text(),'{book_type}')]"),wd)
            sleep(1)
            # 选择重复周期
            safe_click((By.XPATH, f"//span[contains(text(),'{repetitive_cycle}')]"),wd)
            sleep(1)

        # 输入会议主持人
        safe_send_keys((By.XPATH, "//input[@placeholder='请输入']"),host_name,wd)
        # 输入会议内容
        safe_send_keys((By.XPATH, "//textarea[@placeholder='请输入会议内容']"),message_content,wd)
        sleep(2)

        # # 输入议题名称
        # safe_send_keys((By.XPATH, "//input[@placeholder='请输入会议议题']"),issue_name,wd)
        # # 选择议题文件进行上传
        # safe_click((By.XPATH, "//div[@class='topicsHandleButton uploadFile']"),wd)
        # sleep(1)

        # 将字符串转换为时间对象
        start_time = datetime.strptime(book_start_time, time_format)
        end_time = datetime.strptime(book_end_time, time_format)

        # 如果需要将时间差转换为分钟数
        time_diff_minutes = (end_time - start_time).total_seconds() / 60
        INFO(f"时间差为：time_diff_minutes")

        # 判断如果开始时间与结束时间相等，则不重复点击
        if book_start_time == book_end_time:
            INFO(f"开始时间与结束时间相等，选择时间块：{book_start_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
        elif book_start_time != book_end_time:
            INFO(f"开始时间与结束时间不相等，选择时间块：{book_start_time}，{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
        sleep(2)

        # 判断时间差是否大于最大预约时长1小时，即60分钟
        if time_diff_minutes > 60:
            INFO(f"时间差大于最大预约时长1小时，选择【超出预约时长】")
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"), "Message_Manage", "Message_Book", f"{name}_超出预约时长")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("超出预约时长提示是否正确", "最大预定时间 1 小时" in notify_text)
            sleep(2)

            # 不选时间点击【下一步】查看提示信息
            INFO("不选时间点击【下一步】查看提示信息")
            safe_click((By.XPATH, "//div[contains(text(),'下一步')]"),wd)
            sleep(1)
            notify_text = get_notify_text(wd, (By.XPATH, "//p[contains(@class,'el-message__content')]"), "Message_Manage", "Message_Book", f"{name}请选择会议时间提示信息")
            INFO(f"提示信息为：{notify_text}")
            CHECK_POINT("未选时间提示是否正确", "请选择会议时间" in notify_text)
            sleep(1)

            # 重新选择时间，将字符串转换为时间对象
            time_obj = datetime.strptime(book_end_time, time_format)
            time_obj_minus_5_minutes = time_obj - timedelta(minutes=30)

            # 将时间对象转换回字符串
            book_end_time = time_obj_minus_5_minutes.strftime(time_format)
            INFO(f"重新选择结束时间为：{book_end_time}")
            # 根据开始时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_start_time}'])[1]"), wd)
            # 根据结束时间选择对应时间块，时间格式为：**:**
            safe_click((By.XPATH, f"(//div[normalize-space()='{book_end_time}'])[1]"), wd)
            sleep(2)

        # 在会议预定第二步界面进行数据填入
        STEP(4, "会议第二步数据填写")
        # 点击【下一步】进入会议预定第二步界面
        safe_click((By.XPATH, "//div[contains(text(),'下一步')]"),wd)
        sleep(1)
        # 根据参会人名称搜搜对应参会人
        safe_send_keys((By.XPATH, "//input[@placeholder='账号/用户名']"),inside_participant_name,wd)
        send_keyboard((By.XPATH, "//input[@placeholder='账号/用户名']"), wd)
        sleep(1)
        # 选择内部参会人
        INFO(f"选择内部参会人：{inside_participant_name}")
        safe_click((By.XPATH,"//tbody//tr//td//div//label//span//span"),wd)
        # 获取已选的参会人名称
        notify_text = elment_get_text((By.XPATH, f"//span[normalize-space()='{inside_participant_name}']"),wd)
        INFO(f"已选择参会人：{notify_text}")
        CHECK_POINT("内部参会人选择是否正确", inside_participant_name in notify_text)

        INFO(f"输入外部参会人名称：{outside_participant_name}，外部参会人号码：{outside_participant_phone}")
        # 点击【添加外部参会人】按钮
        safe_click((By.XPATH,"(//span[contains(text(),'添加外部参会人员')])[1]"),wd)
        sleep(1)
        INFO("检查弹窗标题是否正确")
        notify_text = elment_get_text((By.XPATH, "//span[contains(@class,'el-dialog__title')][contains(text(),'添加外部参会人员')]"),wd)
        INFO(f"弹窗标题为：{notify_text}")
        CHECK_POINT("弹窗标题是否正确", "添加外部参会人员" in notify_text)

        #输入外部参会人名称、外部参会人号码
        safe_send_keys((By.XPATH,"//div[contains(@class,'add_input')]//input[contains(@placeholder,'用户名')]"),outside_participant_name,wd)
        safe_send_keys((By.XPATH,"//input[@placeholder='手机号码']"),outside_participant_phone,wd)
        sleep(1)
        # 点击【确定】按钮
        safe_click((By.XPATH,"//div[@aria-label='添加外部参会人员']//div[@class='el-dialog__footer']//button[@type='button']"),wd)
        sleep(1)

        # 检查外部参会人添加提示信息是否正确
        # notify_text = get_notify_text(wd,(By.XPATH,"//p[contains(@class,'el-message__content')]"),"Message_Manage","Message_Book",f"{name}_添加外部参会人提示信息")
        # INFO(f"提示信息为：{notify_text}")
        # CHECK_POINT("提示信息是否正确", "添加成功" in notify_text)

        # 点击【下一步】按钮
        safe_click((By.XPATH,"//div[contains(text(),'下一步')]"),wd)

        # 进入会议预约第三步进行填写
        STEP(5, "会议第三步数据填写")
        INFO("检查页面标题是否正确")
        sleep(1)
        # 获取页面标题
        notify_text = elment_get_text((By.XPATH,"//h2[contains(text(),'消息提醒')]"),wd)
        INFO(f"页面标题为：{notify_text}")
        CHECK_POINT("页面标题是否正确", "消息提醒" in notify_text)

        # 判断是否需要存入模板
        INFO(f"是否需要存入模板：{save_template}")
        if save_template == "是":
            # 点击【是】按钮
            safe_click((By.XPATH,f"//span[@class='el-radio__label'][contains(text(),'{save_template}')]"),wd)
            # 输入模板名称
            safe_send_keys((By.XPATH,"//input[@placeholder='请输入模版名称']"),template_name,wd)
            sleep(1)
        else:
            # 点击【否】按钮
            safe_click((By.XPATH, f"//span[@class='el-radio__label'][contains(text(),'{save_template}')]"), wd)
            sleep(1)

        # 选择消息提醒时间
        INFO(f"选择消息提醒时间：{message_notification}")
        # 判断消息提醒时间是否为全选
        if message_notification == "全选":
            # 点击【全选】按钮
            safe_click((By.XPATH,"//div[@class='Reminds']//span[@class='el-checkbox__label'][contains(text(),'全选')]"),wd)
            sleep(1)
        else:
            # 选择对应的消息提醒时间
            safe_click((By.XPATH, f"//span[contains(text(),'{message_notification}')]"), wd)
            sleep(1)

        # 选择通知方式
        INFO(f"选择通知方式：{notification_method}")
        # if notification_method == "全选":
            # 点击【全选】按钮
            # safe_click((By.XPATH,"//div[@class='Sendout']//span[@class='el-checkbox__label'][contains(text(),'全选')]"),wd)
        # else:
            # 选择对应的通知方式
            # safe_click((By.XPATH, f"//span[contains(text(),'{notification_method}')]"), wd)
            # sleep(1)

        # 点击【确定】按钮
        STEP(6, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(text(),'确定')]"),wd)

        # 检查会议信息是否正确
        STEP(7, "检查提示会议信息是否正确")
        sleep(1)
        INFO(
            f"检查会议名称：{message_name}，输入会议内容：{message_content}")
        # 获取会议名称与会议内容
        message_name_text = elment_get_text((By.XPATH,f"//div[contains(text(),'{message_name}')]"),wd)
        message_content_text = elment_get_text((By.XPATH,f"//div[contains(text(),'{message_content}')]"),wd)
        CHECK_POINT("提示信息是否正确", message_name_text in message_name and message_content_text in message_content)

        # 点击最后【确定】按钮，预定成功后会跳转至已预定界面
        STEP(8, "点击【确定】按钮")
        safe_click((By.XPATH,"//div[contains(@aria-label,'会议信息')]//span[contains(text(),'确定')]"),wd)
        sleep(15)

        # 查看是否显示加载中
        # if book_type == "普通会议":
        #     notify_text = elment_get_text((By.XPATH, "//p[@class='el-loading-text']"), wd)
        #     if notify_text == "提交数据中":
        #         INFO("未显示加载中")
        #     else:
        #         INFO("显示加载中")
        #         CHECK_POINT("是否显示加载中", "提交数据中" in notify_text)
        #         sleep(4)

        # 获取提示信息
        # notify_text = get_notify_text(wd,(By.XPATH,"//p[contains(@class,'el-message__content')]"),"Message_Manage","Message_Book",f"{name}_预定成功提示信息")
        # INFO(f"预定成功提示信息为：{notify_text}")
        # CHECK_POINT("预定成功提示是否正确", notify_text == check_text)

        # 进行切换至会议室列表界面
        STEP(9, "检查会议是否成功预约")
        safe_send_keys((By.XPATH, "//input[@placeholder='输入关键字搜索']"), message_name, wd)
        send_keyboard((By.XPATH, "//input[@placeholder='输入关键字搜索']"), wd)
        sleep(5)
        # 获取会议名称
        message_name_text = elment_get_text((By.XPATH, f"//div[contains(@class,'cell el-tooltip')][contains(text(),'{message_name}')]"), wd)
        INFO(f"会议名称为：{message_name_text}")
        CHECK_POINT("会议名称是否正确", message_name_text == message_name)

        # # 判断会议类型
        # if repetitive_cycle == '周期会议':
        #     INFO("点击【删除会议】按钮")
        #     # 点击【删除会议】按钮
        #     safe_click((By.CSS_SELECTOR,
        #                 "tbody tr:nth-child(1) td:nth-child(8) div:nth-child(1) button:nth-child(2) span:nth-child(1)"),
        #                wd)
        #     sleep(5)
        #     INFO("点击【删除本场及以后周期会议】按钮")
        #     safe_click((By.XPATH, "//span[contains(text(),'删除本次及后续的周期会议')]"), wd)
        #     sleep(2)
        #     # 点击【确定】按钮
        #     safe_click((By.XPATH, "//div[contains(@aria-label,'提示')]//span[contains(text(),'确定')]"), wd)
        #     sleep(2)
        #
        # else:
        #     # 点击【删除会议】按钮
        #     safe_click((By.XPATH, "//span[contains(text(),'删除会议')]"), wd)
        #     sleep(2)
        #     # 点击【确定】按钮
        #     safe_click((By.XPATH,
        #                 "//button[contains(@class,'el-button el-button--default el-button--small el-button--primary')]//span[contains(text(),'确定')]"),
        #                wd)
        #     sleep(2)

        STEP(10, "跳转至会议室列表界面")
        # 点击会议室列表导航栏
        safe_click((By.XPATH, "//span[contains(text(),'会议室列表')]"), wd)
        sleep(1)
        INFO("检查界面标题是否为：会议室列表")
        # 获取会议室列表界面的标题信息
        notify_text = elment_get_text((By.XPATH, "//div[@class='header']//span[contains(text(),'会议室列表')]"), wd)
        CHECK_POINT("界面标题是否正确", "会议室列表" in notify_text)