import sys
import os
from hytest import *

# 获取 Base 目录的绝对路径，并加入 sys.path
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from 预定系统.Base.base import *

# 获取当前脚本所在的目录
current_dir = os.path.dirname(os.path.abspath(__file__))

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', '测试数据', '会议预定测试用例.xlsx')

class TxcentMeeting:
    tags = ['新-会控腾讯测试', 'JSON测试']
    """
        执行指令是：
            1.cd 预定系统
            2.hytest --report_title 腾讯会控测试报告 --report_url_prefix http://nat.ubainsyun.com:31133 --tag 新-会控腾讯测试
    """
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name='会控-腾讯会议',case_type="标准版")
    # 测试开始前调用clear_columns_in_xlsx函数，将测试用例中的测试结果和日志截图置空
    clear_columns_in_xlsx(xlsx_file_path, sheet_name='会控-腾讯会议', columns_to_clear=['测试结果', '测试频次', '日志截图'])

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行会议控制操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name

        # 调用会议创建函数
        meeting_message("腾讯会议室", "腾讯会议", "腾讯会议", "标准版", wd)
        sleep(1)

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')
            # 将会议名称赋值，后面调用函数结束会议
            message_name = element_value

            # 判断页面功能类型
            if page_type == "MeetingControl_Txcent":
                if element_type == "input":
                    # 查询会议
                    safe_send_keys((locator_type, locator_value), element_value, wd)
                    send_keyboard((locator_type, locator_value), wd)
                    sleep(2)
                    # 提前开始会议
                    safe_click((By.XPATH, "//span[contains(text(),'更多操作')]"), wd)
                    sleep(1)
                    safe_click((By.XPATH, "//li[contains(text(),'会议状态')]"), wd)
                    sleep(1)
                    safe_click((By.XPATH, "//div[@slot='footer']//span[contains(text(),'确定')]"), wd)
                    sleep(2)

                elif element_type == "click":
                    safe_click((locator_type, locator_value), wd)
                    safe_click((locator_type, locator_value), wd)
                    sleep(2)

                elif element_type == "getText":
                    # 切换到新窗口
                    wd.switch_to.window(wd.window_handles[1])
                    notify_text = elment_get_text((locator_type, locator_value), wd)
                    INFO(f"当前页面标题为：{notify_text}")
                    CHECK_POINT(f"当前页面标题为：{notify_text}", expected_result in notify_text)
                    SELENIUM_LOG_SCREEN(wd, "50")
                    # 切换窗口
                    wd.switch_to.window(wd.window_handles[0])
                    wd.refresh()
                    # 调用会议结束函数，传入会议名称
                    INFO(f"调用message_satus_control函数结束{message_name}名称的会议")
                    message_satus_control(message_name, "会控", "提前结束", wd)