import schedule
import threading
import queue
from lib.base import *
import time
import logging

# 配置日志记录器，仅输出到控制台
logging.basicConfig(
    level=logging.DEBUG,  # 设置日志级别为 DEBUG
    format='%(asctime)s - %(levelname)s - %(message)s',  # 日志格式：时间 - 日志级别 - 消息
    handlers=[
        logging.StreamHandler()  # 将日志输出到控制台
    ]
)

"""
    执行指令：
        1.打开一个终端输入：
            - cd .\运维集控\项目测试\运维标准版\
            - python -m http.server 82 --directory log
        2.打开新终端输入：
            - cd .\运维集控\项目测试\运维标准版\ngrok\
            - .\start.bat
        2.再打开一个终端输入：
            - cd .\运维集控\项目测试\运维标准版\
            - python .\定时任务执行.py
"""

# 创建一个任务队列，用于存储待处理的任务
task_queue = queue.Queue()

def run_task(task, *args, **kwargs):
    # 将任务及其参数放入任务队列
    task_queue.put((task, args, kwargs))
    logging.debug(f"任务已加入队列: {task.__name__} with args: {args} and kwargs: {kwargs}")

def worker():
    # 工作线程的主循环
    while True:
        # 从任务队列中获取任务及其参数
        task, args, kwargs = task_queue.get()
        try:
            # 记录任务开始执行的时间
            logging.debug(f"开始执行任务: {task.__name__} with args: {args} and kwargs: {kwargs}")
            # 执行任务并获取结果
            result = task(*args, **kwargs)
            # 如果任务有返回结果，记录日志
            if result:
                logging.info(result)
        except Exception as e:
            # 捕获任务执行过程中发生的任何异常并记录错误日志
            logging.error(f"执行任务时发生错误: {e}", exc_info=True)
        finally:
            # 无论任务是否成功执行，都标记任务已完成
            task_queue.task_done()
            # 记录任务完成的时间
            logging.debug(f"任务完成: {task.__name__}")

def start_workers(num_workers):
    # 启动指定数量的工作线程
    for _ in range(num_workers):
        # 创建一个新的工作线程，目标函数为 worker，设置为守护线程
        threading.Thread(target=worker, daemon=True).start()

# 启动3个工作线程
start_workers(3)
# 运维自动化测试
schedule.every().day.at("16:05").do(run_task, run_automation_test, report_title="运维系统自动化报告", report_url_prefix="http://nat.ubainsyun.com:31135",  ding_type="标准版巡检")

try:
    # 无限循环，持续检查并执行计划任务
    while True:
        schedule.run_pending()  # 检查并执行所有待处理的任务
        time.sleep(1)  # 每秒检查一次
except KeyboardInterrupt:
    # 捕获用户中断信号 (Ctrl+C)
    logging.info("Scheduler interrupted by user.")
except Exception as e:
    # 捕获其他未预期的异常
    logging.error(f"Unexpected error: {e}", exc_info=True)