import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

#构建当前项目路径
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '07类型标签', '新增标签.csv'))

class AreagroupAdd:
    tag = ['新增类型标签']
    ddt_cases = read_csv_data(csv_path)
    def teststeps(self):
        wd = GSTORE['wd']
        # 从self.para中解构出数据
        name = self.name
        area_group, group_name, group_address, remark, info = self.para

        STEP(1, '点击新增按钮')
        areagroup_add = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@class='company-edmit-right']//span[contains(text(),'新增')]"))
        )
        areagroup_add.click()

        STEP(2, f'查看并选择类型标签:{area_group}')
        if area_group:
            area_group_input = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located((By.XPATH, "// input[ @ placeholder = '请选择分组']"))
            )
            area_group_input.clear()
            area_group_input.send_keys(area_group)
            sleep(1)
            #默认选择第一个内容
            area_group_select = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located((By.XPATH, "//div[@class='el-cascader__suggestion-panel el-scrollbar']//li[1]//span[1]"))
            )
            area_group_select.click()
        else:
            print("group_name 为空，不执行选择区域分组的操作")

        STEP(3, f'填写标签名称:{group_name}')
        group_name_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//input[@placeholder='长度1-20个字符']"))
        )
        group_name_input.clear()
        group_name_input.send_keys(group_name)

        STEP(4, f'填写标签排序:{group_address}')
        group_address_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//input[@placeholder='输入地址不能大于50个字符']"))
        )
        group_address_input.clear()
        group_address_input.send_keys(group_address)

        STEP(5, f'填写分组备注:{remark}')
        group_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入备注']"))
        )
        group_remark.clear()
        group_remark.send_keys(remark)

        STEP(6, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@class='dialog-footer']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(7, '验证是否新增成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.XPATH, "//p[@class='el-message__content']"))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == info )

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()

