import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *

# 构建 CSV 文件的绝对路径
csv_path = os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..', '..', 'testdata', '06区域管理', '新增区域.csv'))

class AreafuntionAdd:
    tag = ['新增区域']
    ddt_cases = read_csv_data(csv_path)
    def teststeps(self):
        wd = GSTORE['wd']

        #从self.para中解构出数据
        name = self.name
        area_group, area_type, area_name, area_ip, remark, info = self.para

        STEP(1, '点击新增按钮')
        areafuntion_add = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@class='company-edmit-right']//span[contains(text(),'新增')]"))
        )
        areafuntion_add.click()
        sleep(1)

        STEP(2, f'查找并选择区域分组:{area_group}')
        if area_group:
            area_group_input = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located(
                    (By.XPATH, "//div[@class='dialog_input']//input[@placeholder='请选择分组']"))
            )
            area_group_input.send_keys(area_group)
            #默认选择第一个分组
            areagroup_select = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located(
                    (
                    By.XPATH, "//li[@class='el-cascader__suggestion-item']"))
            )
            sleep(1)
            areagroup_select.click()
        else:
            print("group_name 为空，不执行选择区域分组的操作")

        STEP(3, f'选择区域类型:{area_type}')
        if area_type:
            area_type_input = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located(
                    (By.XPATH, "//div[@class='dialog_input']//input[@placeholder='请选择区域类型']"))
            )
            area_type_input.send_keys(area_type)
            #默认选择第一个区域类型
            areatype_select = WebDriverWait(wd, 10).until(
                EC.presence_of_element_located(
                    (By.XPATH, "//div[@x-placement='bottom-start']//ul[@class='el-scrollbar__view el-select-dropdown__list']"))
            )
            sleep(1)
            areatype_select.click()
        else:
            print("area_type 为空，不执行选择区域类型的操作")

        STEP(4, f'输入区域名称:{area_name}')
        area_name_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//div[contains(@class,'dialog_input')]//input[contains(@placeholder,'请输入区域名称')]"))
        )
        area_name_input.clear()
        area_name_input.send_keys(area_name)

        STEP(5, f'填写IP地址:{area_ip}')
        area_ip_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='IP地址']"))
        )
        area_ip_input.clear()
        area_ip_input.send_keys(area_ip)

        STEP(6, f'填写备注:{remark}')
        funtion_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='备注']"))
        )
        funtion_remark.clear()
        funtion_remark.send_keys(remark)

        STEP(7, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//div[@aria-label='新增']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(8, '验证是否新增成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located(
                (By.CSS_SELECTOR, '.el-message__content'))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == info)

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        sleep(1)
        wd.refresh()