import sys
import os

from hytest.common import SELENIUM_LOG_SCREEN

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..', '..', '..')))
from 运维集控.项目测试.运维标准版.lib.base import *


class UserModify001:
    name = '修改用户-001-修改用户全部信息'
    def teststeps(self):
        wd = GSTORE['wd']

        STEP(1, '点击搜索框')
        user_query = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//input[@placeholder='请输入名称']"))
        )
        user_query.clear()
        user_query.send_keys("test_user1")

        STEP(2, '勾选用户')
        select_click= WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//th[contains(@class,'is-leaf el-table__cell')]//span[contains(@class,'el-checkbox__inner')]"))
        )
        select_click.click()

        STEP(3, '点击编辑按钮')
        user_update = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//span[contains(text(),'编辑')]"))
        )
        user_update.click()

        STEP(4, '修改用户名称')
        account_name_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located((By.XPATH, "//div[contains(@class,'dialog-input')]//input[contains(@placeholder,'请输入名称')]"))
        )
        account_name_input.clear()
        account_name_input.send_keys("test_update")

        STEP(5, '勾选修改密码按钮')
        user_passwd_click = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//span[@class='el-checkbox__label']"))
        )
        user_passwd_click.click()
        sleep(2)

        STEP(6, '填写当前用户密码')
        current_passwd = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输当前登录用户的密码']"))
        )
        current_passwd.clear()
        current_passwd.send_keys("ub@123456")

        STEP(7, '填写新密码')
        newpasswd = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='必须包含字母（不区分大小写）、数字和特殊字符，至少8个字符']"))
        )
        newpasswd.clear()
        newpasswd.send_keys("ub@12345678")

        STEP(8, '填写确认密码')
        verify_passwd = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请确认密码']"))
        )
        verify_passwd.clear()
        verify_passwd.send_keys("ub@12345678")

        STEP(9, '填写用户工号')
        sepasswd_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入工号']"))
        )
        sepasswd_input.clear()
        sepasswd_input.send_keys("123456")

        STEP(9, '填写手机号')
        phone = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入手机号码']"))
        )
        phone.clear()
        phone.send_keys("13169131242")

        STEP(10, '填写邮箱')
        sepasswd_input = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='请输入邮箱']"))
        )
        sepasswd_input.clear()
        sepasswd_input.send_keys("12341@qq.com")

        STEP(11, '填写备注')
        user_remark = WebDriverWait(wd, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//input[@placeholder='备注']"))
        )
        user_remark.clear()
        user_remark.send_keys("测试用户")

        STEP(12, '点击确认')
        commit = WebDriverWait(wd, 10).until(
            EC.element_to_be_clickable((By.XPATH, "//div[@aria-label='编辑']//span[contains(text(),'确 定')]"))
        )
        commit.click()

        STEP(13, '验证是否编辑成功')
        get_menu = WebDriverWait(wd, 10).until(
            EC.visibility_of_element_located((By.XPATH, "//p[contains(@class,'el-message__content')]"))
        )
        get_menu1 = get_menu.text
        CHECK_POINT('检查是否出现成功提示弹窗', get_menu1 == "操作成功!")

        # 截图并保存
        SELENIUM_LOG_SCREEN(wd, "50%")
        wd.refresh()