# -*- coding: utf-8 -*-
# cython: language_level=3
import json
import paho.mqtt.client as mqtt

# 创建MQTT客户端
client = mqtt.Client(protocol=mqtt.MQTTv311)

# 连接服务器
broker_address = "139.159.185.67"
port = 1881
client.connect(broker_address, port)

# 发布消息
topic = "/maintain/room/master/client/"
message = {
    "data": {
        "roomBindData": {
            "alias": "1111",
            "appToken": "AND-HW-P1OK",
            "cnum": "27981f71989f8ce04e0f74d577ce8b72",
            "companyNumber": "CN-HW-V3LR",
            "conferenceId": 108,
            "conferenceNumber": "27981f71989f8ce04e0f74d577ce8b72",
            "roomName": "C1120",
            "serverUrl": "http://139.159.185.67:8998"
        },
        "attendants": {
            "isCanSign": True,
            "mid": "2024-0921052238733",
            "name": "于治-普通用户2",
            "uid": "122626"
        }
    },
    "action": "attendantCloseAllDevices",
    "device_udid": "ef43f26aead65ec1f230fdd5e5f5c367ee3f23306171f3cfdc9f97b90fe9b5f4"
}
client.publish(topic, json.dumps(message), qos=0)

# 断开连接
client.disconnect()
