# import mysql.connector
# from mysql.connector import Error
# import json
#
#
# def create_connection():
#     with open('config.json') as config_file:
#         config = json.load(config_file)
#
#     connection = None
#     try:
#         connection = mysql.connector.connect(
#             host=config['host_name'],
#             port=config['mysql_port'],
#             user=config['user_name'],
#             password=config['user_password'],
#             database=config['db_name']
#         )
#         print("Connection to MySQL DB successful")
#     except Error as e:
#         print(f"The error '{e}' occurred")
#
#     return connection
#
#
# def execute_query(connection, query):
#     if connection is not None:
#         try:
#             cursor = connection.cursor(dictionary=True)
#             cursor.execute(query)
#             results = cursor.fetchall()
#             return results
#         except Error as e:
#             print(f"The error '{e}' occurred")
#         finally:
#             cursor.close()
#
#
# def save_results(results):
#     data_dict = {}
#     for row in results:
#         company_id = row['roommaster_company_id']
#         if company_id not in data_dict:
#             data_dict[company_id] = []
#         data_dict[company_id].append(row)
#     return data_dict
#
#
# def get_data_dict():
#     connection = create_connection()
#     query = """
#     SELECT
#         rd.udid AS roomdevice_udid,
#         rd.name AS roomdevice_name,
#         rm.id AS roommaster_id,
#         rm.name AS roommaster_name,
#         rm.udid AS roommaster_udid,
#         rm.company_id AS roommaster_company_id
#     FROM
#         cmdb_roomdevice rd
#     JOIN
#         cmdb_roommaster rm
#     ON
#         rd.master_id = rm.id;
#     """
#     results = execute_query(connection, query)
#     data_dict = save_results(results)
#     if connection.is_connected():
#         connection.close()
#     return data_dict
#
#
# def main():
#     data_dict = get_data_dict()
#     print(data_dict)
#
#     # 打印数据字典的键，确保数据保存正确
#     print("Data dictionary keys:", list(data_dict.keys()))
#
#     # 打印每个公司ID对应的数据，确保数据保存正确
#     for company_id, rows in data_dict.items():
#         print(f"Company ID {company_id} has {len(rows)} records:")
#         for row in rows:
#             print(row)
#
#
# if __name__ == "__main__":
#     main()


import mysql.connector
from mysql.connector import Error
import json
from flask import Flask, request, jsonify
import logging

app = Flask(__name__)
logging.basicConfig(level=logging.DEBUG, format='%(asctime)s - %(levelname)s - %(message)s')


def create_connection():
    with open('config.json') as config_file:
        config = json.load(config_file)

    connection = None
    try:
        connection = mysql.connector.connect(
            host=config['host_name'],
            port=config['mysql_port'],
            user=config['user_name'],
            password=config['user_password'],
            database=config['db_name']
        )
        print("Connection to MySQL DB successful")
    except Error as e:
        print(f"The error '{e}' occurred")

    return connection


def execute_query(connection, query):
    if connection is not None:
        try:
            cursor = connection.cursor(dictionary=True)
            cursor.execute(query)
            results = cursor.fetchall()
            return results
        except Error as e:
            print(f"The error '{e}' occurred")
        finally:
            cursor.close()


def save_results(results):
    data_dict = {}
    for row in results:
        company_id = row['roommaster_company_id']
        if company_id not in data_dict:
            data_dict[company_id] = []
        data_dict[company_id].append(row)
    return data_dict


def get_data_dict():
    connection = create_connection()
    query = """
    SELECT 
        rd.udid AS roomdevice_udid,
        rd.name AS roomdevice_name,
        rm.id AS roommaster_id,
        rm.name AS roommaster_name,
        rm.udid AS roommaster_udid,
        rm.company_id AS roommaster_company_id
    FROM 
        cmdb_roomdevice rd
    JOIN 
        cmdb_roommaster rm
    ON 
        rd.master_id = rm.id;
    """
    results = execute_query(connection, query)
    data_dict = save_results(results)
    if connection.is_connected():
        connection.close()
    return data_dict


def main():
    global data_dict
    data_dict = get_data_dict()
    print(data_dict)

    # 打印数据字典的键，确保数据保存正确
    print("Data dictionary keys:", list(data_dict.keys()))

    # 打印每个公司ID对应的数据，确保数据保存正确
    for company_id, rows in data_dict.items():
        print(f"Company ID {company_id} has {len(rows)} records:")
        for row in rows:
            print(row)


@app.route('/get_regions', methods=['GET'])
def get_regions():
    try:
        company_id = int(request.args.get('company_id'))
        logging.debug(f"收到公司ID: {company_id}")

        regions = []
        for row in data_dict.get(company_id, []):
            region_info = {
                'roommaster_id': row['roommaster_id'],
                'roommaster_name': row['roommaster_name'],
                'roommaster_udid': row['roommaster_udid']
            }
            regions.append(region_info)

        if not regions:
            logging.warning(f"未找到公司ID {company_id} 对应的区域信息")
            return jsonify({"error": f"未找到公司ID {company_id} 对应的区域信息"}), 404

        return jsonify(regions)

    except (ValueError, TypeError) as e:
        logging.error(f"无效的公司ID: {request.args.get('company_id')}")
        return jsonify({"error": "无效的公司ID"}), 400


if __name__ == '__main__':
    main()
    app.run(debug=True)