#!/bin/bash

# 宿主机上的脚本：检查 Nacos，失败则重启 ujava2 容器中的服务
LOG_FILE="/var/log/monitor_nacos_service.log"

log() {
    local message
    message="$(date '+%Y-%m-%d %H:%M:%S') - $1"
    echo "$message"
    # 同时写入日志文件
    echo "$message" >> "$LOG_FILE"
}

check_nacos() {
    # 确保 127.0.0.1:8848 可访问（Nacos 端口已映射到宿主机）
    if curl -sf http://127.0.0.1:8848/nacos/v1/console/health/readiness >/dev/null; then
        return 0
    else
        return 1
    fi
}

restart_in_container() {
    log "Nacos NOT READY. Restarting services in container 'ujava2'..."

    # 检查容器是否正在运行（精确匹配名称）
    if ! docker ps --format '{{.Names}}' | grep -Fxq "ujava2"; then
        log "ERROR: Container 'ujava2' is not running!"
        return 1
    fi

    # 在容器内执行 start.sh
    if docker exec ujava2 /var/www/java/start.sh; then
        log "SUCCESS: Services restarted in ujava2."
    else
        log "ERROR: Failed to run start.sh in ujava2."
    fi
}

# 主逻辑
log "开始检查 Nacos 服务状态..."
if check_nacos; then
    log "Nacos is healthy."
else
    log "Nacos is not responding."
    restart_in_container
fi