# upython容器构建PRD文档

## 1. 项目概述

### 项目背景
upython容器构建项目旨在创建一个轻量级、高效的Python运行环境容器，基于Alpine Linux系统，预装必要的运行时依赖和Python框架，用于部署Python Web应用程序。

### 核心问题
- 构建一个轻量级但功能完整的Python运行环境
- 确保容器的安全性和稳定性
- 预装必要的Python框架和工具

## 2. 系统功能

### 主要功能
- **基础环境构建**：基于upython:v3.12.12镜像构建
- **依赖管理**：自动安装运行时依赖和构建依赖
- **Web框架支持**：预装Django、PyMySQL、uWSGI等常用框架
- **工具集成**：集成nginx、vim、net-tools等实用工具

### 关键特性
- 轻量级：基于Alpine Linux，镜像体积小
- 安全：使用虚拟构建依赖组，安装后立即清理构建依赖
- 完整：包含运行Python Web应用所需的全部组件
- 高效：使用缓存优化安装过程

## 3. 技术架构

### 架构图
```
宿主机
├── Docker Engine
    └── upython容器
        ├── 基础镜像：upython:v3.12.12
        ├── 系统工具：nginx, vim, net-tools, bash
        ├── Python包：Django, PyMySQL, uWSGI
        └── 构建依赖：gcc, musl-dev, build-base等（构建后清理）
```

### 设计模式
- **分层构建**：将基础环境、运行时依赖、应用代码分层管理
- **依赖清理**：构建依赖在安装完成后立即删除，减少镜像体积

### 关键技术决策
- 使用Alpine Linux作为基础系统，减小镜像体积
- 采用虚拟构建依赖组，确保构建完成后清理临时依赖
- 使用apk包管理器安装系统依赖，pip安装Python包

## 4. 技术选型

### 基础系统
- **操作系统**：Alpine Linux v3.23（基于upython:v3.12.12）
- **容器引擎**：Docker

### 系统工具
- **Web服务器**：nginx
- **文本编辑器**：vim
- **网络工具**：net-tools
- **包管理器**：pip

### Python框架
- **Web框架**：Django
- **数据库连接**：PyMySQL
- **应用服务器**：uWSGI

### 构建工具
- **编译器**：gcc
- **C库开发包**：musl-dev
- **构建工具**：build-base, python3-dev

## 5. 开发环境

### 构建环境要求
- Docker Engine 19.03或更高版本
- 支持多架构镜像构建（如果需要）

### 构建流程
```dockerfile
# 创建upython容器
# 基于你现有的轻量镜像（已基于 Alpine Linux v3.23）
FROM upython:v3.12.12

# 安装运行时依赖 + 构建依赖，安装 Python 包后立即清理构建依赖
RUN apk add --no-cache --virtual .build-deps \
        gcc \
        musl-dev \
        linux-headers \
        build-base \
        python3-dev \
    && apk add --no-cache \
        nginx \
        vim \
        net-tools \
        py3-pip \
        bash \
    && pip install --no-cache-dir --upgrade pip \
    && pip install --no-cache-dir \
        Django \
        PyMySQL \
        uWSGI \
    && apk del .build-deps
```

### 构建步骤说明
1. 以upython:v3.12.12作为基础镜像
2. 安装构建依赖（gcc, musl-dev等）到虚拟包组.build-deps
3. 安装运行时依赖（nginx, vim, net-tools, pip, bash）
4. 升级pip并安装Python包（Django, PyMySQL, uWSGI）
5. 删除构建依赖以减小镜像体积

## 6. 运行环境

### 构建命令
```bash
# 构建容器镜像
docker build -t upython:latest .

# 运行容器
docker run -itd  -p 8002:8002 -p 8000:8000 -p 8443:8443 -p 9009:9009 -v /var/www/html:/var/www/html -v /etc/localtime:/etc/localtime:ro --restart=always --mac-address="02:42:ac:11:00:06" --privileged --name=upython upython:latest /var/www/html/start.sh
```

### 部署方式
- 单机部署：使用Docker直接运行
- 容器编排：支持Kubernetes或Docker Swarm部署

### 配置管理
- 环境变量：通过Docker环境变量传入配置
- 配置文件：支持挂载外部配置文件

## 7. 技术约束

### 安全要求
- 镜像中不保留构建依赖，减少安全风险
- 使用非root用户运行应用（需要在应用层配置）

### 性能要求
- 镜像体积优化：通过清理构建依赖减小镜像大小
- 启动时间优化：预装必要依赖，减少应用启动时间

### 兼容性要求
- 基于Alpine Linux，确保与Python 3.12.x兼容
- 支持Django最新LTS版本
- 兼容PyMySQL和uWSGI的常用版本

## 8. 风险与应对

### 已知风险
- Alpine Linux使用musl libc而非glibc，某些C扩展可能存在兼容性问题
- 镜像中包含bash，需要确保安全使用

### 应对措施
- 在构建过程中测试关键依赖的兼容性
- 定期更新基础镜像和依赖包版本
- 使用Docker安全扫描工具检查镜像漏洞


问题：
1、ModuleNotFoundError: No module named 'Crypto'
解决：pip install pycryptodome
实际安装：pycryptodome-3.23.0

2、ModuleNotFoundError: No module named 'requests'
解决：pip3 install requests
实际安装：installed certifi-2026.1.4 charset_normalizer-3.4.4 idna-3.11 requests-2.32.5 urllib3-2.6.3

3、ModuleNotFoundError: No module named 'PIL'
解决：pip3 install Pillow
实际安装：Pillow-12.1.0

4、ModuleNotFoundError: No module named 'debug_toolbar'
解决：pip3 install django-debug-toolbar
实际安装：django-debug-toolbar-6.1.0

5、ModuleNotFoundError: No module named 'rest_framework'
解决：pip3 install djangorestframework
实际安装：djangorestframework-3.16.1

6、ModuleNotFoundError: No module named 'rest_framework_swagger'：
不兼容，官方推荐迁移到 drf-spectacular


7、