#!/bin/bash
#------------------------------检测模块-----------------------------------------------------

#------------------------------服务器检测-start---------------------------------------------

function checkOS() {
echo -e "\033[33m
**************《请检查当前系统是否适配》**************************************************
         \033[0m"

server_available_mem=`free -g |awk 'NR==2' | awk '{print$7}'`
server_max_mem=`free -g|awk 'NR==2' |awk '{print$2}'`

echo -e "\033[36m 
当前系统最大内存为:${server_max_mem}GB 可用内存为:${server_available_mem}GB
\033[0m "

#判断服务器的内存值小于约定的内存大小min_memory_value=15，就返回。否则成功。
if [ $server_max_mem -lt $min_memory_value ];then
    echo -e "\033[31m 
[warning]:当前系统内存为:${server_max_mem}G,建议将内存至少添加为: ${min_memory_value}G 
\033[0m "
else
    echo -e "\033[32m 
检查当前系统内存为:${server_max_mem}G 满足系统运行！
\033[0m "
fi


#判断服务器的内存值小于约定的内存大小min_memory_available=10，就返回。否则成功。

if [ $server_available_mem -lt $min_memory_available ];then
        echo -e "\033[31m 
[warning]:当前系统可用内存为:${server_available_mem}G,建议将内存至少添加为： ${min_memory_available}G ！
\033[0m "
else
        echo -e "\033[33m 
检查当前系统内存为:${server_available_mem}G 满足系统运行！
\033[00m "
fi

#判断服务的根分区的硬盘大小是否超过预设的硬盘资源。成功继续，否则退出。
server_disk_available=`df -B G /|awk '/\//{print$4}' | awk '{sub(/.{1}$/,"")}1'`

if [ $server_disk_available -lt $min_disk_available ];then
    echo -e "\033[31m 
[warning]:当前系统的硬盘空间为:${server_disk_available}G,建议将硬盘空间至少添加为: ${min_disk_available}G!
\033[0m "
else
    echo -e "\033[33m 
检测当前系统硬盘空间为:${server_disk_available}G 满足系统运行!
\033[0m "
fi

  
echo -e "\033[36m 
*******************************************************
*                  可适配的操作系统(ARM)              *
*                                                     *
*                     统信系统                        *
*                     鲲鹏系统                        *
*                     Ubuntu                          *
*                     redhat7                         *
*                     银河麒麟V10                     *
*                                                     *
*******************************************************
         \033[0m"
		 
echo -e "\033[36m
检测到当前操作系统如下，请确认是否适配：
         \033[0m"
cat /etc/redhat-release


#检查服务器时间和时区
echo -e "\033[33m
**************《请检查当前时间，时区是否正确》*****************************************************************
当前服务器时区、时间为:
\033[0m"
date=`date`
echo $date

yn1=y
read -p "确认无误请按 y ，不正确请按 n 修改时间:     " yn
if [ "$yn"x = "$yn1"x ]
then
        echo -e "\033[33m 
		下面进入系统部署。。。
		\033[0m"
		sleep 3
else
        read -p "输入当前日期，格式如2021/02/06——" da
        echo "="
        date -s $da
        read -p "输入当前时间，格式如18:00:00——" sa
        echo "="
        date -s $sa
        timedatectl set-timezone Asia/Shanghai
        clock -w
        echo "==================================================="
        echo "查看修改后的时间"
        date
fi
}


#------------------------------服务器检测-end------------------------------------------------------------------------------------------------------------------------

#------------------------------部署文件检测-start--------------------------------------------------------------------------------------------------------------------
function File_detection_java()
{
echo -e "\033[36m 
************************************
*检测预定系统部署文件是否完整。。。。
*
************************************
\033[0m"
ds1=$auto_java"/java/api-java-meeting2.0/conf"
ds2=$auto_java"/java/api-java-meeting2.0/config"
ds3=$auto_java"/java/api-java-meeting2.0/update"
ds4=$auto_java"/java/external-meeting-api"
ds5=$auto_java"/java/nginx-conf.d"
ds6=$auto_java"/redis"
ds7=$auto_java"/java/ubains-web-2.0"
ds8=$auto_java"/java/cert"
ds9=$auto_java"/server_bag/docker"
ds10=$auto_java"/server_bag/ntp"
ds11=$auto_java"/server_bag/"
ds12=$auto_java"/emqx"
ds13=$auto_java"/java"
ds14=$auto_java"/java/ubains-video-web-3.0"

fs1=$auto_java"/java/api-java-meeting2.0/run.sh"
fs2=$auto_java"/java/api-java-meeting2.0/update.sh"
fs3=$auto_java"/java/api-java-meeting2.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar"
fs4=$auto_java"/java/start.sh"
fs5=$auto_java"/server_bag/docker.service"
fs6=$auto_java"/server_bag/docker-20.10.9.tgz"
fs7=$auto_java"/server_bag/arm_uemqx5.8.7.tar.gz"
fs8=$auto_java"/server_bag/arm_java1.8.0_321.tar"
fs9=$auto_java"/server_bag/arm_mysql8.0.28.tar"
fs10=$auto_java"/server_bag/arm_redis6.2.6.tar"
fs11=$auto_java"/server_bag/arm_fastdfs.tar"
fs12=$auto_java"/new_auto.sh"


ds=($ds1 $ds2 $ds3 $ds4 $ds5 $ds6 $ds7 $ds8 $ds9 $ds10 $ds11 $ds12 $ds13 $ds14)
fs=($fs1 $fs2 $fs3 $fs4 $fs5 $fs6 $fs7  $fs8 $fs9 $fs10 $fs11 $fs12)
for j in 0 1 2 3 4 5 6 7 8 9 10;
 do
        if [ -d "${ds[j]}" ] ; then
        echo -e "\033[32m ${ds[j]} 文件校验成功！\033[0m"
        
        sleep 1
        else
        echo -e "\033[31m ${ds[j]} 文件不存在,请重新上传文件再执行脚本 \033[0m "
        exit
        fi
done

for j in 0 1 2 3 4 5 6 7 8 9 10 11 ;
 do
        if [ -f "${fs[j]}" ] ; then
        echo -e "\033[32m ${fs[j]} 文件校验成功！\033[0m"
        sleep 1
        else
        echo -e "\033[31m ${fs[j]} 文件不存在,请重新上传文件再执行脚本 \033[0m"
        exit
        fi
done
}
#------------------------------部署文件检测-end--------------------------------------------------------------------------------------------------------------------


#创建用户(预定安装需要:该用户与系统启动用户有关)
function add_user()
{
user=user
group=user

egrep "^$user" /etc/passwd >& /dev/null
if [ $? -ne 0 ]; then
    username="user"
    password="ubains666"
    useradd -m "$username"
    echo "$username:$password" | chpasswd
else
    echo -e '\033[32m 用户user已创建 \033[0m';
fi
}


#------------------------------开放防火墙端口-start------------------------------------------------------------------------------------------------------------------------

#--------开放预定端口---------------------
function firewalldjava()
{
#ssh登录（基本）22
#预定mqtt（基本）1883、8083
#预定后台（基本）8999
#预定对外接口后台（门口屏3.0）8996
#预定系统前端，非https（基本）8080
#预定系统前端，https（基本）443
#预定redis（基本）6379
#图片服务器（基本）8888
#预定后台调试（基本）8997
#fastdfs/tracker（基本）22122
#fastdfs/storage（基本）23000
#数据库端口（基本）8306
#无纸化同步环境  62121 554 1935 10000
#时间同步端口123(门口屏使用)
#预定会控页面（java容器内8083）
#预定登录系统后台8998
#登录系统前端8079
#smc视频会议8085
#cloudlink视频会议8088
#企业微信前端8086
#微信公众号前端8087
#微信公众号后端80

echo -e "\033[33m
*******************************************************
*检查firewalld状态......
*
*******************************************************
\033[0m"

$sudoset firewall-cmd --state
if [ $? -eq  0 ]; then
        echo -e "\033[32m
************************
*检查到firewalld已开启!
*
************************
		\033[0m"
	for j in 22 1883 8883 443 8997  62121 554 1935 10000
 	do
             #firewall-cmd --list-port |grep $j
             a=`firewall-cmd --list-port |grep $j|wc -l`
             if [ "$a" -gt "0" ]; then
		echo -e $j'\033[33m已开放 \033[0m';
             else
	        echo -e "\033[33m 开放端口 \033[0m"$j
                $sudoset firewall-cmd --zone=public --add-port=$j/tcp --permanent;
             fi
        done
	for i in 123 323
 	do
             #firewall-cmd --list-port |grep $j
             a=`firewall-cmd --list-port |grep $i|wc -l`
             if [ "$a" -gt "0" ]; then
		 echo -e $i'\033[33m 已开放 \033[0m';
             else
		 echo -e "\033[33m 开放端口 \033[0m"$j
               $sudoset firewall-cmd --zone=public --add-port=$i/udp --permanent;
             fi
        done

	$sudoset firewall-cmd --reload
    echo -e "\033[32m
*****************************************
*firewall-cmd --list-port查看已开放的端口
*
*****************************************
	\033[0m"
    $sudoset firewall-cmd --list-port
else
        echo -e $j"\033[31m firewalld已关闭 \033[0m"
fi
}
#------------------------------开放防火墙端口-end------------------------------------------------------------------------------------------------------------------------


#------------------------------服务安装-start------------------------------------------------------------------------------------------------------------------------

#docker安装
function docker_arm()
{
	echo -e "\033[33m 
*****************
*检查Docker...... 
*
*****************
	\033[0m"
	docker -v
    if [ $? -eq  0 ]; then
        echo -e "\033[32m 
********************
*检查到Docker已安装! 
*
********************
		\033[0m"
    else
        echo -e "\033[31m 
**************
*docker 未安装 
*
*docker安装中。。。
*
********************
		\033[0m"
	$sudoset mkdir -p $PWD/soft
        $sudoset cp -rf $auto_java/server_bag/docker-20.10.9.tgz $PWD/soft
        sleep 3
        $sudoset tar -xvf $PWD/soft/docker-20.10.9.tgz -C $PWD/soft
        $sudoset cp $PWD/soft/docker/*  /usr/bin/
        $sudoset rm -rf /etc/systemd/system/docker.service
        sleep 3
        $sudoset cp -rf $auto_java/server_bag/docker.service /etc/systemd/system/docker.service
        sleep 1
        $sudoset chmod +x /etc/systemd/system/docker.service
        sleep 3
        $sudoset systemctl daemon-reload 
        sleep 3
        $sudoset systemctl start docker  
        sleep 3
        $sudoset systemctl enable docker.service  
       
        echo -e "\033[32m 
********************
*docker安装完成！！！
*
********************
	   \033[0m"
$sudoset docker -v
    fi
}


#数据库配置

#arm架构mysql安装
function mysql_arm()
{
echo -e "\033[33m 
*****************
*检查mysql...... 
*
*****************
	\033[0m"
$sudoset docker images |grep mysql
$sudoset docker ps |grep umysql
if [ $? -eq  0 ]; then
    echo -e "\033[32m 
*******************
*检查到mysql已安装！ 
*
*******************
	\033[0m"
else
    echo -e "\033[31m 
**************
*mysql 未安装 
*
*mysql安装中。。。
*
********************
		\033[0m"
    $sudoset docker load -i $auto_java/server_bag/arm_mysql8.0.28.tar
    $sudoset docker tag 307738dc6d58 139.9.60.86:5000/umysql:v4
    $sudoset cp -rf $auto_java/server_bag/docker /usr/local/
    $sudoset chmod 755 /usr/local/docker/mysql/my.cnf
    sleep 3
	$sudoset docker run -p 8306:3306 --name umysql --mac-address="02:42:ac:11:00:05" -v /usr/local/docker/mysql/conf:/etc/mysql/conf -v /usr/local/docker/mysql/my.cnf:/etc/mysql/my.cnf -v /usr/local/docker/mysql/conf.d:/etc/mysql/conf.d -v /usr/local/docker/mysql/logs:/var/log/mysql -v /usr/local/docker/mysql/data:/var/lib/mysql -v /usr/local/docker/mysql/mysql-files:/var/lib/mysql-files -v /etc/localtime:/etc/localtime:ro --restart=always -e MYSQL_ROOT_PASSWORD="dNrprU&2S" -itd 139.9.60.86:5000/umysql:v4
    $sudoset docker ps
fi
sleep 15
#赋予数据库用户权限
$sudoset docker cp $auto_java/ubains.sql  umysql:/root/
$sudoset docker exec -i umysql bash <<'EOF'
mysql -uroot -p"dNrprU&2S"
grant all privileges on *.* to 'root'@'%';
CREATE USER  IF NOT EXISTS 'root'@'localhost' IDENTIFIED BY 'dNrprU&2S';
alter user 'root'@'localhost' identified by 'dNrprU&2S';
CREATE USER IF NOT EXISTS 'root'@'172.17.0.1' IDENTIFIED BY 'dNrprU&2S';
alter user 'root'@'172.17.0.1' identified by 'dNrprU&2S';
GRANT ALL PRIVILEGES ON *.* TO 'root'@'172.17.0.1';
GRANT ALL PRIVILEGES ON *.* TO 'root'@'%';
flush privileges;
alter user 'root'@'%' identified with mysql_native_password by 'dNrprU&2S';
alter user 'root'@'localhost' identified with mysql_native_password by 'dNrprU&2S';
use mysql;
update mysql.user set Grant_priv='Y',Super_priv='Y' where user = 'root' and host = '%';
CREATE USER IF NOT EXISTS 'mysqluser'@'%' IDENTIFIED BY 'dNrprU&2S';
alter user 'mysqluser'@'%' identified with mysql_native_password by 'dNrprU&2S';
update mysql.user set Grant_priv='Y',Super_priv='Y' where user = 'mysqluser' and host = '%';
select host,user,plugin from user;
flush privileges;
EOF

#上传ubains数据库
$sudoset docker exec -i umysql bash <<'EOF'
mysql -uroot -p"dNrprU&2S"
create DATABASE IF NOT EXISTS ubains;
CREATE USER 'mysqluser'@'%' IDENTIFIED BY 'dNrprU&2S';
GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' WITH GRANT OPTION;
flush privileges;
use ubains;
source /root/ubains.sql;
show databases;
show tables;
EOF
echo -e "\033[33m ubains数据库已导入成功！ \033[0m"

#修改数据库密码
#CURRENT_PASSWORD="Ubains@123"
#NEW_PASSWORD="dNrprU&2S"
#CONTAINER_NAME="umysql"
#USERS=("root" "mysqluser")
#for user in "${USERS[@]}"
#do
#  docker exec "$CONTAINER_NAME" mysql -u"$user" -p"$CURRENT_PASSWORD" -e "ALTER USER '$user'@'localhost' IDENTIFIED BY '$NEW_PASSWORD'; FLUSH PRIVILEGES;"
#  docker exec "$CONTAINER_NAME" mysql -u"$user" -p"$CURRENT_PASSWORD" -e "ALTER USER '$user'@'%' IDENTIFIED BY '$NEW_PASSWORD'; FLUSH PRIVILEGES;"
#done

$sudoset cp -rf $PWD/UbainsmysqlBakUp.sh /usr/local/docker/
#定时备份数据库
sudo chmod +x /usr/local/docker/UbainsmysqlBakUp.sh
/usr/local/docker/UbainsmysqlBakUp.sh
userset="root"
sleep 5
# 每天下午一点执行脚本
if cat /var/spool/cron/$userset |grep "UbainsmysqlBakUp.sh">/dev/null
then
echo -e "\033[32m 
*********************
*已配置数据库定时备份
*
*********************
 \033[0m"
sudo service crond restart
else
#每天13点备份
sudo cat >> /var/spool/cron/$userset<<EOF
0 13 * * * bash /usr/local/docker/UbainsmysqlBakUp.sh
EOF
sleep 3
sudo service crond restart
fi

}

#arm架构安装emqx(预定2.0)
function emqx_arm()
{
echo -e "\033[36m
*正在检查emqx是否安装...
	\033[0m"
$sudoset docker images |grep emqx
$sudoset docker ps |grep uemqx
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到eqmx已安装！正在进入下一步...
	\033[0m"
else
echo -e "\033[33m
*检查到eqmx未安装！正在安装...
	\033[0m"
$sudoset docker load -i $auto_java/server_bag/arm_uemqx5.8.7.tar.gz
$sudoset docker run -d \
    --name uemqx \
    --privileged \
    --restart always \
    --mac-address="02:42:ac:12:00:06" \
    -p 1883:1883 \
    -p 8883:8883 \
    -p 8083:8083 \
    -v /var/www/emqx/config/emqx.conf:/opt/emqx/etc/emqx.conf:ro \
    -v /var/www/emqx/config/auth-built-in-db-bootstrap.csv:/opt/emqx/etc/auth-built-in-db-bootstrap.csv:ro \
    -v /var/www/emqx/config/acl.conf:/opt/emqx/etc/acl.conf:ro \
    -v /var/www/emqx/data:/opt/emqx/data \
    -v /var/www/emqx/log:/opt/emqx/log \
    emqx/emqx:5.8.7
sleep 1
fi
}


#arm架构redis安装
function redis_arm()
{
echo -e "\033[36m
*正在检查redis服务是否安装...
	\033[0m"
$sudoset docker images |grep redis
$sudoset docker ps |grep uredis
if [ $? -eq  0 ]; then
    echo -e "\033[32m
*检查到redis服务已安装！
	\033[0m"
else
	echo -e "\033[33m
*检查到redis服务未安装，正在安装...
	\033[0m"
    $sudoset docker load -i $auto_java/server_bag/arm_redis6.2.6.tar
    sleep 3
    $sudoset docker tag 7a56bdc802f7 139.9.60.86:5000/redis:v2
    $sudoset docker run -itd --restart=always --mac-address="02:42:ac:11:00:04" -p 6379:6379 --name uredis -v /var/www/redis/redis-6.0.3.conf:/etc/redis/redis.conf -v /var/www/redis/data:/data -v /etc/localtime:/etc/localtime:ro 139.9.60.86:5000/redis:v2 redis-server /etc/redis/redis.conf --appendonly yes
fi
}

#arm架构java安装
function java_arm()
{
echo -e "\033[33m 
****************
*检查java...... 
*
****************
	\033[0m"
$sudoset docker images |grep java
$sudoset docker ps |grep java
if [ $? -eq  0 ]; then
    echo -e "\033[33m
******************
*检查到java已安装！ 
*
******************
	\033[0m"
else
	echo -e "\033[31m 
****************
*java   未安装 
*
*java安装中。。。
*
****************
	\033[0m"
    $sudoset docker load -i $auto_java/server_bag/arm_java1.8.0_321.tar
    $sudoset docker tag 5772d73fd433 139.9.60.86:5000/ujava:v4
    $sudoset docker run -itd --privileged -v $install_dir_java/java:/var/www/java -v $install_dir_java/java/nginx-conf.d/nginx_log:/usr/local/nginx/logs -v /etc/localtime:/etc/localtime:ro -v /var/fdfs/storage/data:/var/fdfs/storage/data -p 554:554 -p 1935:1935 -p 10000:10000 -p 2333:2333  -p 2334:2334 -p 8997:8997 -p 8998:8998 -p 8079:8079 -p 443:443 -p 8080:8080 -p 8085:8085 -p 8086:8086 -p 8087:8087 -p 8088:8088 -p 8889:8889 -p 8999:8999 --restart=always --mac-address="02:42:ac:11:00:02" --name ujava2 139.9.60.86:5000/ujava:v4 /var/www/java/start.sh
fi
}

#x86架构ntp安装
function ntp_x86()
{
echo -e "\033[33m 
****************
*检查ntp........
*
****************
	\033[0m"
$sudoset systemctl status ntpd |grep running
#ps -aux | grep ntp
if [ $? -eq  0 ]; then
    echo -e "\033[33m 
******************
*检查到ntp已安装！ 
*
******************
	\033[0m"
else
    echo -e "\033[31m 
****************
*ntp   未安装 
****************
	\033[0m"
        $sudoset cd $auto_java/server_bag/ntp
        $sudoset rpm -Uvh *.rpm --nodeps --force
	$sudoset systemctl enable ntpd
	$sudoset systemctl enable ntpdate
	$sudoset systemctl start ntpd
	$sudoset systemctl status ntpd
	$sudoset mv /etc/ntp.conf    /etc/ntp.confbak
	$sudoset cp $auto_java/server_bag/ntp/ntp.conf   /etc/
	$sudoset systemctl restart  ntpd
	$sudoset systemctl disable  chronyd
fi
}


#安装fastfds
function fastfds_arm()
{
echo -e "\033[33m 
******************
*检查fastfds...... 
*
******************
	\033[0m"
$sudoset docker images |grep fastfds
$sudoset docker ps |grep utracker
$sudoset docker ps |grep ustorage
if [ $? -eq  0 ]; then
	echo -e "\033[32m 
********************
*检查到fastfds已安装! 
*
********************
		\033[0m"
else
	echo -e "\033[31m 
*******************
*fastfds 未安装 
*
*fastfds安装中。。。
*
********************
		\033[0m"
    $sudoset docker load -i $auto_java/server_bag/arm_fastdfs.tar
    docker tag ab3274a2b55f 139.9.60.86:5000/ufastdfs:v2
    sleep 3
    $sudoset docker run -dti --network=host --name utracker  --restart=always  -e FASTDFS_IPADDR=$IP   -v /var/fdfs/storage:/home/fastdfs -v /etc/localtime:/etc/localtime 139.9.60.86:5000/ufastdfs:v2
    #$sudoset docker run -dti --network=host --name utracker --restart=always -v /var/fdfs/storage:/var/fdfs -v /etc/localtime:/etc/localtime 139.9.60.86:5000/ufastdfs:v2
    sleep 3
    #$sudoset docker run -dti --network=host --name ustorage --restart=always -e TRACKER_SERVER=$IP:22122 -v /var/fdfs/storage:/var/fdfs  -v /etc/localtime:/etc/localtime  139.9.60.86:5000/ufastdfs:v2 storage
fi
}

#arm架构检测服务安装
function monitor_arm()
{
    echo -e "\033[33m 检查jdk服务...... \033[0m"
    java -version
    if [ $? -eq 0 ]; then
        echo -e "\033[32m 检查到 jdk已安装，卸载已安装的java版本 \033[0m"
        $sudoset sed -i '/JAVA_HOME/d' /etc/profile
        $sudoset sed -i '/CLASSPATH/d' /etc/profile
        $sudoset sed -i '/^export JAVA_HOME/d' /etc/profile
        $sudoset sed -i '/^export CLASSPATH/d' /etc/profile
        $sudoset sed -i '/^export PATH/d' /etc/profile
        source /etc/profile
	echo -e "清空profile文件完成"

        echo -e "\033[33m 正在安装 jdk......\033[0m"
        $sudoset mkdir -p /opt/deploy/java
        $sudoset cp $auto_java/server_bag/jdk-8u361-linux-x64.tar.gz /opt/deploy/
        $sudoset tar -zxvf /opt/deploy/jdk-8u361-linux-x64.tar.gz -C /opt/deploy/java
        $sudoset sed -i '$a#set java environment' /etc/profile
        $sudoset sed -i '$aJAVA_HOME=/opt/deploy/java/jdk1.8.0_361' /etc/profile
        $sudoset sed -i '$aCLASSPATH=.:$JAVA_HOME/lib.tools.jar' /etc/profile
        $sudoset sed -i '$aPATH=$JAVA_HOME/bin:$PATH'   /etc/profile
        $sudoset sed -i '$aexport JAVA_HOME CLASSPATH PATH'  /etc/profile
        $sudoset source /etc/profile
        $sudoset java -version
	echo -e "java安装完成"

    else
        echo -e "\033[33m 正在安装 jdk......\033[0m"
        $sudoset mkdir -p /opt/deploy/java
        $sudoset cp $auto_java/server_bag/jdk-8u361-linux-x64.tar.gz /opt/deploy/
        $sudoset tar -zxvf /opt/deploy/jdk-8u361-linux-x64.tar.gz -C /opt/deploy/java
        $sudoset sed -i '$a#set java environment' /etc/profile
        $sudoset sed -i '$aJAVA_HOME=/opt/deploy/java/jdk1.8.0_361' /etc/profile
        $sudoset sed -i '$aCLASSPATH=.:$JAVA_HOME/lib.tools.jar' /etc/profile
        $sudoset sed -i '$aPATH=$JAVA_HOME/bin:$PATH'   /etc/profile
        $sudoset sed -i '$aexport JAVA_HOME CLASSPATH PATH'  /etc/profile
        sleep 2
	echo -e "开始source /etc/profile"
	$sudoset source /etc/profile
	echo -e "source完成"
        $sudoset source /etc/profile
	$sudoset java -version
	echo -e "java安装完成"
        $sudoset chmod 755 /var/www/java/external-meeting-api/run.sh
        $sudoset echo 'su - root -c "cd /var/www/java/external-meeting-api && ./run.sh"' | sudo tee -a /etc/rc.local > /dev/null
        $sudoset sh /var/www/malan/run.sh
        $sudoset sh /var/www/java/external-meeting-api/run.sh
        sleep 2
    fi
}


#------------------------------服务安装-end------------------------------------------------------------------------------------------------------------------------

#------------------------------文件上传&更改ip-start------------------------------------------------------------------------------------------------------------------------

#-----------------------------------预定系统--------------------------------------------
function java_files()
{
    echo -e "\033[36m 
*****************
*检查预定配置文件 
*
*****************
    \033[0m"
    
    $sudoset ls $install_dir_java | grep java
    if [ $? -eq 0 ]; then
        sleep 1
        echo -e "\033[33m 
************
*java已上传 
*
************
    \033[0m"

        # 进行更细致的判断
        subdirs=("api-java-dubbo" "api-java-meeting2.0" "cert" "external-meeting-api" "nginx-conf.d" "ubains-video-web-3.0" "ubains-web-2.0" "ubains-web-h5")
        all_exist=true

        for subdir in "${subdirs[@]}"; do
            if [ ! -d "$install_dir_java/java/$subdir" ]; then
                echo -e "\033[31m ${install_dir_java}/java/$subdir 文件不存在，准备上传... \033[0m"
                all_exist=false
                break # 找到一个不存在的目录后就可以停止检查
            fi
        done

        if [ "$all_exist" = true ]; then
            echo -e "\033[32m 所有必要的子目录都存在，无需上传。 \033[0m"
        else
            echo -e "\033[33m 
************
*上传缺失的文件中.....
************
    \033[0m"
            $sudoset mkdir -p $install_dir_java/java
            $sudoset cp -rf $auto_java/java $install_dir_java
            $sudoset cp -rf $auto_java/emqx $install_dir_java
            $sudoset cp -rf $auto_java/redis $install_dir_java
            $sudoset cp -rf $auto_java/malan $install_dir_java
        fi
    else
        sleep 1
        echo -e "\033[33m 
************
*检查到java未上传，上传文件中.....
************
    \033[0m"
        $sudoset mkdir -p $install_dir_java/java
        $sudoset cp -rf $auto_java/java $install_dir_java
        $sudoset cp -rf $auto_java/emqx $install_dir_java
        $sudoset cp -rf $auto_java/redis $install_dir_java
        $sudoset cp -rf $auto_java/malan $install_dir_java
    fi
    echo -e "\033[36m
*文件上传完毕！正在校验需要修改配置的文件....
	\033[0m"
dj1=$install_dir_java"/java/api-java-meeting2.0/conf"
dj2=$install_dir_java"/java/api-java-meeting2.0/config"
dj3=$install_dir_java"/java/api-java-meeting2.0/update"
dj4=$install_dir_java"/java/external-meeting-api"
dj5=$install_dir_java"/java/nginx-conf.d"
dj6=$install_dir_java"/redis"
dj7=$install_dir_java"/java/ubains-web-2.0"
dj8=$install_dir_java"/java/cert"
dj9=$install_dir_java"/emqx"
fj1=$install_dir_java"/java/api-java-meeting2.0/run.sh"
fj2=$install_dir_java"/java/api-java-meeting2.0/update.sh"
fj3=$install_dir_java"/java/api-java-meeting2.0/ubains-meeting-inner-api-1.0-SNAPSHOT.jar"
fj4=$install_dir_java"/java/start.sh"

dj=($dj1 $dj2 $dj3 $dj4 $dj5 $dj6 $dj7 $dj8 $dj9)
fj=($fj1 $fj2 $fj3 $fj4 )
for j in 0 1 2 3 4 5 6 7 8;
 do
        if [ -d "${dj[j]}" ] ; then
        echo -e "\033[32m ${dj[j]} 文件校验成功！\033[0m"
        else
        echo "${dj[j]} 文件不存在,请重新上传文件再执行脚本 "
        fi
done

for j in 0 1 2 3 ;
 do
        if [ -f "${fj[j]}" ] ; then
        echo -e "\033[32m ${fj[j]} 文件校验成功！\033[0m"
        sleep 1
        else
        echo "${fj[j]} 文件不存在,请重新上传文件再执行脚本 "
        fi
done

#更改配置文件ip
echo -e "\033[33m 
***************
*更改配置文件ip 
*
***************
	\033[0m"
file1=$install_dir_java'/java/api-java-meeting2.0/conf/fdfs_client.conf'
file2=$install_dir_java'/java/api-java-meeting2.0/config/config.js'
file3=$install_dir_java'/java/api-java-meeting2.0/config/application-prod.properties'
file4=$install_dir_java'/java/api-java-meeting2.0/config/application-mqtt.yml'
file5=$install_dir_java'/java/api-java-meeting2.0/config/application-thirdParty.properties'
file6=$install_dir_java'/java/ubains-web-2.0/static/config.json'
file7=$install_dir_java'/java/nginx-conf.d/meeting443.conf'
file8=$install_dir_java'/java/nginx-conf.d/video8083.conf'
file9=$install_dir_java'/java/nginx-conf.d/h5-8086.conf'
file10=$install_dir_java'/java/external-meeting-api/config/application-prod.properties'
file11=$install_dir_java'/java/external-meeting-api/config/application-mqtt.yml'
file12=$install_dir_java'/java/external-meeting-api/config/application-thirdParty.properties'
file13=$install_dir_java'/java/api-java-dubbo/dingding/config/application-prod.properties'
file14=$install_dir_java'/java/api-java-dubbo/dingding/config/bootstrap.yml'
file15=$install_dir_java'/java/api-java-dubbo/welink/config/application-prod.properties'
file16=$install_dir_java'/java/api-java-dubbo/welink/config/bootstrap.yml'
file=($file1 $file2 $file3 $file4 $file5 $file6 $file7 $file8 $file9 $file10 $file11 $file12 $file13 $file14 $file15 $file16)
for j in 0 1 2 3 4 5 7 8 9 10 11 12 13 14 15;
 do
        if [ -f "${file[j]}" ] ; then
        echo -e "\033[32m ${file[j]} 文件校验成功！\033[0m"
        
        sleep 1
        else
        echo "${file[j]} 文件不存在！ "
        fi
done

echo -e "\033[33m 服务器的ip为：\033[0m"$IP

for i in ${file[*]};

 do
    $sudoset sed -i "s/$ip/$IP/g"  $i
    echo $IP
    echo -e "\033[32m 已修改 $i \033[0m "
    sleep 1
done

sleep 3
echo -e "\033[33m 
***************
**文件配置修改完毕，正在授予文件可执行权限...
***************
	\033[0m"
$sudoset chmod 755 $install_dir_java/java/start.sh
$sudoset chmod 755 $install_dir_java/java/api-java-meeting2.0/run.sh
$sudoset chmod 755 $install_dir_java/java/api-java-meeting2.0/update.sh
$sudoset chmod 755 $install_dir_java/java/external-meeting-api/run.sh
#$sudoset chmod 755 $install_dir_java/java/external-meeting-api/check.sh
#$sudoset chmod 755 $install_dir_java/java/external-meeting-api/startExternalProject.sh
$sudoset chmod 755 $install_dir_java/java/api-java-dubbo/welink/run.sh
$sudoset chmod 755 $install_dir_java/java/api-java-dubbo/dingding/run.sh
$sudoset chmod 755 $install_dir_java/emqx/config/acl.conf
$sudoset chmod 755 $install_dir_java/emqx/config/emqx.conf
$sudoset chmod 755 $install_dir_java/emqx/config/auth-built-in-db-bootstrap.csv
$sudoset chmod 755 $install_dir_java/redis/redis-6.0.3.conf
#$sudoset chmod 755 $install_dir_java/malan/malan
#$sudoset chmod 755 $install_dir_java/malan/run.sh
echo -e "\033[36m
*已授予文件可执行权限！准备进入服务安装...
	\033[0m"
sleep 3
}

#------------------------------文件上传&更改ip-end--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#------------------------------全局配置-start--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
###服务器检测配置项
#mem-check
#最小内存大小G
min_memory_value=8
#最小有效内存大小G
min_memory_available=8
#disk-check
#最小硬盘资源大小G
#min_disk_value=200
#最小有效硬盘大小G
min_disk_available=50

#默认为空，如果为非root用户执行，则需要配置为sudo
sudoset=""
#------------------------------全局配置-end--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------脚本执行-start--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
sys1="ubains.txt"
sys2="devops.txt"
sys3="ubains_devops.txt"
checkOS
if [ -e "$PWD/$sys1" ]; then
  txt="检测该脚本为【预定系统 部署】"
  version="预定系统版本"
elif [ -e "$PWD/$sys2" ]; then
  txt="检测该脚本为【运维系统 部署】"
  version="运维系统版本"
elif [ -e "$PWD/$sys3" ]; then
  txt="检测该脚本为【预定系统+运维系统 部署】"
  version="预定系统+运维系统版本"
fi

#-------------------------------获取服务器ip-start--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#文件默认ip
ip='192.168.1.141'
IP=$(hostname -I | awk '{print $1}')
function server_ip()
{
	# 弹出弹框，并根据用户选择执行相应操作
	choice=$(whiptail --title "请选择操作" \
					  --menu "请确认服务器ip是否正确:$IP" 15 50 4 \
					  1 "是" \
					  2 "否" \
					  3 "退出" \
					  3>&1 1>&2 2>&3)

	# 根据用户选择执行相应操作
	case $choice in
		1)
			# 在这里编写操作1的代码逻辑
			;;
		2)
			# 设置对话框的标题和提示信息
			dialog_title="请输入服务器IP："
			dialog_prompt="请输入服务器IP："
			# 使用whiptail显示输入框，并将用户输入的值保存到变量input_value
			IP=$(whiptail --title "$dialog_title" --inputbox "$dialog_prompt" 10 50 3>&1 1>&2 2>&3)
			# 在这里编写操作2的代码逻辑
			;;
		3)
			exit
			# 在这里编写操作3的代码逻辑
			;;
		*)
			echo "无效的选择"
			;;
	esac
}
#-------------------------------获取服务器的ip-end-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#-------------------------------部署预定系统-------------------------------
    echo -e "\033[36m

---------------------------------------------开始部署预定系统---------------------------------------------------


    \033[0m"
	    server_ip
        #自动化脚本路径
        auto_java=$PWD
        #add_user
        if [ -d "$PWD/java" ]; then
          echo ""
        else
          unzip $PWD/java.zip -d $PWD/
          unzip $PWD/server_bag.zip -d $PWD/
        fi
        #检测文件
        File_detection_java
        rm -rf $PWD/java.zip
        rm -rf $PWD/server_bag.zip
        #开放防火墙
        firewalldjava
        #传输文件更改ip
        install_dir_java="/var/www"
        java_files
        #安装服务
        docker_arm
        mysql_arm
        redis_arm
        emqx_arm
        java_arm
        fastfds_arm
        #monitor_arm
        #ntp_x86

#___________________________________________________________________________________

echo -e "\033[32m
*************************************************************
*查看服务是否启动成功——————docker ps 
预定系统服务：umysql,uredis,ujava2，uemqx，ustorage，utracker
*
*************************************************************
\033[0m"

$sudoset docker ps

sleep 3
echo -e "\033[33m
**********************************************************************************************
*执行auth.sh查看日志激活（详细见操作手册）

**********************************************************************************************
\033[0m"


#------------------------------脚本执行-end------------------------------------------------------------------
#tail -1000f /var/www/java/api-java-meeting2.0/logs/ubains-INFO-AND-ERROR.log
