import sys
import os
# 获取当前脚本的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 构建统一平台的绝对路径
platform_path = os.path.abspath(os.path.join(current_dir, '..','..','..'))
# 添加路径到系统路径中
sys.path.append(platform_path)
# 导入模块
from 统一平台.base.bases import *
# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir, '..', '..', 'data', '统一平台PC端测试用例.xlsx')

class Unified_Platform_0001:
    #执行指令：
    # cd ./统一平台/
    # hytest --tag 统一平台
    tags = ['创建会议','重庆长安','统一平台']
    ddt_cases = read_xlsx_data(xlsx_file_path, sheet_name="新建会议&")
    def teststeps(self):
        wd = GSTORE['wd']
        # 保存当前窗口句柄
        original_window = wd.current_window_handle
        # 进入创建会议的页面
        safe_click((By.XPATH, "//p[contains(text(),'新建会议')]"), wd)
        wd.switch_to.window(wd.window_handles[1])
        name = self.name
        for step in self.para:
            locator_type = get_by_enum(step.get('locator_type'))
            locator_value = step.get('locator_value')
            element_type = step.get('element_type')
            element_value = step.get('element_value')
            expented_result = step.get('expented_result')
            print(f"正在执行JSON：{step}")
            if step.get("page") == "CreateMeeting":
                if element_type == "input":
                    safe_send_keys((locator_type, locator_value), element_value, wd)
                    sleep(1)
                elif element_type == "click":
                    safe_click((locator_type, locator_value), wd)
                    sleep(1)
                elif element_type == "getText":
                    # 获取提示文本
                    notify_text = elment_get_text((locator_type,locator_value), wd)
                    INFO(f"获取弹窗提示内容为：{notify_text}")
                    CHECK_POINT("判断会议是否创建成功", expented_result == notify_text)
        SELENIUM_LOG_SCREEN(wd, "50%")
        # 切换回原来的窗口
        wd.close()  # 关闭当前窗口
        wd.switch_to.window(original_window)  # 切换回原来的窗口