import sys
import os
# 获取当前脚本的绝对路径
current_dir = os.path.dirname(os.path.abspath(__file__))
# 构建统一平台的绝对路径
platform_path = os.path.abspath(os.path.join(current_dir, '..','..'))
# 添加路径到系统路径中
sys.path.append(platform_path)
# 导入模块
from 新统一平台.Base.base import *

# 构建XLSX文件的绝对路径
xlsx_file_path = os.path.join(current_dir,'..', '测试数据', '新统一平台测试用例.xlsx')

class NewUnifiedPlatform:
    #执行指令：
    # cd ./新统一平台/
    # hytest --tag 新统一平台
    tags = ['新统一平台前台首页', '新统一平台']
    ddt_cases = read_xlsx_data(xlsx_file_path,sheet_name="新统一平台跳转", case_type="标准版")

    def teststeps(self):
        """
        执行测试步骤函数，主要用于执行读取的测试用例并进行信息统计模块功能测试操作
        """
        # 从全局存储中获取webdriver对象
        wd = GSTORE['wd']
        name = self.name

        # 刷新页面
        # wd.refresh()
        # wd.refresh()
        # sleep(5)

        for step in self.para:
            # 赋值页面类型page
            page_type = step.get('page')
            # 赋值元素定位类型，并将字符串转为Enum类型
            locator_type = get_by_enum(step.get('locator_type'))
            # 赋值元素值
            locator_value = step.get('locator_value')
            # 赋值元素类型，例如：click点击、input输入框等
            element_type = step.get('element_type')
            # 赋值元素值，例如输入框的输入值
            element_value = step.get('element_value')
            # 赋值预期结果
            expected_result = step.get('expected_result')
            # 赋值等待时间
            # sleep_time = step.get('sleep_time')
            # 赋值操作步骤
            step_name = step.get('step')

            INFO(
                f"步骤名称: {step_name}\n"
            )


            if element_type == "click":
                safe_click((locator_type, locator_value), wd)
                sleep(5)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "input":
                safe_send_keys((locator_type, locator_value), element_value, wd)
                sleep(2)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "SwitchWindow":
                # 将字符转换为int类型
                element_value = int(element_value)
                wd.switch_to.window(wd.window_handles[element_value])
                sleep(2)
                # SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "login":
                # 退出系统登录
                safe_click((By.XPATH, "//div[@class='quit']"), wd)
                sleep(5)
                INFO(f"开始登录，账号为：{element_value[0]}，密码为：{element_value[1]}")
                safe_send_keys((By.XPATH, "//input[@placeholder='手机号/用户名/邮箱']"), "admin@XTY", wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='密码']"), "Ubains@4321", wd)
                safe_send_keys((By.XPATH, "//input[@placeholder='图形验证']"), "csba", wd)
                sleep(2)
                INFO("对协议进行勾选")
                safe_click((By.XPATH, "//div[@aria-label='提示']//span[contains(text(),'确定')]"), wd)
                INFO("已经勾选协议了")
                sleep(2)
                safe_click((By.XPATH, "//div[@id='pane-1']//div//span[contains(text(),'登录')]"), wd)
                INFO("已经点击登录了")
                sleep(2)

            elif element_type == "getTips":
                notify_text = get_notify_text(wd, (locator_type, locator_value))
                INFO(f"获取到的提示信息为：{notify_text}")
                sleep(2)
                CHECK_POINT(f"获取到的提示信息为：{notify_text}", expected_result in notify_text)
                SELENIUM_LOG_SCREEN(wd, "75")

            elif element_type == "getText":
                text = elment_get_text((locator_type, locator_value), wd)
                INFO(f"获取到的文本信息为：{text}")
                CHECK_POINT(f"获取到的文本信息为：{text}", expected_result in text)
                SELENIUM_LOG_SCREEN(wd, "75")
                sleep(2)

            elif element_type == "refresh":
                # 刷新页面
                INFO("刷新页面")
                # wd.refresh()
                # sleep(5)

            elif element_type == "url_jump":
                # 跳转页面
                INFO(f"跳转页面：{element_value}")
                wd.get(element_value)
                sleep(5)