# 权限组管理接口文档

## 基础信息
- **接口前缀**：`/permissionGroup`
- **请求头**：需要携带有效的 Token 认证
- **作者**：Jayson
- **版本**：v1.0
- **日期**：2026-01-12

---

## 1. 分页查询权限组

**接口地址**：`POST /permissionGroup/getPage`

**接口描述**：根据公司编号、权限组名称、启用状态等条件进行分页查询，支持模糊匹配权限组名称，按创建时间倒序排列

**请求参数**：

| 参数名 | 类型 | 必填 | 默认值 | 说明 |
|--------|------|------|--------|------|
| pageNum | Integer | 否 | 1 | 页码 |
| pageSize | Integer | 否 | 10 | 每页数量 |
| groupName | String | 否 | - | 权限组名称（模糊匹配） |
| isEnable | Integer | 否 | - | 启用状态：0-禁用，1-启用 |

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "records": [
      {
        "groupId": 1,
        "groupName": "管理员权限组",
        "permissions": "{\"meetingManage\":{\"create\":1,\"delete\":1,\"edit\":1,\"view\":1}}",
        "companyNumber": "COMP001",
        "isEnable": 1,
        "createTime": "2026-01-12 10:00:00",
        "updateTime": "2026-01-12 10:00:00"
      }
    ],
    "total": 100,
    "size": 10,
    "current": 1,
    "pages": 10
  }
}
```

---

## 2. 获取所有权限配置

**接口地址**：`GET /permissionGroup/getAllPermissions`

**接口描述**：从permission.json配置文件读取系统所有可配置的权限项，返回权限配置模板，用于前端权限组配置界面展示

**请求参数**：无

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "meetingManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "roomManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "userManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "departmentManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "roleManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "deviceManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "systemConfig": {"create": 0, "delete": 0, "edit": 0, "view": 0},
    "statistics": {"view": 0, "export": 0},
    "approval": {"approve": 0, "reject": 0, "view": 0},
    "serviceManage": {"create": 0, "delete": 0, "edit": 0, "view": 0}
  }
}
```

---

## 3. 新增权限组

**接口地址**：`POST /permissionGroup/add`

**接口描述**：创建一个新的权限组，自动设置公司编号、创建时间等信息，权限配置以JSON格式存储

**请求参数**（JSON Body）：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| groupName | String | 是 | 权限组名称 |
| permissions | String | 是 | 权限配置JSON字符串 |
| isEnable | Integer | 否 | 启用状态：0-禁用，1-启用（默认） |

**请求示例**：
```json
{
  "groupName": "普通员工权限组",
  "permissions": "{\"meetingManage\":{\"create\":1,\"delete\":0,\"edit\":1,\"view\":1},\"roomManage\":{\"view\":1}}",
  "isEnable": 1
}
```

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "groupId": 2,
    "groupName": "普通员工权限组",
    "permissions": "{\"meetingManage\":{\"create\":1,\"delete\":0,\"edit\":1,\"view\":1},\"roomManage\":{\"view\":1}}",
    "companyNumber": "COMP001",
    "isEnable": 1,
    "createTime": "2026-01-12 14:30:00",
    "updateTime": "2026-01-12 14:30:00"
  }
}
```

---

## 4. 修改权限组

**接口地址**：`PUT /permissionGroup/update`

**接口描述**：更新指定权限组的名称、权限配置、启用状态等信息，自动更新updateTime字段

**请求参数**（JSON Body）：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| groupId | Long | 是 | 权限组ID |
| groupName | String | 否 | 权限组名称 |
| permissions | String | 否 | 权限配置JSON字符串 |
| isEnable | Integer | 否 | 启用状态：0-禁用，1-启用 |

**请求示例**：
```json
{
  "groupId": 2,
  "groupName": "修改后的权限组名称",
  "permissions": "{\"meetingManage\":{\"create\":1,\"delete\":1,\"edit\":1,\"view\":1}}",
  "isEnable": 1
}
```

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "groupId": 2,
    "groupName": "修改后的权限组名称",
    "permissions": "{\"meetingManage\":{\"create\":1,\"delete\":1,\"edit\":1,\"view\":1}}",
    "isEnable": 1,
    "updateTime": "2026-01-12 15:00:00"
  }
}
```

---

## 5. 删除权限组

**接口地址**：`POST /permissionGroup/delete`

**接口描述**：执行物理删除操作，同时级联删除部门关联、角色关联、用户关联表中的数据，使用事务确保删除操作的原子性。基础权限组（is_base=1）不可删除。

**请求参数**（JSON Body）：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| - | `List<Long>` | 是 | 要删除的权限组ID列表 |

**请求示例**：
```json
[1, 2, 3]
```

**响应示例**（成功）：
```json
{
  "code": 200,
  "message": "success",
  "data": "删除成功"
}
```

**响应示例**（包含基础权限组）：
```json
{
  "code": "A_PARAM_ILLEGAL",
  "message": "基础权限组不可删除：超级管理员, 普通用户",
  "data": null
}
```

> ⚠️ **注意**：
> - 基础权限组（is_base=1）不可删除，会返回错误信息
> - 删除权限组会级联删除以下关联表中的数据：
>   - sys_permission_group_department（部门关联）
>   - sys_permission_group_role（角色关联）
>   - sys_permission_group_user（用户关联）

---

## 6. 保存绑定关系

**接口地址**：`POST /permissionGroup/bindRelation`

**接口描述**：保存权限组与部门/角色/用户的关联关系（全量覆盖模式），支持一次性保存多种类型的关联关系

**请求参数**（JSON Body）：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| groupId | Long | 是 | 权限组ID |
| departmentIds | `List<Long>` | 否 | 要绑定的部门ID列表，传null不处理，传[]清空 |
| roleIds | `List<Long>` | 否 | 要绑定的角色ID列表，传null不处理，传[]清空 |
| userIds | `List<Long>` | 否 | 要绑定的用户ID列表，传null不处理，传[]清空 |

**请求示例**（保存绑定关系）：
```
POST /permissionGroup/bindRelation
Content-Type: application/json

{
  "groupId": 1,
  "departmentIds": [10, 11],
  "roleIds": [5, 6],
  "userIds": [101, 102, 103]
}
```

**请求示例**（清空部门关联，保留其他）：
```json
{
  "groupId": 1,
  "departmentIds": []
}
```

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "departmentCount": 2,
    "roleCount": 2,
    "userCount": 3
  }
}
```

> 💡 **说明**：
> - **全量覆盖模式**：传入的ID列表将完全替换原有关联（先删后增）
> - 传入 `null`：不处理该类型关联，保持原样
> - 传入 `[]`（空数组）：清空该类型的所有关联
> - 传入 `[1,2,3]`：该类型的关联将变为1、2、3
> - departmentIds、roleIds、userIds 至少需要传入一种类型（可为空数组）
> - 适合"编辑后保存"场景：前端回显数据后，用户修改，直接提交最终结果

---

## 7. 查询绑定关系

**接口地址**：`GET /permissionGroup/getRelations`

**接口描述**：查询权限组已绑定的关联对象，支持按类型筛选或返回全部类型

**请求参数**：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| groupId | Long | 是 | 权限组ID |
| relationType | Integer | 否 | 关联类型：1-部门，2-角色，3-用户，不传则返回全部 |

**响应示例**（不传relationType，返回全部）：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "departments": [
      {"id": 1, "groupId": 1, "departmentId": 10, "createTime": "2026-01-12 10:00:00"}
    ],
    "roles": [
      {"id": 1, "groupId": 1, "roleId": 5, "createTime": "2026-01-12 10:00:00"}
    ],
    "users": [
      {"id": 1, "groupId": 1, "userId": 101, "createTime": "2026-01-12 10:00:00"},
      {"id": 2, "groupId": 1, "userId": 102, "createTime": "2026-01-12 10:00:00"}
    ]
  }
}
```

**响应示例**（relationType=3，仅返回用户）：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "users": [
      {"id": 1, "groupId": 1, "userId": 101, "createTime": "2026-01-12 10:00:00"},
      {"id": 2, "groupId": 1, "userId": 102, "createTime": "2026-01-12 10:00:00"}
    ]
  }
}
```

---

## 8. 查询用户最终权限

**接口地址**：`GET /permissionGroup/getUserPermissions`

**接口描述**：从三个维度获取用户的权限组并合并权限：
1. **直接绑定**：查询sys_permission_group_user中user_id=用户ID的权限组
2. **部门绑定**：查询sys_permission_group_department中department_id=用户所属部门ID的权限组
3. **角色绑定**：查询sys_permission_group_role中role_id=用户所属角色ID的权限组

**请求参数**：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| userId | Long | 是 | 用户ID |

**响应示例**：
```json
{
  "code": 200,
  "message": "success",
  "data": {
    "userId": 101,
    "permissions": {
      "meetingManage": {"create": 1, "delete": 1, "edit": 1, "view": 1},
      "roomManage": {"create": 0, "delete": 0, "edit": 0, "view": 1},
      "userManage": {"create": 0, "delete": 0, "edit": 0, "view": 1},
      "departmentManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
      "roleManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
      "deviceManage": {"create": 0, "delete": 0, "edit": 0, "view": 0},
      "systemConfig": {"create": 0, "delete": 0, "edit": 0, "view": 0},
      "statistics": {"view": 1, "export": 0},
      "approval": {"approve": 0, "reject": 0, "view": 1},
      "serviceManage": {"create": 0, "delete": 0, "edit": 0, "view": 0}
    },
    "groupCount": 3
  }
}
```

> 💡 **权限合并规则**：
> - 用户最终权限 = 直接绑定权限 ∪ 所属部门权限 ∪ 所属角色权限
> - 采用**并集策略**：对于同一权限项，有任意一个来源为1则最终为1
> - 仅合并启用状态(is_enable=1)的权限组

---

## 错误码说明

| 错误码 | 说明 |
|--------|------|
| 200 | 成功 |
| A_USER_NOT_EXIST | 用户不存在（Token无效） |
| A_LACK_PARAMS | 缺少必要参数 |
| A_PARAM_ILLEGAL | 参数不合法 |
| A_SELECT_EMPTY | 查询结果为空 |
| B_SERVER_ERR | 服务器内部错误 |

---

## 枚举值定义

### relationType（关联类型）

| 值 | 说明 | 对应表 |
|----|------|--------|
| 1 | 部门 | sys_permission_group_department |
| 2 | 角色 | sys_permission_group_role |
| 3 | 用户 | sys_permission_group_user |

### isEnable（启用状态）

| 值 | 说明 |
|----|------|
| 0 | 禁用 |
| 1 | 启用 |

### isBase（基础权限组标识）

| 值 | 说明 |
|----|------|
| 0 | 普通权限组（可删除） |
| 1 | 基础权限组（不可删除） |

---

## 数据库表结构

### sys_permission_group（权限组主表）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| group_id | bigint | 权限组ID（主键，自增） |
| group_name | varchar(100) | 权限组名称 |
| permissions | text | 权限配置JSON |
| company_number | varchar(64) | 公司编号 |
| is_enable | int | 是否启用(0:禁用，1:启用) |
| is_base | int | 是否基础权限组(0:否，1:是) |
| create_time | datetime | 创建时间 |
| update_time | datetime | 更新时间 |

### sys_permission_group_department（权限组-部门关联表）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| id | bigint | 主键ID（自增） |
| group_id | bigint | 权限组ID |
| department_id | bigint | 部门ID |
| create_time | datetime | 创建时间 |

### sys_permission_group_role（权限组-角色关联表）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| id | bigint | 主键ID（自增） |
| group_id | bigint | 权限组ID |
| role_id | bigint | 角色ID |
| create_time | datetime | 创建时间 |

### sys_permission_group_user（权限组-用户关联表）

| 字段名 | 类型 | 说明 |
|--------|------|------|
| id | bigint | 主键ID（自增） |
| group_id | bigint | 权限组ID |
| user_id | bigint | 用户ID |
| create_time | datetime | 创建时间 |

---

## 权限配置JSON格式说明

权限配置采用JSON格式存储，结构如下：

```json
{
  "模块名称": {
    "操作类型": 0或1
  }
}
```

- **值为0**：无权限
- **值为1**：有权限

### 示例

```json
{
  "meetingManage": {
    "create": 1,
    "delete": 0,
    "edit": 1,
    "view": 1
  },
  "roomManage": {
    "create": 0,
    "delete": 0,
    "edit": 0,
    "view": 1
  }
}
```

表示：
- 会议管理：可创建、可编辑、可查看，不可删除
- 会议室管理：仅可查看

---

*文档生成时间：2026年1月12日*
