# 计划执行_远程容器升级脚本开发

> 版本：V1.0
> 创建日期：2026-01-28
> 基于文档：`_PRD_远程容器升级需求文档.md`
> 交付物：
> - `remote_update.sh` (Linux版本)
> - `remote_container_update_win.ps1` (Windows版本)
> - `container_update.sh` (目标服务器部署脚本)

---

## 一、任务概述

开发一套远程容器自动化更新工具，支持从Linux/Windows本地主机远程更新Linux服务器上的Docker容器，涵盖Java、EMQX、Redis、Python、Nacos、Nginx六种容器类型，支持新统一平台和传统平台两种部署架构。

---

## 二、开发阶段划分

### 阶段一：container_update.sh 基础框架（优先级：高）

| 序号 | 任务 | 描述 | 预计产出 |
|------|------|------|----------|
| 1.1 | 创建脚本文件 | 创建 `container_update.sh` | 空壳脚本 |
| 1.2 | 实现日志函数 | `log()` 和 `log_to_file()` 函数 | 日志工具 |
| 1.3 | 定义容器配置 | 容器与镜像映射、容器描述 | 配置数组 |
| 1.4 | usage帮助函数 | usage() 函数 | 帮助文档 |
| 1.5 | 工具函数 | `release_port_if_busy()` 端口释放函数 | 端口管理 |

**日志格式规范：**
```bash
[YYYY-MM-DD HH:MM:SS] [INFO] 消息内容
[YYYY-MM-DD HH:MM:SS] [WARN] 警告内容
[YYYY-MM-DD HH:MM:SS] [ERROR] 错误内容
```

---

### 阶段二：container_update.sh 交互式模式（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 2.1 | 容器选择函数 | `select_container()` | 6种容器选择 |
| 2.2 | 文件检查函数 | `check_required_files()` | 多路径搜索镜像文件 |
| 2.3 | 平台检测函数 | `detect_platform()` | 检测 /data/services |
| 2.4 | 容器检查函数 | `check_and_stop_running_container()` | 查找并停止旧容器 |
| 2.5 | 交互式主函数 | `interactive_mode()` | 4步流程编排 |

**镜像文件搜索路径（按优先级）：**
```bash
1. 脚本目录/镜像文件
2. 当前工作目录/镜像文件
3. /data/temp/镜像文件
4. /home/containerUpdate/镜像文件
5. 当前目录递归搜索（深度2级）
```

---

### 阶段三：container_update.sh 命令行模式（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 3.1 | 参数解析 | main() 函数参数处理 | 容器名、镜像包、平台标识 |
| 3.2 | 路径处理 | 支持绝对路径和相对路径 | 自动转换为绝对路径 |
| 3.3 | 容器前缀提取 | 正则提取容器前缀 | 匹配 ujava3 → ujava |

**命令行模式用法：**
```bash
./container_update.sh <容器名> <镜像包> [--new-platform]
./container_update.sh ujava3 /data/temp/java1.8.0_472.tar.gz --new-platform
```

---

### 阶段四：container_update.sh 部署函数（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 4.1 | Java容器部署 | `java_newplatform_x86()` 和 `java_oldplatform_x86()` | 端口映射、目录挂载 |
| 4.2 | Redis容器部署 | `redis_newplatform_x86()` 和 `redis_oldplatform_x86()` | 配置迁移、端口释放 |
| 4.3 | EMQX容器部署 | `emqx_newplatform_x86()` 和 `emqx_oldplatform_x86()` | 端口释放 |
| 4.4 | Python容器部署 | `python_newplatform_x86()` 和 `python_oldplatform_x86()` | 目录检查、启动脚本 |
| 4.5 | Nacos容器部署 | `nacos_newplatform_x86()` | 仅新平台、端口释放 |
| 4.6 | Nginx容器部署 | `nginx_newplatform_x86()` | 仅新平台、用户创建、权限设置 |

**容器目录挂载（新旧平台对比）：**

| 容器类型 | 新平台目录 | 旧平台目录 |
| --- | --- | --- |
| ujava | /data/services/api, /data/services/web | /var/www/java |
| uredis | /data/middleware/redis/config, /data/middleware/redis/data | /var/www/redis/redis-8.2.2.conf, /var/www/redis/data |
| uemqx | /data/middleware/emqx/{config,data,log} | /var/www/emqx/{config,data,log} |
| upython | /data/services/api/python-cmdb | /var/www/html |
| unacos | /data/middleware/nacos → /home/nacos | - |
| unginx | /data/middleware/nginx/{config,data/html,log} | - |

---

### 阶段五：remote_update.sh 基础框架（优先级：高）

| 序号 | 任务 | 描述 | 预计产出 |
|------|------|------|----------|
| 5.1 | 创建脚本文件 | 创建 `remote_update.sh` | 空壳脚本 |
| 5.2 | 实现日志函数 | `log()` 函数 | 日志工具 |
| 5.3 | 版本参数支持 | `--version` / `-v` 参数 | 版本显示 |
| 5.4 | 定义服务器配置 | 3台预设服务器 | 关联数组配置 |
| 5.5 | 定义容器配置 | 容器与镜像映射、Docker镜像版本 | 关联数组配置 |
| 5.6 | SSH工具函数 | `ssh_exec()` 和 `scp_exec()` | sshpass封装 |

**服务器配置：**
```bash
# 3台预设服务器
SERVER_IP["1"]="192.168.5.48"
SERVER_USER["1"]="root"
SERVER_PASS["1"]="Ubains@123"
SERVER_DESC["1"]="标准版预定运维服务器"

# ... 服务器2、3 ...
```

---

### 阶段六：remote_update.sh 核心功能（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 6.1 | 容器选择 | 交互式选择6种容器 | 镜像文件映射 |
| 6.2 | 服务器选择 | 预设列表 + 手动输入 | 支持自定义SSH端口 |
| 6.3 | SSH连接测试 | `echo CONNECTION_OK` 验证 | 10秒超时 |
| 6.4 | 架构校验 | `uname -m` 检查 | x86架构验证 |
| 6.5 | 平台类型检测 | 检测 /data/services | 自动识别 + 手动确认 |
| 6.6 | 镜像版本校验 | `check_remote_image_version()` | 避免重复更新 |
| 6.7 | 文件传输 | scp/rsync 传输镜像和脚本 | 30秒超时 |
| 6.8 | 停止旧容器 | docker stop | 模糊匹配容器名 |
| 6.9 | 目录同步 | EMQX/Nginx/Python目录同步 | rsync优先，scp回退 |

**镜像版本映射：**
```bash
# Docker镜像版本（用于版本校验）
CONTAINER_DOCKER_IMAGE["ujava"]="139.9.60.86:5000/ujava:v6"
CONTAINER_DOCKER_IMAGE["uemqx"]="139.9.60.86:5000/uemqx:v2"
CONTAINER_DOCKER_IMAGE["uredis"]="139.9.60.86:5000/redis:v3"
CONTAINER_DOCKER_IMAGE["upython_new"]="139.9.60.86:5000/upython:v15"
CONTAINER_DOCKER_IMAGE["upython_old"]="139.9.60.86:5000/upython:v14"
CONTAINER_DOCKER_IMAGE["unacos"]="nacos-server:v2.5.2"
CONTAINER_DOCKER_IMAGE["unginx"]="nginx:1.29.3"
```

**本地目录配置（注意：remote_update.sh 使用绝对路径）：**
```bash
LOCAL_EMQX_DIR="/data/middleware/emqx"
LOCAL_PYTHON_DIR="/data/services/api/python-cmdb"
LOCAL_NGINX_DIR="/data/middleware/nginx"
```

---

### 阶段七：remote_update.sh 目录同步（优先级：中）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 7.1 | EMQX目录同步 | `sync_emqx_assets()` | 备份 + rsync/scp + 权限设置 |
| 7.2 | Nginx目录同步 | `sync_nginx_assets()` | 备份 + rsync/scp |
| 7.3 | Python目录同步 | `sync_python_assets()` | 预留功能，暂不启用 |

**目录同步逻辑（EMQX为例）：**
```bash
# 1. 创建远端目录
ssh_exec "mkdir -p '$remote_dir'"

# 2. 备份远端目录
backup_cmd="备份远端目录为 目录名_backup_时间戳"

# 3. 传输文件（优先rsync，回退scp）
if command -v rsync; then
    rsync -az --delete -e ssh ...
else
    scp -r ...
fi

# 4. 设置配置文件权限
ssh_exec "cd '$remote_dir/config' && chmod +x *.conf"
```

---

### 阶段八：remote_update.sh 远端部署（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 8.1 | 容器编号递增 | 从旧容器编号自动递增 | ujava2 → ujava3 |
| 8.2 | 远端脚本调用 | ssh执行部署脚本 | sed去\r + chmod +x |
| 8.3 | 清理临时文件 | 清理远端镜像包和脚本 | 保留或删除空目录 |

**容器编号递增逻辑：**
```bash
# 1. 查找旧容器
CURRENT_CONTAINER=$(docker ps --format '{{.Names}}' | grep -E '^容器前缀([0-9]+)?$' | sort -V | tail -n1)

# 2. 提取编号
if [[ -n "$CURRENT_CONTAINER" ]]; then
    LAST_NUM="${CURRENT_CONTAINER##*[!0-9]}"
    NEXT_NUM=$((LAST_NUM + 1))
else
    NEXT_NUM=1
fi

# 3. 新容器名
NEW_CONTAINER="${CONTAINER_PREFIX}${NEXT_NUM}"
```

---

### 阶段九：remote_container_update_win.ps1 基础框架（优先级：高）

| 序号 | 任务 | 描述 | 预计产出 |
|------|------|------|----------|
| 9.1 | 创建脚本文件 | 创建 `remote_container_update_win.ps1` | PowerShell脚本 |
| 9.2 | 实现日志函数 | `Write-Log()` 和 `Write-AuditLog()` | 日志+审计 |
| 9.3 | UTF-8编码设置 | 解决中文乱码 | 输入输出编码设置 |
| 9.4 | 服务器配置 | 4台预设服务器 | Hashtable配置 |

**日志+审计格式：**
```powershell
# 普通日志
[$timestamp] [INFO] 消息内容

# 审计日志
[$timestamp] [AUDIT] Action=DEPLOY_SUCCESS | Server=192.168.5.48 | Container=ujava3 | Details=部署成功
```

**UTF-8编码设置（重要）：**
```powershell
# 解决中文乱码问题
[Console]::OutputEncoding = [System.Text.Encoding]::UTF8
[Console]::InputEncoding = [System.Text.Encoding]::UTF8
$env:PYTHONIOENCODING = "utf-8"
$PSDefaultParameterValues['Out-File:Encoding'] = 'utf8'
```

---

### 阶段十：remote_container_update_win.ps1 依赖检测（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 10.1 | plink/pscp检测 | `Test-Dependencies()` | 本地优先、系统回退 |
| 10.2 | sshpass回退 | Git Bash/WSL/Cygwin环境 | 第三方工具支持 |
| 10.3 | 主机密钥处理 | 首次连接自动接受 | echo y \| 管道处理 |

**PuTTY工具查找顺序（重要）：**
```
1. 优先：脚本同目录下的 plink.exe/pscp.exe（离线可用）
2. 回退1：系统 PATH 中的 plink/pscp（已安装PuTTY）
3. 回退2：sshpass（Git Bash/WSL/Cygwin环境）
```

---

### 阶段十一：remote_container_update_win.ps1 核心功能（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 11.1 | SSH命令执行 | `Invoke-SSHCommand()` | plink优先 + sshpass回退 |
| 11.2 | SCP文件传输 | `Send-SCPFile()` | pscp优先 + sshpass回退 |
| 11.3 | SCP目录传输 | `Send-SCPDirectory()` | 递归传输 |
| 11.4 | 容器选择 | `Select-Container()` | 6种容器选择 |
| 11.5 | 服务器选择 | `Select-Server()` | 4台预设 + 手动输入 |
| 11.6 | 平台类型检测 | `Get-PlatformType()` | 自动检测 + 手动确认 |
| 11.7 | 镜像版本校验 | `Test-RemoteImageVersion()` | 容器镜像版本检查 |
| 11.8 | 目录同步 | `Sync-EmqxAssets()` 和 `Sync-NginxAssets()` | 备份 + 传输 |
| 11.9 | 远端部署执行 | 带TTY的plink执行 | 实时输出显示 |

**本地目录配置（注意：Windows版本使用相对路径）：**
```powershell
# 相对于脚本所在目录
$LOCAL_EMQX_DIR = "emqx"
$LOCAL_NGINX_DIR = "nginx"
```

---

### 阶段十二：异常处理与容错（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 12.1 | SSH连接失败 | 输出详细错误信息 | 检查点清单（IP/端口/密码/网络） |
| 12.2 | 架构不匹配 | 输出远端架构并终止 | 仅支持x86架构 |
| 12.3 | 镜像文件缺失 | 提示路径并终止 | 多路径搜索后仍缺失 |
| 12.4 | 平台限制不满足 | unacos/unginx仅支持新平台 | 终止操作 |
| 12.5 | 文件传输失败 | 输出错误并终止 | scp/rsync失败处理 |
| 12.6 | 远端部署失败 | 保留临时文件用于排查 | 退出码检查 |
| 12.7 | 目录同步失败 | EMQX/Nginx回退到远端配置 | 不影响主流程 |

**退出码定义（建议）：**
```bash
# remote_update.sh / remote_container_update_win.ps1
0  # 成功
1  # 通用错误
2  # 镜像文件不存在
3  # 部署脚本不存在
4  # SSH连接失败
5  # 架构不匹配
6  # 用户输入无效
7  # 服务器配置无效
8  # sshpass未安装（Linux版本）
9  # 容器编号无效
10 # 容器未配置镜像映射
11-19 # 各类操作失败（文件传输、目录同步等）
20 # 平台限制不满足
```

---

### 阶段十三：测试与验收（优先级：高）

| 序号 | 测试场景 | 验收标准 | 测试方法 |
|------|----------|----------|----------|
| 13.1 | 服务器连接 | 能成功连接所有预设服务器 | 执行脚本选择各服务器 |
| 13.2 | 容器更新（6种） | 能成功更新所有容器类型 | 逐一测试各容器 |
| 13.3 | 平台兼容 | 新旧平台正确识别和部署 | 选择新旧平台服务器 |
| 13.4 | 版本校验 | 检测到已存在镜像时提示用户 | 先部署一次，再部署 |
| 13.5 | 目录同步 | EMQX/Nginx目录正确同步 | 检查远端目录 |
| 13.6 | 日志审计 | 关键操作有日志记录 | 检查日志文件 |
| 13.7 | 异常处理 | 各异常情况有明确提示 | 模拟各类异常 |

---

## 三、文件结构

### 3.1 remote_update.sh 文件结构

```bash
remote_update.sh
├── 版本与脚本头部
│   ├── SCRIPT_VERSION="1.0.0"
│   └── shebang + set选项
│
├── 配置变量段
│   ├── REMOTE_ARCH_ALLOW_REGEX  # 架构白名单
│   ├── SERVER_IP/USER/PASS/DESC  # 3台预设服务器
│   ├── CONTAINER_OPTIONS          # 6种容器类型
│   ├── CONTAINER_IMAGE           # 容器与镜像文件映射
│   ├── CONTAINER_DOCKER_IMAGE    # Docker镜像版本映射
│   ├── LOCAL_EMQX_DIR             # 本地EMQX目录（绝对路径）
│   ├── LOCAL_PYTHON_DIR           # 本地Python目录（绝对路径）
│   ├── LOCAL_NGINX_DIR             # 本地Nginx目录（绝对路径）
│   └── DEFAULT_REMOTE_DIR          # 默认远端目录
│
├── 工具函数段
│   ├── log()                       # 日志输出
│   ├── ssh_exec()                  # SSH命令执行（sshpass封装）
│   ├── scp_exec()                  # SCP文件传输（sshpass封装）
│   ├── sync_emqx_assets()          # EMQX目录同步
│   ├── sync_python_assets()         # Python目录同步（预留）
│   ├── sync_nginx_assets()         # Nginx目录同步
│   └── check_remote_image_version() # 远端镜像版本校验
│
└── 主流程段
    ├── 服务器选择
    ├── 容器选择
    ├── SSH连接测试
    ├── 架构校验
    ├── 平台类型检测
    ├── 镜像版本校验
    ├── 文件传输
    ├── 停止旧容器
    ├── 目录同步
    ├── 远端部署脚本调用
    └── 清理临时文件
```

### 3.2 remote_container_update_win.ps1 文件结构

```powershell
remote_container_update_win.ps1
├── 版本与脚本头部
│   ├── $SCRIPT_VERSION = "1.2.1"
│   ├── #Requires -Version 5.1
│   └── 参数定义（RemoteDir）
│
├── UTF-8编码设置
│   ├── [Console]::OutputEncoding
│   ├── [Console]::InputEncoding
│   ├── $env:PYTHONIOENCODING
│   └── $PSDefaultParameterValues
│
├── 全局配置
│   ├── $REMOTE_ARCH_ALLOW_REGEX
│   ├── $SSH_TIMEOUT
│   ├── $ServerList（4台预设服务器）
│   ├── $ContainerOptions（6种容器）
│   ├── $ContainerDescMap（容器描述）
│   ├── $ContainerImage（镜像文件）
│   ├── $ContainerDockerImage（Docker镜像版本）
│   ├── $LOCAL_EMQX_DIR（相对路径）
│   ├── $LOCAL_NGINX_DIR（相对路径）
│   └── $DEPLOY_SCRIPT
│
├── 日志与审计
│   ├── Write-Log()            # 普通日志（控制台+文件）
│   ├── Write-AuditLog()        # 审计日志（仅文件）
│   └── $LOG_FILE               # 日志文件路径
│
├── 依赖检测
│   └── Test-Dependencies()      # plink/pscp/sshpass检测
│
├── SSH与SCP函数
│   ├── Invoke-SSHCommand()    # SSH命令执行（plink优先）
│   ├── Send-SCPFile()          # SCP文件传输（pscp优先）
│   └── Send-SCPDirectory()     # SCP目录传输（递归）
│
├── 选择器函数
│   ├── Select-Container()      # 容器选择
│   └── Select-Server()         # 服务器选择
│
├── 校验与检测函数
│   ├── Test-SSHConnection()    # SSH连接测试
│   ├── Test-RemoteArchitecture() # 架构校验
│   ├── Get-PlatformType()      # 平台类型检测
│   └── Test-RemoteImageVersion() # 镜像版本校验
│
├── 同步函数
│   ├── Sync-EmqxAssets()      # EMQX目录同步
│   └── Sync-NginxAssets()      # Nginx目录同步
│
├── 操作函数
│   ├── Stop-RemoteContainer()  # 停止远端旧容器
│   ├── Get-NewContainerName()   # 容器编号递增
│   └── Clear-RemoteFiles()      # 清理远端临时文件
│
└── 主流程段
    └── Main()                   # 主函数
```

### 3.3 container_update.sh 文件结构

```bash
container_update.sh
├── 版本与脚本头部
│   ├── shebang + set选项
│   ├── LOG_FILE（日志文件路径）
│   └── INTERACTIVE_LOG_ENABLED（日志开关）
│
├── 日志函数
│   ├── log()                   # 控制台+文件输出
│   └── log_to_file()            # 仅文件输出
│
├── 配置变量
│   ├── CONTAINER_IMAGE_MAP     # 容器与镜像文件映射
│   └── CONTAINER_DESC_MAP       # 容器描述信息
│
├── 工具函数
│   └── release_port_if_busy()   # 端口释放函数
│
├── 交互式模式
│   ├── select_container()        # 步骤1：选择容器
│   ├── check_required_files()    # 步骤2：检查文件
│   ├── detect_platform()         # 步骤3：检测平台
│   ├── check_and_stop_running_container() # 步骤4：停止旧容器
│   └── interactive_mode()       # 交互式主函数
│
├── 命令行模式
│   ├── main()                   # 命令行主函数
│   ├── 参数解析
│   ├── 容器前缀提取
│   └── 部署函数路由
│
└── 部署函数（10个函数）
    ├── java_newplatform_x86()      # Java新平台
    ├── java_oldplatform_x86()      # Java旧平台
    ├── redis_oldplatform_x86()     # Redis旧平台
    ├── redis_newplatform_x86()     # Redis新平台
    ├── emqx_oldplatform_x86()     # EMQX旧平台
    ├── emqx_newplatform_x86()     # EMQX新平台
    ├── python_newplatform_x86()   # Python新平台
    ├── python_oldplatform_x86()   # Python旧平台
    ├── nacos_newplatform_x86()    # Nacos（仅新平台）
    └── nginx_newplatform_x86()     # Nginx（仅新平台）
```

---

## 四、依赖与规范

### 4.1 依赖文档
- 代码规范：`Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结：`Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结：`Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范：`Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范：`Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`

### 4.2 外部依赖

#### remote_update.sh（Linux版本）
- `sshpass`：SSH自动密码认证
- `rsync`（可选）：高效文件传输
- `scp`：文件传输（rsync回退）
- `ssh`：远程命令执行
- `docker`：目标服务器容器操作

#### remote_container_update_win.ps1（Windows版本）
- `plink.exe`（PuTTY）：SSH连接（优先）
- `pscp.exe`（PuTTY）：文件传输（优先）
- `sshpass`（可选）：Git Bash/WSL/Cygwin环境回退
- PowerShell 5.1+

#### container_update.sh（目标服务器）
- `docker`：容器操作
- `bash`：Shell环境

---

## 五、验收清单

### 5.1 remote_update.sh（Linux版本）

- [ ] 脚本可正常执行，无语法错误
- [ ] 能选择3台预设服务器或手动输入服务器信息
- [ ] 能选择6种容器类型
- [ ] SSH连接测试功能正常
- [ ] 架构校验功能正常（仅x86通过）
- [ ] 平台类型自动检测功能正常（检测 /data/services）
- [ ] 远端镜像版本校验功能正常（已存在镜像时提示）
- [ ] 镜像文件和部署脚本传输功能正常
- [ ] 停止远端旧容器功能正常
- [ ] EMQX/Nginx目录同步功能正常（备份+传输+权限）
- [ ] 容器编号自动递增功能正常
- [ ] 远端部署脚本调用成功
- [ ] 清理远端临时文件功能正常
- [ ] 本地目录配置正确（绝对路径）

### 5.2 remote_container_update_win.ps1（Windows版本）

- [ ] 脚本可正常执行，无语法错误
- [ ] 能选择4台预设服务器或手动输入服务器信息
- [ ] UTF-8编码设置生效（无中文乱码）
- [ ] plink/pscp工具检测功能正常（本地优先+系统回退）
- [ ] SSH命令执行功能正常
- [ ] SCP文件/目录传输功能正常
- [ ] 日志文件生成在 logs/ 目录下
- [ ] 审计日志记录关键操作（SCRIPT_START/DEPLOY_START等）
- [ ] 能选择6种容器类型
- [ ] 架构校验功能正常
- [ ] 平台类型自动检测功能正常
- [ ] 远端镜像版本校验功能正常
- [ ] EMQX/Nginx目录同步功能正常
- [ ] 容器编号自动递增功能正常
- [ ] 远端部署脚本调用成功（带TTY显示实时输出）
- [ ] 清理远端临时文件功能正常
- [ ] 本地目录配置正确（相对路径）

### 5.3 container_update.sh（目标服务器部署脚本）

- [ ] 脚本可正常执行，无语法错误
- [ ] `--version` / `-v` 参数正常显示版本号
- [ ] 交互式模式4步流程正常（选择容器→检查文件→检测平台→停止容器）
- [ ] 命令行模式参数解析正常（容器名+镜像包+平台标识）
- [ ] 能更新所有6种容器类型
- [ ] 新平台和旧平台部署逻辑正确
- [ ] 镜像文件多路径搜索功能正常
- [ ] 容器编号自动递增功能正常
- [ ] 旧容器停止并移除功能正常
- [ ] 镜像加载功能正常（不存在则加载）
- [ ] 端口释放功能正常（Redis/EMQX/Nacos/Nginx）
- [ ] 配置文件迁移功能正常（Redis旧平台）
- [ ] nginx用户和组创建功能正常（Nginx）
- [ ] 容器启动并验证状态功能正常
- [ ] 交互式模式日志文件生成正常
- [ ] unacos/unginx平台限制检查正常

### 5.4 联合测试

- [ ] 从Linux主机能成功更新所有预设服务器
- [ ] 从Windows主机能成功更新所有预设服务器
- [ ] 手动输入服务器信息功能正常
- [ ] 新平台服务器部署功能正常
- [ ] 旧平台服务器部署功能正常
- [ ] unacos/unginx仅在平台限制检查时正确终止
- [ ] EMQX/Nginx目录同步功能正常
- [ ] 容器编号递增功能正常（ujava2→ujava3）
- [ ] 远端镜像已存在时版本校验功能正常
- [ ] Python容器更新时只部署容器不同步文件

---

## 六、部署说明

### 6.1 文件放置

```
远程容器更新/
├── remote_update.sh              # Linux版本远程更新脚本
├── remote_container_update_win.ps1 # Windows版本远程更新脚本
├── container_update.sh            # 目标服务器部署脚本
├── plink.exe                      # Windows依赖（可选）
├── pscp.exe                       # Windows依赖（可选）
├── emqx/                          # Windows本地EMQX目录（可选）
├── nginx/                         # Windows本地Nginx目录（可选）
├── java1.8.0_472.tar.gz            # Java镜像文件
├── uemqx5.8.4.tar.gz              # EMQX镜像文件
├── redis8.2.2.tar.gz              # Redis镜像文件
├── python_v15.tar.gz               # Python镜像文件
├── nacos-server-v2.5.2.tar.gz      # Nacos镜像文件
└── nginx-1.29.3.tar.gz            # Nginx镜像文件
```

### 6.2 Linux版本部署

```bash
# 1. 将脚本设置为可执行
chmod +x remote_update.sh

# 2. 安装sshpass（如未安装）
sudo apt-get install sshpass
# 或
sudo yum install sshpass

# 3. 将镜像文件放在脚本同目录

# 4. 执行脚本
./remote_update.sh

# 5. 或指定远端目录
./remote_update.sh /data/temp
```

### 6.3 Windows版本部署

```powershell
# 1. 下载 plink.exe 和 pscp.exe
# 下载地址：https://www.chiark.greenend.org/~sgtatham/putty/latest.html
# 或将文件放在脚本同目录

# 2. 打开PowerShell，设置执行策略
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser

# 3. 执行脚本
.\remote_container_update_win.ps1

# 4. 或指定远端目录
.\remote_container_update_win.ps1 -RemoteDir "/data/temp"
```

### 6.4 目标服务器部署（container_update.sh）

该脚本会自动传输到目标服务器并执行，无需手动部署。

如需单独使用：
```bash
# 交互式模式
./container_update.sh

# 命令行模式
./container_update.sh ujava3 /data/temp/java1.8.0_472.tar.gz --new-platform
```

---

## 七、关键实现要点

### 7.1 容器编号递增逻辑

**需求描述：**
- 查找匹配 `容器前缀([0-9]+)?$` 的最新容器
- 提取容器编号并自动+1
- 若无旧容器，新编号为1

**实现代码：**
```bash
# 查找旧容器
CURRENT_CONTAINER=$(docker ps --format '{{.Names}}' | grep -E '^${CONTAINER_PREFIX}([0-9]+)?$' | sort -V | tail -n1)

# 确定新容器编号
if [[ -n "$CURRENT_CONTAINER" ]]; then
    LAST_NUM="${CURRENT_CONTAINER##*[!0-9]}"
    if [[ -z "$LAST_NUM" ]]; then
        LAST_NUM=0
    fi
    NEXT_NUM=$((LAST_NUM + 1))
else
    NEXT_NUM=1
fi

NEW_CONTAINER="${CONTAINER_PREFIX}${NEXT_NUM}"
```

**测试用例：**
- 无旧容器：ujava1 → ujava2
- 有旧容器：ujava2 → ujava3
- 多版本容器：ujava3 → ujava4

---

### 7.2 平台类型自动检测逻辑

**需求描述：**
- 检测 `/data/services` 目录是否存在
- 存在→新统一平台
- 不存在→传统平台
- 检测失败时切换为手动确认

**实现代码：**
```bash
# 自动检测
PLATFORM_CHECK_OUTPUT="$(ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "[ -d /data/services ] && echo 'NEW_PLATFORM' || echo 'OLD_PLATFORM'" 2>/dev/null || echo "CHECK_FAILED")"
PLATFORM_CHECK_RESULT="$(echo "${PLATFORM_CHECK_OUTPUT}" | tr -d '\r' | awk 'NF {last=$0} END {print last}')"

if [[ "${PLATFORM_CHECK_RESULT}" == "NEW_PLATFORM" ]]; then
    PLATFORM_FLAG="--new-platform"
    PLATFORM_TYPE="new"
    log INFO "✅ 检测到 /data/services 目录存在，自动识别为新统一平台"
elif [[ "${PLATFORM_CHECK_RESULT}" == "OLD_PLATFORM" ]]; then
    PLATFORM_FLAG=""
    PLATFORM_TYPE="old"
    log INFO "✅ 未检测到 /data/services 目录，自动识别为传统平台"
else
    log WARN "⚠️ 自动检测平台类型失败，切换为手动确认模式"
    read -rp "目标服务器是否为新统一平台? (y/n): " PLATFORM_INPUT
    # ... 手动确认逻辑
fi
```

---

### 7.3 远端镜像版本校验逻辑

**需求描述：**
- 检查远端是否已存在目标Docker镜像
- 若存在，检查是否有容器在使用
- 交互式询问是否继续更新

**实现代码：**
```bash
check_remote_image_version() {
    local container_prefix="$1"
    local platform_type="$2"
    local expected_image

    # 根据容器类型和平台类型获取期望的镜像名称
    if [[ "${container_prefix}" == "upython" ]]; then
        if [[ "${platform_type}" == "new" ]]; then
            expected_image="${CONTAINER_DOCKER_IMAGE["upython_new"]}"
        else
            expected_image="${CONTAINER_DOCKER_IMAGE["upython_old"]}"
        fi
    else
        expected_image="${CONTAINER_DOCKER_IMAGE["${container_prefix}"]}"
    fi

    # 获取远端镜像列表
    local remote_images
    remote_images="$(ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "docker images --format '{{.Repository}}:{{.Tag}}'" 2>/dev/null || true)"

    # 检查镜像是否存在
    if echo "${remote_images}" | grep -qw "${expected_image}"; then
        log WARN "⚠️ 检测到远端服务器已存在目标镜像: ${expected_image}"
        log WARN "⚠️ 目标服务器可能已完成更新"

        # 检查是否有容器在使用
        local running_container
        running_container="$(ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "docker ps --format '{{.Names}}' | grep -E '^${container_prefix}([0-9]+)?$' | head -n1" 2>/dev/null || true)"

        if [[ -n "${running_container}" ]]; then
            # 获取容器使用的镜像
            local container_image
            container_image="$(ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "docker inspect --format '{{.Config.Image}}' '${running_container}'" 2>/dev/null || true)"
            if [[ "${container_image}" == "${expected_image}" ]]; then
                log WARN "⚠️ 检测到容器 ${running_container} 正在使用目标镜像 ${expected_image}"
                log WARN "⚠️ 目标服务器该容器已是最新版本，无需更新"
                read -rp "是否仍要继续更新? (y/n): " CONTINUE_INPUT
                # ... 用户选择逻辑
            fi
        fi

        # ... 交互式询问
    else
        log INFO "✅ 远端服务器尚未安装目标镜像 ${expected_image}，继续更新流程"
        return 0
    fi
}
```

---

### 7.4 EMQX目录同步完整流程

**需求描述：**
- 本地EMQX目录同步到远端
- 同步前自动备份远端目录
- 使用rsync优先，scp回退
- 同步后设置配置文件权限

**实现代码：**
```bash
sync_emqx_assets() {
    local remote_dir="$1"
    local platform_label="$2"

    # 检查本地目录是否存在
    if [[ ! -d "${LOCAL_EMQX_DIR}" ]]; then
        log ERROR "本地 EMQX 目录不存在: ${LOCAL_EMQX_DIR}"
        exit 11
    fi

    log INFO "准备同步 EMQX 目录 (${LOCAL_EMQX_DIR} -> ${REMOTE_HOST}:${remote_dir})"
    ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "mkdir -p '${remote_dir}'"

    # 备份远端目录
    local backup_cmd
    backup_cmd=$(cat <<'EOF'
set -e
TARGET_DIR="$1"
if [[ -d "${TARGET_DIR}" && -n "$(ls -A "${TARGET_DIR}")" ]]; then
    ts=$(date +%Y%m%d_%H%M%S)
    backup="${TARGET_DIR}_backup_${ts}"
    cp -r "${TARGET_DIR}" "${backup}"
    echo "${backup}"
fi
EOF
)
    local backup_path
    backup_path="$(ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "bash -s '${remote_dir}'" <<<"${backup_cmd}" || true)"
    if [[ -n "${backup_path}" ]]; then
        log INFO "远端目录已备份到 ${backup_path}"
    else
        log INFO "远端目录为空或不存在，跳过备份"
    fi

    # 传输文件（优先rsync，回退scp）
    if command -v rsync >/dev/null 2>&1; then
        log INFO "使用 rsync 同步 EMQX 目录"
        if ! sshpass -p "${REMOTE_PASS}" rsync -az --delete -e "ssh -p ${SSH_PORT} -o StrictHostKeyChecking=no -o ConnectTimeout=${SSH_TIMEOUT}" "${LOCAL_EMQX_DIR}/" "${REMOTE_USER}@${REMOTE_HOST}:${remote_dir}/"; then
            log ERROR "rsync 同步失败"
            exit 12
        fi
    else
        log WARN "未检测到 rsync，改用 scp 拷贝 EMQX 目录"
        if ! scp_exec -r "${LOCAL_EMQX_DIR}/." "${REMOTE_USER}@${REMOTE_HOST}:${remote_dir}/"; then
            log ERROR "scp 拷贝失败"
            exit 13
        fi
    fi

    # 设置配置文件权限
    ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "if [[ -d '${remote_dir}/config' ]]; then cd '${remote_dir}/config' && ls *.conf >/dev/null 2>&1 && chmod +x *.conf || true; else echo 'WARN: config 目录不存在'; fi"
    log INFO "远端 EMQX 配置权限处理完成 (${platform_label} 平台)"
}
```

---

### 7.5 Nginx镜像文件特殊处理

**需求描述：**
- Nginx镜像文件使用绝对路径 `/data/temp/nginx-1.29.3.tar.gz`
- 与其他容器（相对路径）不同

**实现代码：**
```bash
# 容器与镜像映射配置
CONTAINER_IMAGE["unginx"]="/data/temp/nginx-1.29.3.tar.gz"  # 绝对路径

# nginx 使用绝对路径，需要特殊处理
if [[ "${IMAGE_FILE}" = /* ]]; then
    # 绝对路径：先复制到临时位置，再传输
    TEMP_IMAGE="/tmp/$(basename "${IMAGE_FILE}")"
    cp "${IMAGE_FILE}" "${TEMP_IMAGE}"
    scp_exec "${TEMP_IMAGE}" "${DEPLOY_SCRIPT}" "${REMOTE_USER}@${REMOTE_HOST}:${REMOTE_DIR}/"
    rm -f "${TEMP_IMAGE}"
    # 在远端将镜像文件移动到正确位置
    ssh_exec "${REMOTE_USER}@${REMOTE_HOST}" "mkdir -p /data/temp && mv '${REMOTE_DIR}/$(basename "${IMAGE_FILE}")' /data/temp/$(basename "${IMAGE_FILE}")"
else
    # 相对路径：直接传输
    scp_exec "${IMAGE_FILE}" "${DEPLOY_SCRIPT}" "${REMOTE_USER}@${REMOTE_HOST}:${REMOTE_DIR}/"
fi
```

---

## 八、进度跟踪

| 阶段 | 状态 | 完成时间 | 备注 |
|------|------|----------|------|
| 阶段一：container_update.sh基础框架 | ✅ 已完成 | 2026-01-28 | 1492行，日志函数、配置变量、版本参数 |
| 阶段二：container_update.sh交互式模式 | ✅ 已完成 | 2026-01-28 | 4步交互流程、多路径镜像搜索 |
| 阶段三：container_update.sh命令行模式 | ✅ 已完成 | 2026-01-28 | 参数解析、路径处理、容器前缀提取 |
| 阶段四：container_update.sh部署函数 | ✅ 已完成 | 2026-01-28 | 10个部署函数（Java×2/Redis×2/EMQX×2/Python×2/Nacos×1/Nginx×1） |
| 阶段五：remote_update.sh基础框架 | ✅ 已完成 | 2026-01-28 | 653行，3台预设服务器、sshpass封装 |
| 阶段六：remote_update.sh核心功能 | ✅ 已完成 | 2026-01-28 | SSH连接、架构校验、平台检测、镜像版本校验、文件传输 |
| 阶段七：remote_update.sh目录同步 | ✅ 已完成 | 2026-01-28 | EMQX/Nginx/Python同步（rsync优先，scp回退） |
| 阶段八：remote_update.sh远端部署 | ✅ 已完成 | 2026-01-28 | 容器递增、远端脚本调用、临时文件清理 |
| 阶段九：remote_container_update_win.ps1基础框架 | ✅ 已完成 | 2026-01-28 | 1387行，4台预设服务器、UTF-8编码设置、日志审计 |
| 阶段十：remote_container_update_win.ps1依赖检测 | ✅ 已完成 | 2026-01-28 | plink/pscp本地优先+系统回退、sshpass回退、主机密钥自动接受 |
| 阶段十一：remote_container_update_win.ps1核心功能 | ✅ 已完成 | 2026-01-28 | SSH/SCP/目录传输、容器/服务器选择器、平台检测、镜像校验、目录同步 |
| 阶段十二：异常处理与容错 | ✅ 已完成 | 2026-01-28 | SSH连接失败、架构不匹配、镜像缺失、平台限制、文件传输失败等 |
| 阶段十三：测试与验收 | ⬜ 待执行 | - | 功能测试、联合测试 |

**脚本规模统计：**
| 脚本 | 行数 | 主要功能 |
|------|------|----------|
| container_update.sh | 1492行 | 目标服务器部署脚本，支持交互式和命令行模式 |
| remote_update.sh | 653行 | Linux版本远程更新脚本，3台预设服务器 |
| remote_container_update_win.ps1 | 1387行 | Windows版本远程更新脚本，4台预设服务器 |
| **合计** | **3532行** | 三份脚本完整实现 |

---

## 九、重要注意事项

### 9.1 脚本间差异总结

| 特性 | remote_update.sh | remote_container_update_win.ps1 | container_update.sh |
| --- | --- | --- | --- |
| 预设服务器数量 | 3台 | 4台 | - |
| 本地EMQX目录 | `/data/middleware/emqx`（绝对路径） | `脚本目录/emqx`（相对路径） | - |
| 本地Nginx目录 | `/data/middleware/nginx`（绝对路径） | `脚本目录/nginx`（相对路径） | - |
| 日志文件 | 无固定日志文件 | `脚本目录/logs/remote_update_*.log` | `脚本目录/container_update_*.log`（交互式） |
| 文件传输方式 | rsync优先，scp回退 | pscp（PuTTY工具） | - |
| SSH认证 | sshpass | plink优先，sshpass回退 | - |
| 主机密钥处理 | 自动接受 | 自动接受（echo y \|） | - |
| UTF-8编码 | 默认UTF-8 | 需设置UTF-8编码 | - |
| Nginx镜像路径 | `/data/temp/nginx-1.29.3.tar.gz`（绝对路径） | `nginx-1.29.3.tar.gz`（相对路径） | - |

### 9.2 开发顺序建议

1. **先开发 container_update.sh**
   - 这是基础，其他两个脚本都会调用它
   - 可以独立测试部署逻辑

2. **再开发 remote_update.sh**
   - Linux版本，相对简单
   - 依赖sshpass

3. **最后开发 remote_container_update_win.ps1**
   - Windows版本，需要处理编码问题
   - 需要处理PuTTY工具兼容性

### 9.3 关键技术点

1. **容器编号递增**：使用 `sort -V` 排序后取最新容器
2. **平台类型检测**：通过检测 `/data/services` 目录
3. **镜像版本校验**：避免重复更新
4. **目录同步备份**：防止配置丢失
5. **UTF-8编码处理**：Windows版本需特殊处理
6. **主机密钥自动接受**：首次连接时的处理
7. **绝对路径vs相对路径**：Nginx镜像文件的特殊处理

### 9.4 测试策略

1. **单元测试**：每个脚本独立功能测试
2. **集成测试**：三个脚本联调测试
3. **平台测试**：新平台和旧平台分别测试
4. **容器测试**：6种容器类型分别测试
5. **异常测试**：模拟各种异常场景

---

*本文档基于 PRD 自动生成，如有疑问请参考原需求文档。*
