# _PRD_远程容器升级需求文档

> 版本：V1.0
> 更新日期：2026-01-28
> 适用范围：远程容器升级自动化（Linux服务器容器更新）
> 实现脚本：
> - `远程容器更新/remote_update.sh` (Linux版本)
> - `远程容器更新/remote_container_update_win.ps1` (Windows版本)
> - `远程容器更新/container_update.sh` (目标服务器部署脚本)

---

## 1. 背景与目标

### 1.1 背景
当前容器版本更新需要运维人员手动登录目标服务器，执行一系列操作：上传镜像、停止旧容器、加载新镜像、启动新容器等。这种方式效率低下、容易出错，且无法快速响应多服务器的批量更新需求。

### 1.2 目标
实现一套远程容器自动化更新工具，具备：
- 支持从Linux/Windows本地主机远程更新Linux服务器上的Docker容器
- 支持多种容器类型（Java、EMQX、Redis、Python、Nacos、Nginx）
- 自动识别目标服务器平台类型（新统一平台/传统平台）
- 自动校验远端容器版本，避免重复更新
- 自动同步容器相关配置文件和数据目录
- 完整的日志记录与审计功能

---

## 2. 总体范围

### 2.1 纳入更新对象
1. **支持的容器类型**
   | 容器前缀 | 容器描述 | 镜像文件 |
   | --- | --- | --- |
   | ujava | Java 服务容器 | java1.8.0_472.tar.gz |
   | uemqx | EMQX 消息队列容器 | uemqx5.8.4.tar.gz |
   | uredis | Redis 缓存容器 | redis8.2.2.tar.gz |
   | upython | Python 服务容器 | python_v15.tar.gz |
   | unacos | Nacos 注册中心容器 | nacos-server-v2.5.2.tar.gz |
   | unginx | Nginx 反向代理容器 | nginx-1.29.3.tar.gz |

   **注意**：`remote_update.sh` 中 Nginx 镜像文件路径为 `/data/temp/nginx-1.29.3.tar.gz`（绝对路径），与其他容器（相对路径）不同。

2. **预设服务器列表**
   - **Linux版本** (remote_update.sh)：3台预设服务器
   - **Windows版本** (remote_container_update_win.ps1)：4台预设服务器

   | 编号 | 服务器描述 | IP地址 | 脚本支持 |
   | --- | --- | --- | --- |
   | 1 | 标准版预定运维服务器 | 192.168.5.48 | Linux + Windows |
   | 2 | 阿曼项目预定服务器 | 192.168.5.67 | Linux + Windows |
   | 3 | 标准版预定运维测试发布服务器 | 192.168.5.47 | Linux + Windows |
   | 4 | 新统一平台测试服务器 | 192.168.5.44 | 仅 Windows |

3. **平台类型**
   - **新统一平台**：使用 `/data/` 目录结构
   - **传统平台**：使用 `/var/www/` 目录结构

### 2.2 不在本期范围（可扩展）
- 多服务器并发更新（当前为串行更新）
- 容器版本回滚功能
- 更新前自动备份容器数据
- 统一告警通道（钉钉/邮件/短信）
- Web界面操作

---

## 3. 术语说明

| 术语 | 说明 |
| --- | --- |
| 容器前缀 | 容器名称的前缀，如 `ujava`、`uemqx`，用于标识容器类型 |
| 平台类型 | 目标服务器的部署架构，分为新统一平台和传统平台 |
| 镜像版本校验 | 通过检查远端Docker镜像列表，判断是否已安装目标版本 |
| 容器编号递增 | 新容器名称自动在旧容器编号基础上+1，如 `ujava2` → `ujava3` |
| sshpass | Linux下的SSH自动密码认证工具 |
| plink/pscp | Windows下的PuTTY工具，用于SSH连接和SCP文件传输 |

---

## 4. 功能需求

### 4.1 日志与审计
#### 4.1.1 日志文件
- **remote_update.sh (Linux版本)**: 控制台输出，无固定日志文件
- **remote_container_update_win.ps1 (Windows版本)**: `脚本目录/logs/remote_update_YYYYMMDD_HHMMSS.log`
- **container_update.sh (部署脚本)**: `脚本目录/container_update_YYYYMMDD_HHMMSS.log`（交互式模式时启用）

#### 4.1.2 日志格式
每行必须包含：
- 时间戳：`[YYYY-MM-DD HH:MM:SS]`
- 级别：`[INFO]` `[WARN]` `[ERROR]` `[AUDIT]`
- 日志内容

示例：
- `[2026-01-28 10:00:00] [INFO] ✅ 远端架构 x86_64 校验通过`
- `[2026-01-28 10:05:00] [AUDIT] Action=DEPLOY_SUCCESS | Server=192.168.5.48 | Container=ujava3 | Details=部署成功`

---

### 4.2 服务器连接与校验
#### 4.2.1 服务器选择
支持两种方式：
1. **预设服务器列表**：从4台预设服务器中选择
2. **手动输入**：手动输入IP地址、SSH端口、用户名、密码

#### 4.2.2 SSH连接测试
- 执行命令：`echo CONNECTION_OK`
- 判定标准：退出码为0 且 输出包含 `CONNECTION_OK`
- 失败处理：提示检查IP、端口、密码、网络连通性

#### 4.2.3 架构校验
- 执行命令：`uname -m`
- 允许的架构：`x86_64`、`amd64`、`i386`、`i686`
- 不满足时终止操作

---

### 4.3 容器选择与镜像检查
#### 4.3.1 容器类型选择
交互式选择容器类型（1-6）：
```
  [1] ujava   - Java 服务容器
  [2] uemqx   - EMQX 消息队列容器
  [3] uredis  - Redis 缓存容器
  [4] upython - Python 服务容器
  [5] unacos  - Nacos 注册中心容器
  [6] unginx  - Nginx 反向代理容器
```

#### 4.3.2 镜像文件检查
- 检查镜像文件是否存在于脚本目录
- 输出镜像文件大小
- 缺失时提示并终止

#### 4.3.3 部署脚本检查
- 检查 `container_update.sh` 是否存在
- 缺失时提示并终止

---

### 4.4 平台类型检测
#### 4.4.1 自动检测
- 检测命令：`[ -d /data/services ] && echo 'NEW_PLATFORM' || echo 'OLD_PLATFORM'`
- 检测到 `/data/services` 目录 → 新统一平台
- 未检测到 → 传统平台

#### 4.4.2 手动确认（自动检测失败时）
- 交互式询问：`目标服务器是否为新统一平台? (y/n)`

#### 4.4.3 平台限制检查
- `unacos`、`unginx` 仅支持新统一平台
- 在传统平台部署时终止操作

---

### 4.5 远端镜像版本校验
#### 4.5.1 校验逻辑
- 获取远端镜像列表：`docker images --format '{{.Repository}}:{{.Tag}}'`
- 检查是否已存在目标镜像（按容器类型匹配）
- 目标镜像映射：
  | 容器 | 目标镜像 |
  | --- | --- |
  | ujava | 139.9.60.86:5000/ujava:v6 |
  | uemqx | 139.9.60.86:5000/uemqx:v2 |
  | uredis | 139.9.60.86:5000/redis:v3 |
  | upython (新平台) | 139.9.60.86:5000/upython:v15 |
  | upython (旧平台) | 139.9.60.86:5000/upython:v14 |
  | unacos | nacos-server:v2.5.2 |
  | unginx | nginx:1.29.3 |

#### 4.5.2 处理策略
- 若检测到远端已存在目标镜像：
  - 检查是否有容器在使用该镜像
  - 交互式询问是否继续更新
- 用户选择跳过 → 终止操作

---

### 4.6 文件传输
#### 4.6.1 传输内容
1. 镜像文件（tar.gz格式）
2. 部署脚本 `container_update.sh`

#### 4.6.2 传输方式
- **Linux版本**：
  - 镜像文件/脚本传输：使用 `scp`
  - 目录同步（EMQX/Nginx）：优先使用 `rsync`，回退到 `scp`
- **Windows版本**：使用 `pscp`（PuTTY工具）

#### 4.6.3 目标目录
- 默认：`/home/containerUpdate`
- 可通过参数自定义

#### 4.6.4 本地目录配置（用于同步）
不同脚本的本地目录配置有差异：

| 脚本 | EMQX本地目录 | Nginx本地目录 |
| --- | --- | --- |
| remote_update.sh | `/data/middleware/emqx` (绝对路径) | `/data/middleware/nginx` (绝对路径) |
| remote_container_update_win.ps1 | `脚本目录/emqx` (相对路径) | `脚本目录/nginx` (相对路径) |

**说明**：
- Linux版本的本地目录是固定的绝对路径，需要在执行前确认文件存在
- Windows版本的本地目录是相对路径，相对于脚本所在目录

---

### 4.7 目录同步（按容器类型）
#### 4.7.1 EMQX容器同步
- **本地目录**：`脚本目录/emqx`
- **远端目录**：
  - 新平台：`/data/middleware/emqx`
  - 旧平台：`/var/www/emqx`
- **同步前备份**：自动备份远端目录为 `目录名_backup_时间戳`
- **权限设置**：同步后设置 `config/*.conf` 为可执行

#### 4.7.2 Nginx容器同步
- **本地目录**：`脚本目录/nginx`
- **远端目录**：`/data/middleware/nginx`（仅新平台）
- **同步前备份**：自动备份远端目录

#### 4.7.3 Python容器同步
- 当前版本：暂不执行文件同步，仅部署容器
- remote_update.sh中代码已实现但未启用（已注释）

---

### 4.8 远端容器更新
#### 4.8.1 停止旧容器
- 查找命令：`docker ps --format '{{.Names}}' | grep -E '^容器前缀([0-9]+)?$' | sort -V | tail -n1`
- 停止命令：`docker stop 容器名`

#### 4.8.2 确定新容器名称
- 提取旧容器编号（如 `ujava2` → `2`）
- 新编号 = 旧编号 + 1
- 若无旧容器，新编号 = 1

#### 4.8.3 调用远端部署脚本
```bash
cd /home/containerUpdate
sed -i 's/\r$//' container_update.sh
chmod +x container_update.sh
./container_update.sh 新容器名 镜像文件路径 [--new-platform]
```

#### 4.8.4 部署脚本功能（container_update.sh）

**运行模式**：
- **交互式模式**（无参数）：`./container_update.sh`
  - 引导选择容器类型
  - 自动检测镜像文件（支持多路径搜索）
  - 自动检测平台类型
  - 显示部署信息摘要
  - 确认后执行部署

- **命令行模式**（带参数）：`./container_update.sh <容器名> <镜像文件> [--new-platform]`
  - 适用于远程调用或自动化脚本
  - 容器名：如 ujava3
  - 镜像文件：tar包路径（绝对或相对路径）
  - --new-platform：目标为新统一平台时添加

**部署逻辑**：
- 检查镜像是否存在，不存在则加载
- 停止并移除同名旧容器
- 根据平台类型启动新容器
- 配置端口映射和目录挂载
- 等待容器启动并验证状态

**镜像文件搜索路径**（交互式模式）：
1. `脚本目录/镜像文件`
2. `当前工作目录/镜像文件`
3. `/data/temp/镜像文件`
4. `/home/containerUpdate/镜像文件`
5. 当前目录递归搜索（深度2级）

---

### 4.9 清理临时文件
部署完成后清理：
1. 远端镜像包
2. 远端部署脚本 `container_update.sh`
3. 空目录 `/home/containerUpdate`（如果为空）

---

## 5. 主流程

```
┌─────────────────────────────────────────────────────────────┐
│                      远程容器更新流程                         │
└─────────────────────────────────────────────────────────────┘

1. [启动] 选择脚本类型（Linux版本 或 Windows版本）
   │
2. [选择] 选择容器类型（ujava/uemqx/uredis/upython/unacos/unginx）
   │
3. [检查] 本地镜像文件是否存在
   │    └─ 不存在 → 终止
   │
4. [选择] 选择目标服务器（预设列表 或 手动输入）
   │
5. [校验] SSH连接测试
   │    └─ 失败 → 提示检查网络/密码 → 终止
   │
6. [校验] 目标服务器架构（x86）
   │    └─ 非x86 → 终止
   │
7. [检测] 平台类型（自动检测 /data/services）
   │    └─ 失败 → 手动确认
   │
8. [校验] 平台限制（unacos/unginx仅支持新平台）
   │    └─ 不满足 → 终止
   │
9. [校验] 远端镜像版本
   │    └─ 已存在 → 询问是否继续 → 否 → 终止
   │
10. [传输] 镜像文件 + 部署脚本 → 远端目录
   │
11. [停止] 远端旧容器
   │
12. [同步] 相关目录（EMQX/Nginx，按容器类型）
   │    └─ 同步前备份远端目录
   │
13. [部署] 调用远端部署脚本
   │    ├─ 加载镜像
   │    ├─ 启动新容器（编号递增）
   │    └─ 验证容器状态
   │
14. [清理] 远端临时文件
   │
15. [完成] 输出更新摘要
```

---

## 6. 配置与可变项

| 配置项 | 默认/当前值 | 说明 |
| --- | --- | --- |
| 预设服务器列表 | 4台服务器 | 可在脚本中修改 `ServerList`/`SERVER_IP` |
| SSH端口 | 22 | 手动输入模式可自定义 |
| 远端目录 | /home/containerUpdate | 可通过参数修改 |
| SSH超时 | 30秒 | 可在脚本中修改 `SSH_TIMEOUT` |
| 容器与镜像映射 | 见4.3.1节 | 可在脚本中修改 `ContainerImage` |

### 容器目录映射

| 容器类型 | 平台 | 远端目录 |
| --- | --- | --- |
| ujava | 新平台 | /data/services/api, /data/services/web |
| ujava | 旧平台 | /var/www/java |
| uemqx | 新平台 | /data/middleware/emqx |
| uemqx | 旧平台 | /var/www/emqx |
| uredis | 新平台 | /data/middleware/redis |
| uredis | 旧平台 | /var/www/redis |
| upython | 新平台 | /data/services/api/python-cmdb |
| upython | 旧平台 | /var/www/html |
| unacos | - | /data/middleware/nacos |
| unginx | - | /data/middleware/nginx |

---

## 7. 异常处理与容错要求

1. **SSH连接失败**
   - 输出详细错误信息
   - 提示检查IP、端口、密码、网络连通性
   - 终止操作

2. **架构不匹配**
   - 输出远端架构信息
   - 提示仅支持x86架构
   - 终止操作

3. **镜像文件缺失**
   - 提示镜像文件路径
   - 终止操作

4. **平台限制不满足**
   - 提示容器仅支持的平台类型
   - 终止操作

5. **文件传输失败**
   - 输出传输错误信息
   - 终止操作

6. **远端部署失败**
   - 输出远端脚本执行结果
   - 保留远端临时文件用于排查
   - 终止操作

7. **目录同步失败**
   - EMQX/Nginx：回退到使用远端已有配置
   - 不影响主流程继续

---

## 8. 交付物

### 8.1 脚本文件
1. **remote_update.sh** - Linux版本远程更新脚本（在本地主机执行）
2. **remote_container_update_win.ps1** - Windows版本远程更新脚本（在本地主机执行）
3. **container_update.sh** - 目标服务器部署脚本（传输到目标服务器后执行）

### 8.2 脚本用途说明
- **remote_update.sh / remote_container_update_win.ps1**：从本地主机远程更新目标服务器上的容器
  - 选择目标服务器
  - 选择要更新的容器类型
  - 传输镜像文件和部署脚本到目标服务器
  - 调用目标服务器上的部署脚本
  - 支持版本查询（`--version` / `-v`）

- **container_update.sh**：在目标服务器上实际执行容器部署
  - 支持交互式模式（无参数）和命令行模式（带参数）
  - 交互式模式：引导选择容器类型、检测平台类型、自动查找镜像文件
  - 命令行模式：`./container_update.sh <容器名> <镜像文件> [--new-platform]`

### 8.3 依赖工具
- **Linux版本**：`sshpass`（自动密码认证）
- **Windows版本**：`plink.exe`、`pscp.exe`（PuTTY工具）
- **目标服务器**：Docker

### 8.4 使用说明
1. 将镜像文件和部署脚本放在同一目录
2. 根据操作系统选择对应版本的脚本执行
3. 按交互式提示完成操作

---

## 9. 验收标准

1. **服务器连接**
   - 能成功连接预设服务器列表中的所有服务器
   - 能通过手动输入连接任意服务器

2. **容器更新**
   - 能成功更新所有6种容器类型
   - 新容器编号正确递增
   - 旧容器正确停止

3. **平台兼容**
   - 正确识别新统一平台和传统平台
   - 按平台类型使用正确的目录结构

4. **版本校验**
   - 检测到远端已安装目标镜像时提示用户
   - 用户可选择跳过或继续

5. **目录同步**
   - EMQX/Nginx目录正确同步
   - 同步前正确备份远端目录

6. **日志审计**
   - 关键操作有日志记录
   - Windows版本生成审计日志文件

7. **异常处理**
   - 各类异常情况有明确提示
   - 不会静默失败

---

## 10. 需求规范

- 代码规范：`Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结：`Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结：`Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范：`Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范：`Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`
