# _PRD_根据PRD文档生成测试用例.md

> 版本：V1.1
> 更新日期：2026-01-28
> 适用范围：自动化测试用例生成工具
> 实现脚本：`AuxiliaryTool\用例生成\create_test_xlsx.py`

---

## 1. 背景与目标

### 1.1 背景
测试用例编写是测试工作的基础，但手工从 PRD 文档中提取需求并编写测试用例耗时耗力。现有项目 PRD 文档采用 Markdown 格式编写，具备结构化的编号和描述，适合自动化解析。

### 1.2 目标
实现一套自动化测试用例生成工具，具备：
- 自动从 PRD（Markdown）文档中抽取需求条目
- 基于规则引擎生成测试用例记录（JSON + Excel）
- 支持交互式选择多个 PRD 文档
- 生成的用例符合现有测试用例模板格式

---

## 2. 总体范围

### 2.1 纳入范围
1. **PRD 文档解析**
   - 支持 Markdown 格式的 PRD 文档
   - 自动识别编号结构（如 `1.1、2.3.1`）
   - 兼容 Markdown 标题语法（`# 标题`）

2. **测试用例生成**
   - 自动生成测试用例 JSON 文件
   - 写入 Excel 测试用例模板

3. **交互式操作**
   - 列出可选 PRD 文档
   - 支持多选（如 `1,2,5` 或 `1 2 5`）
   - 自定义 Sheet 名称和输出文件名

### 2.2 不在本期范围
- PRD 文档的语法校验
- 测试用例的智能去重
- 复杂的测试数据生成
- 用例间的依赖关系处理

---

## 3. 术语说明

- **需求条目**：PRD 文档中带有编号的功能描述项
- **用例编号前缀**：测试用例 ID 的前缀（默认 `TC`）
- **功能模块**：测试用例所属的模块名称
- **Sheet 复用**：多 PRD 选中时，用例写入同一个 Sheet（追加模式）

---

## 4. 功能需求

### 4.1 PRD 目录定位
#### 4.1.1 目录兼容
脚本需兼容以下两种 PRD 目录结构：
- `Docs/开发PRD`（PRD 文档中约定的路径）
- `Docs/PRD`（仓库中实际常见的路径）

#### 4.1.2 自动检测逻辑
- 按优先级检测目录是否存在
- 若均不存在，使用第一个路径并在后续报错提示

#### 4.1.3 相关路径
| 配置项 | 路径 |
| --- | --- |
| PRD 目录 | `Docs/开发PRD` 或 `Docs/PRD` |
| 模板文件 | `AuxiliaryTool/用例生成/用例文件/兰州中石化项目测试用例20251203.xlsx` |
| JSON 输出 | `AuxiliaryTool/用例生成/config/` |
| Excel 输出 | `AuxiliaryTool/用例生成/用例文件/` |

---

### 4.2 需求条目抽取规则
#### 4.2.1 编号识别
支持以下两种格式：
1. **点分编号**：正则 `^\s*(\d+(?:\.\d+)*)\s*[、\.\-]\s*(.+?)\s*[:：]?\s*$`
   - 示例：`1.1 用户登录`、`2.3.1-异常处理`
2. **Markdown 标题**：正则 `^\s*(#{1,6})\s+(.+?)\s*$`
   - 示例：`## 用户登录`、`### 异常处理`

#### 4.2.2 内容抽取
- 标题后续行作为详情内容（直到下一个标题）
- **Markdown 标题嵌套处理**：如果当前已有标题，遇到新的 Markdown 标题时，该标题行会被作为详情内容追加，而非创建新条目
- 自动过滤：
  - 代码块（```...```）
  - HTML 注释（<!--...-->）
  - 无效标题（说明、目录、背景、概述）
- 标题过滤条件：标题长度必须 ≥ 2 个字符

#### 4.2.3 清洗规则
- 移除列表符号（`-`、`*`、`+`）
- 合并多余空格
- 保留文本核心语义

---

### 4.3 测试用例分类与优先级
#### 4.3.1 功能类别判定
| 类别 | 关键词 |
| --- | --- |
| 异常场景 | 异常、失败、错误、告警、报警、超时、断开、暴涨 |
| 安全/鉴权 | 安全、权限、鉴权、加密、脱敏 |
| 运维可观测 | 报告、输出、word、markdown、邮件、钉钉、通知 |
| 功能测试 | 其他（默认） |

#### 4.3.2 用例等级判定
| 等级 | 关键词 |
| --- | --- |
| 高 | 必须、报警、告警、峰值、暴涨、发送、对接 |
| 中 | 待实现、可以、建议、优化 |
| 中 | 其他（默认） |

#### 4.3.3 用例字段生成规则
| 字段 | 生成规则 |
| --- | --- |
| 序号 | 递增（多 PRD 时全局递增，跨 PRD 累加） |
| 用例编号 | `{前缀}-{序号:03d}`，如 `TC-001`、`TC-002` |
| 用例名称 | 需求标题 |
| 功能描述 | 需求标题 |
| 功能编号 | 抽取的编号（可能为空，适用于 Markdown 标题） |
| 预置条件 | 固定：`1. 环境已部署; 2. 具备执行权限; 3. 必要依赖/配置已准备` |
| 操作步骤 | 从详情中提取含"检查、监测、记录、输出、发送、查询、进入、生成、判定、调用、执行"的句子；最多提取 6 条，去重后以分号分隔；**在 Excel 中分号会转换为换行显示**；若无匹配内容，使用默认值：`1. 按 PRD 描述执行该功能/流程; 2. 采集相关日志/输出; 3. 记录实际结果` |
| 预期结果 | 从详情中提取含"需要、应、必须、输出、记录、发送、判定、成功、失败"的句子；最多提取 6 条，去重后以分号分隔；若无匹配内容，使用默认值：`{标题} 按 PRD 约定产出正确结果（请补充具体断言点）` |
| JSON | **Excel 中强制清空（仅 JSON 文件保留）** |
| 测试结果 | 空（待人工填写） |
| 测试结论 | 空（待人工填写） |
| 日志截屏 | 空（待人工填写） |
| 备注 | 空（待人工填写） |

---

### 4.4 交互式选择
#### 4.4.1 PRD 列表展示
- 列出 PRD 目录下所有 `.md` 文件
- 按文件名排序显示
- 格式：`序号. 文件名`

#### 4.4.2 多选输入
- 支持格式：`1,2,5` 或 `1 2 5`
- 支持逗号或空格分隔
- 自动去重
- 输入验证：序号必须在范围内

#### 4.4.3 自定义名称
1. **Sheet 名称**
   - 单 PRD 默认：`{PRD文件名}_用例`
   - 多 PRD 默认：`多PRD_用例`
   - 用户可覆盖输入
   - **名称安全处理**：
     - 自动过滤 Excel 不允许的字符：`[ ] : * ? / \` 替换为 `_`
     - 限制最大长度：**31 字符**（Excel Sheet 名称限制）

2. **输出文件名**
   - 单 PRD 默认：`{PRD文件名}`
   - 多 PRD 默认：`MultiPRD`
   - 自动添加时间戳：`{名称}_{YYYYMMDD_HHMMSS}.xlsx`

---

### 4.5 Excel 输出
#### 4.5.1 表头顺序
序号、功能模块、功能类别、用例编号、功能描述、用例等级、功能编号、用例名称、预置条件、操作步骤、JSON、预期结果、测试结果、测试结论、日志截屏、备注

#### 4.5.2 Sheet 处理
- **表头查找**：在模板的前 30 行中，查找包含至少 2 个关键字（`序号`、`用例名称`、`操作步骤`、`预期结果`）的行作为表头行；若未找到，默认使用第 3 行
- 若 Sheet 不存在：创建新 Sheet，复制模板表头行和样式（字体、填充、边框、对齐、数字格式）
- 若 Sheet 已存在：追加数据（多 PRD 场景），从当前最大行下一行开始写入
- 冻结首行：`B2`

#### 4.5.3 样式设置
- **自动换行**：预置条件、操作步骤列
- **对齐方式**：顶部对齐
- **列宽**：根据内容自适应，最大 60

#### 4.5.4 JSON 输出
- 每个 PRD 单独生成 JSON 文件
- 文件名：`{PRD文件名}_用例.json`
- 存放目录：`AuxiliaryTool/用例生成/config/`

---

## 5. 配置与可变项

### 5.1 命令行参数

脚本支持通过命令行参数覆盖默认配置：

| 参数 | 默认值 | 说明 |
| --- | --- | --- |
| `--template` | `兰州中石化项目测试用例20251203.xlsx` | 模板 Excel 文件路径 |
| `--module` | `通用模块` | 功能模块字段值（多 PRD 时统一使用该值） |
| `--prefix` | `TC` | 用例编号前缀（多 PRD 时统一使用该值） |
| `--overwrite` | `false` | 是否覆盖保存到模板文件（默认另存为新文件） |

### 5.2 可变配置项

| 配置项 | 默认值 | 说明 |
| --- | --- | --- |
| PRD 目录 | `Docs/开发PRD` 或 `Docs/PRD` | 自动检测，优先使用存在的目录 |
| 模板文件 | `兰州中石化项目测试用例20251203.xlsx` | 位于 `AuxiliaryTool/用例生成/用例文件/` |
| JSON 输出目录 | `config/` | 位于 `AuxiliaryTool/用例生成/` |
| Excel 输出目录 | `用例文件/` | 位于 `AuxiliaryTool/用例生成/` |

---

## 6. 异常处理与容错要求

1. **PRD 目录为空或不存在**：明确报错提示路径
2. **模板文件不存在**：提示文件路径并退出
3. **无效输入**：提示重试，不退出
4. **无可用需求条目**：记录日志，跳过该 PRD
5. **写入失败**：明确提示错误原因

---

## 7. 交付物

1. Python 脚本：
   - `AuxiliaryTool/用例生成/create_test_xlsx.py`
2. 配置输出：
   - `AuxiliaryTool/用例生成/config/{PRD名}_用例.json`
3. 用例输出：
   - `AuxiliaryTool/用例生成/用例文件/{名称}_{时间戳}.xlsx`

---

## 8. 验收标准

1. 能正确解析 PRD 文档中的编号结构
2. 生成的用例分类和优先级符合规则
3. Excel 输出格式与模板一致
4. 支持多 PRD 合并到同一 Sheet
5. 所有操作有明确日志输出
6. 异常情况有友好提示

---

## 9. 使用示例

### 9.1 基本使用（交互式）

```bash
# 执行脚本
python AuxiliaryTool/用例生成/create_test_xlsx.py

# 交互流程
PRD目录：C:\PycharmData\ubains-module-test\Docs\PRD
 1. _PRD_预定系统后端服务监测需求文档.md
 2. _PRD_其他需求文档.md
支持多选：输入多个序号（如 1,2,5 或 1 2 5）。

请输入PRD序号(可多选)：1
请输入Sheet名称（回车使用默认：_PRD_预定系统后端服务监测需求文档_用例）：
请输入生成的测试用例文件名称（回车使用默认：_PRD_预定系统后端服务监测需求文档）：

# 输出
已生成 JSON：AuxiliaryTool/用例生成/config/_PRD_预定系统后端服务监测需求文档_用例.json（15条）
已生成Excel：AuxiliaryTool/用例生成/用例文件/_PRD_预定系统后端服务监测需求文档_20260128_150000.xlsx
Sheet：_PRD_预定系统后端服务监测需求文档_用例
总用例条数：15
```

### 9.2 使用命令行参数

```bash
# 指定功能模块和用例前缀
python AuxiliaryTool/用例生成/create_test_xlsx.py --module "会议系统" --prefix "MT"

# 使用自定义模板文件
python AuxiliaryTool/用例生成/create_test_xlsx.py --template "自定义模板.xlsx"

# 覆盖模式（直接覆盖模板文件，不另存）
python AuxiliaryTool/用例生成/create_test_xlsx.py --overwrite

# 组合使用
python AuxiliaryTool/用例生成/create_test_xlsx.py --module "会议系统" --prefix "MT" --template "自定义模板.xlsx"
```

### 9.3 多 PRD 合并示例

```bash
# 选择多个 PRD
请输入PRD序号(可多选)：1 2 3
请输入Sheet名称（回车使用默认：多PRD_用例）：
请输入生成的测试用例文件名称（回车使用默认：MultiPRD）：

# 输出：三个 PRD 的用例合并在同一个 Sheet 中，序号全局递增
已生成 JSON：AuxiliaryTool/用例生成/config/_PRD_预定系统后端服务监测需求文档_用例.json（15条）
已生成 JSON：AuxiliaryTool/用例生成/config/_PRD_其他需求文档_用例.json（8条）
已生成 JSON：AuxiliaryTool/用例生成/config/_PRD_第三个文档_用例.json（12条）
已生成Excel：AuxiliaryTool/用例生成/用例文件/MultiPRD_20260128_150000.xlsx
Sheet：多PRD_用例
总用例条数：35
```

---

## 需求规范
    代码规范：Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md
    问题总结：Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md
    方法总结：Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md
    文档规范：Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md
    测试规范：Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md
