# _PRD_服务自检需求文档_计划执行.md

> 版本：V1.0
> 创建日期：2026-01-28
> 关联需求：`_PRD_服务自检需求文档-新.md`
> 适用范围：服务自检脚本（Windows 版 + Linux 版）开发维护

---

## 1. 文档说明

### 1.1 目的
本文档基于服务自检需求文档，制定详细的开发和维护计划，确保 Windows 版和 Linux 版脚本功能同步、质量可控。

### 1.2 范围
- Windows 版脚本：`check_server_health.ps1` (v1.0.3)
- Linux 版脚本：`check_server_health.sh` (v1.0.3)
- 功能优化同步执行
- Bug 修复同步执行

### 1.3 版本同步原则
> **核心原则：双版本同步开发，功能一致实现。**

| 操作类型 | Windows 版 | Linux 版 | 同步要求 |
|----------|-----------|----------|----------|
| 新增功能 | 必须实现 | 必须实现 | 同时开发 |
| 功能优化 | 必须同步 | 必须同步 | 同时发布 |
| Bug 修复 | 必须同步 | 必须同步 | 同时修复 |
| 配置变更 | 必须同步 | 必须同步 | 保持一致 |

---

## 2. 当前状态评估

### 2.1 版本信息

| 版本 | 当前版本 | 状态 | 说明 |
|------|----------|------|------|
| Windows 版 | 1.0.3 | ✅ 稳定 | 功能完整，已投入使用 |
| Linux 版 | 1.0.3 | ✅ 稳定 | 功能完整，已投入使用 |

### 2.2 功能对比矩阵

| 功能模块 | Windows 版 | Linux 版 | 同步状态 |
|----------|-----------|----------|----------|
| 依赖检查 | ✅ | ✅ | ✅ 一致 |
| 服务器连接 | ✅ | N/A | - (架构差异) |
| 平台检测 | ✅ | ✅ | ✅ 一致 |
| 系统类型检测 | ✅ | ✅ | ✅ 一致 |
| ujava 服务检测 | ✅ | ✅ | ✅ 一致 |
| 宿主机服务检测 | ✅ | ✅ | ✅ 一致 |
| 容器端口检测 | ✅ | ✅ | ✅ 一致 |
| DNS 检测与修复 | ✅ | ✅ | ✅ 一致 |
| 资源分析 | ✅ | ✅ | ✅ 一致 |
| 防火墙检测与修复 | ✅ | ⚠️ | ⚠️ 部分一致（Linux 版仅检测，无修复） |
| NTP 检测与修复 | ✅ | ✅ | ✅ 一致 |
| 文件权限检测 | ✅ | ✅ | ✅ 一致 |
| 容器信息收集 | ✅ | ✅ | ✅ 一致 |
| Redis 异常处理 | ✅ | ✅ | ✅ 一致 |
| Emqx 异常处理 | ✅ | ✅ | ✅ 一致 |
| 对外服务修复 | ✅ | ✅ | ✅ 一致 |
| 配置文件 IP 检测 | ✅ | ✅ | ✅ 一致 |
| 安卓设备自检 | ✅ | ✅ | ⚠️ 差异 (adb 路径) |
| 日志导出 | ✅ | ✅ | ⚠️ 差异 (导出方式) |
| 数据备份 | ✅ | ✅ | ⚠️ 差异 (下载方式) |
| 定时任务查询 | ❌ | ✅ | ⚠️ Linux 独有 |

**图例：**
- ✅ 已实现
- ❌ 未实现
- ⚠️ 有差异
- - 不适用

### 2.3 待办事项

| 优先级 | 任务 | Windows 版 | Linux 版 |
|--------|------|-----------|----------|
| 🟢 低 | 版本号已统一为 1.0.3 | 1.0.3 | 1.0.3 |
| 🟢 低 | 差异说明文档化 | 已完成 | 已完成 |

---

## 3. 开发计划

### 3.1 版本规划

#### v1.1.0 - 功能增强（规划中）

**目标：** 基于当前 v1.0.3 版本，规划和实现功能增强

| 任务ID | 任务描述 | Windows 版 | Linux 版 | 负责人 | 状态 |
|--------|----------|-----------|----------|--------|------|
| T-1101 | 定时任务查询功能移植到 Windows 版 | 待开发 | 已实现 | - | 🔲 待开始 |
| T-1102 | 增加更多中间件检测 | 待开发 | 待开发 | - | 🔲 待开始 |
| T-1103 | 支持配置文件外部化 | 待开发 | 待开发 | - | 🔲 待开始 |

#### v1.2.0 - 更多功能增强（规划中）

| 任务ID | 任务描述 | 说明 | 状态 |
|--------|----------|------|------|
| T-1201 | 增加邮件/钉钉告警 | 检测到异常时发送告警 | 🔲 计划中 |
| T-1202 | 支持配置文件外部化 | 服务列表、端口等可配置 | 🔲 计划中 |
| T-1203 | Web 界面支持 | 提供 Web 界面查看检测结果 | 🔲 计划中 |

---

### 3.2 任务分解

#### 阶段一：功能增强（v1.1.0）

**预计工作量：** 按具体功能确定

| 步骤 | 任务 | 工作内容 | 产出物 |
|------|------|----------|--------|
| 1.1 | 定时任务查询移植 | 将 Linux 版定时任务查询移植到 Windows 版 | 新增代码 |
| 1.2 | 功能对比验证 | 验证两版本功能一致性 | 测试报告 |
| 1.3 | 文档更新 | 更新需求文档和计划文档 | 更新的文档 |

#### 阶段二：质量优化（v1.1.1）

**预计工作量：** 3-5 天

| 步骤 | 任务 | 工作内容 | 产出物 |
|------|------|----------|--------|
| 2.1 | 代码规范检查 | 按代码规范检查并修复 | 规范化代码 |
| 2.2 | 错误处理增强 | 完善异常处理和容错逻辑 | 增强的错误处理 |
| 2.3 | 日志输出优化 | 统一日志格式和输出级别 | 统一的日志格式 |
| 2.4 | 性能优化 | 减少不必要的命令执行 | 优化后的脚本 |
| 2.5 | 文档完善 | 补充代码注释和使用说明 | 完善的文档 |

#### 阶段三：功能增强（v1.2.0+）

**预计工作量：** 按具体功能确定

| 步骤 | 任务 | 工作内容 | 产出物 |
|------|------|----------|--------|
| 3.1 | 需求评审 | 评审新功能需求和优先级 | 需求评审报告 |
| 3.2 | 设计评审 | 评审技术方案和实现方式 | 设计文档 |
| 3.3 | 双版本开发 | 同时开发 Windows 版和 Linux 版 | 新功能代码 |
| 3.4 | 联调测试 | 两个版本功能一致性测试 | 测试报告 |
| 3.5 | 发布上线 | 版本发布和部署 | 发布说明 |

---

## 4. 开发流程规范

### 4.1 新功能开发流程

```mermaid
graph TD
    A[需求提出] --> B[需求评审]
    B --> C[技术方案设计]
    C --> D{是否影响两个版本?}
    D -->|是| E[双版本同步开发]
    D -->|否| F[单版本开发+文档说明]
    E --> G[代码审查]
    F --> G
    G --> H[功能测试]
    H --> I[双版本一致性验证]
    I --> J[版本发布]
```

### 4.2 Bug 修复流程

```mermaid
graph TD
    A[Bug 报告] --> B[Bun 确认]
    B --> C{影响哪个版本?}
    C -->|Windows 版| D[修复 Windows 版]
    C -->|Linux 版| E[修复 Linux 版]
    C -->|两版本| F[双版本同步修复]
    D --> G[验证修复]
    E --> G
    F --> G
    G --> H[版本发布]
```

### 4.3 版本发布流程

| 阶段 | 操作 | Windows 版 | Linux 版 |
|------|------|-----------|----------|
| 1 | 版本号更新 | 修改 $SCRIPT_VERSION | 修改 SCRIPT_VERSION |
| 2 | 变更日志 | 编写 CHANGELOG | 编写 CHANGELOG |
| 3 | 代码审查 | 人工审查 | 人工审查 |
| 4 | 功能测试 | 执行测试用例 | 执行测试用例 |
| 5 | 一致性验证 | 对比两版本结果 | 对比两版本结果 |
| 6 | 文档更新 | 更新需求文档 | 更新需求文档 |
| 7 | 发布 | 打包发布 | 打包发布 |

---

## 5. 测试计划

### 5.1 测试环境

| 环境类型 | Windows 版测试环境 | Linux 版测试环境 |
|----------|-------------------|------------------|
| 开发环境 | Windows 10/11 + PowerShell 5.1+ | CentOS 7/8 或 Ubuntu 20.04+ |
| 测试服务器 | 标准版预定运维服务器 | 同左 |
| 平台覆盖 | 新统一平台 + 传统平台 | 新统一平台 + 传统平台 |

### 5.2 测试用例

| 用例ID | 测试项 | Windows 版 | Linux 版 | 预期结果 |
|--------|--------|-----------|----------|----------|
| TC-001 | 依赖检查 | ✅ | ✅ | 正确检测依赖工具 |
| TC-002 | 平台识别 | ✅ | ✅ | 正确识别新统一平台/传统平台 |
| TC-003 | 容器检测 | ✅ | ✅ | 正确检测 ujava/upython/upython_voice |
| TC-004 | 服务进程检测 | ✅ | ✅ | 正确检测容器内/宿主机服务 |
| TC-005 | 端口监听检测 | ✅ | ✅ | 正确检测端口监听状态 |
| TC-006 | DNS 检测与修复 | ✅ | ✅ | 检测异常并自动修复 |
| TC-007 | NTP 检测与修复 | ✅ | ✅ | 检测异常并自动修复 |
| TC-008 | 防火墙检测与修复 | ✅ | ⚠️ | Windows 版检测并自动修复，Linux 版仅检测 |
| TC-009 | 资源分析 | ✅ | ✅ | 正确获取 CPU/内存/磁盘信息 |
| TC-010 | Redis 异常处理 | ✅ | ✅ | 检测异常并自动修复 |
| TC-011 | 报告生成 | ✅ | ✅ | 生成完整 Markdown 报告 |
| TC-012 | 日志导出 | ✅ | ✅ | 成功导出日志文件 |
| TC-013 | 定时任务查询 | ❌ | ✅ | Linux 版显示定时任务 |

### 5.3 一致性验证

**验证方法：** 在同一服务器上，分别运行 Windows 版和 Linux 版，对比检测结果。

| 对比项 | 验证方法 | 一致性标准 |
|--------|----------|------------|
| 服务状态 | 对比服务运行状态列表 | 完全一致 |
| 端口监听 | 对比端口监听状态 | 完全一致 |
| 资源数据 | 对比 CPU/内存/磁盘使用率 | 误差 < 5% |
| 报告内容 | 对比报告章节和格式 | 结构一致，内容语义一致 |

---

## 6. 变更管理

### 6.1 变更类型

| 变更类型 | 版本号变化 | 示例 |
|----------|-----------|------|
| Bug 修复 | Patch 版本 (x.x.z+1) | 1.0.3 → 1.0.4 |
| 功能新增 | Minor 版本 (x.y+1.0) | 1.0.4 → 1.1.0 |
| 破坏性变更 | Major 版本 (x+1.0.0) | 1.1.0 → 2.0.0 |

### 6.2 变更流程

1. **变更申请**
   - 填写变更申请表
   - 说明变更原因和影响范围

2. **影响评估**
   - 评估对 Windows 版和 Linux 版的影响
   - 确定是否需要双版本同步

3. **变更审批**
   - 技术负责人审批
   - 确认变更方案

4. **变更实施**
   - 按开发流程实施变更
   - 确保双版本同步

5. **变更验证**
   - 执行测试用例
   - 验证一致性

6. **变更发布**
   - 更新版本号
   - 编写发布说明

### 6.3 变更记录

| 版本 | 日期 | 变更类型 | 变更内容 | 影响范围 |
|------|------|----------|----------|----------|
| 1.0.3 | 2026-01-28 | Patch | 双版本版本号统一，功能完善 | 两版本 |
| 1.0.3 | 2026-01-XX | Patch | Windows 版功能完善 | Windows 版 |
| 1.0.0 | 2026-01-XX | Major | 初始版本 | 两版本 |

---

## 7. 风险管理

### 7.1 技术风险

| 风险 | 影响 | 概率 | 应对措施 |
|------|------|------|----------|
| 双版本功能不一致 | 高 | 中 | 严格的版本同步流程，一致性验证 |
| SSH 连接不稳定 | 中 | 中 | 增加重试机制，详细错误提示 |
| 修复脚本调用失败 | 高 | 低 | 充分测试修复脚本，添加异常处理 |
| 平台识别错误 | 高 | 低 | 多条件验证，增加日志输出 |

### 7.2 流程风险

| 风险 | 影响 | 概率 | 应对措施 |
|------|------|------|----------|
| 版本发布不同步 | 高 | 中 | 建立版本检查清单，发布前确认 |
| 测试覆盖不足 | 高 | 中 | 完善测试用例，自动化测试 |
| 文档更新滞后 | 中 | 高 | 文档与代码同步更新 |

---

## 8. 质量保证

### 8.1 代码质量标准

| 指标 | 标准 | 检查方式 |
|------|------|----------|
| 代码规范 | 符合项目代码规范 | 人工审查 |
| 注释覆盖率 | 核心函数必须有注释 | 人工审查 |
| 错误处理 | 所有可能的异常都有处理 | 代码审查+测试 |
| 日志完整性 | 关键步骤都有日志输出 | 测试验证 |

### 8.2 测试质量标准

| 指标 | 标准 | 检查方式 |
|------|------|----------|
| 测试用例覆盖率 | 核心功能 100% | 测试用例清单 |
| 用例执行通过率 | 100% | 测试报告 |
| 双版本一致性 | 核心检测结果一致 | 一致性验证报告 |

### 8.3 文档质量标准

| 文档 | 更新频率 | 责任人 |
|------|----------|--------|
| 需求文档 | 每次版本更新 | 技术负责人 |
| 计划文档 | 每季度或重大变更 | 项目经理 |
| 代码注释 | 随代码更新 | 开发人员 |
| 用户手册 | 每次版本更新 | 技术负责人 |

---

## 9. 沟通协作

### 9.1 角色职责

| 角色 | 职责 | Windows 版 | Linux 版 |
|------|------|-----------|----------|
| 技术负责人 | 架构设计、技术决策 | 负责 | 负责 |
| Windows 版开发者 | PowerShell 脚本开发 | 主要 | 辅助 |
| Linux 版开发者 | Bash 脚本开发 | 辅助 | 主要 |
| 测试工程师 | 功能测试、一致性验证 | 测试 | 测试 |
| 运维工程师 | 部署、监控、问题反馈 | 使用 | 使用 |

### 9.2 沟通机制

| 会议类型 | 频率 | 参与人员 | 议题 |
|----------|------|----------|------|
| 需求评审会 | 按需 | 全体 | 新功能需求讨论 |
| 技术方案评审会 | 按需 | 技术人员 | 实现方案讨论 |
| 版本发布会 | 每次发布 | 全体 | 版本内容、注意事项 |
| 双周例会 | 双周 | 全体 | 进展同步、问题讨论 |

### 9.3 协作工具

| 工具类型 | 推荐工具 | 用途 |
|----------|----------|------|
| 代码管理 | Git | 版本控制、分支管理 |
| 问题跟踪 | GitHub Issues / Jira | Bug 跟踪、需求管理 |
| 文档协作 | Markdown + Git | 文档版本控制 |
| 即时沟通 | 企业微信 / 钉钉 | 日常沟通 |

---

## 10. 里程碑

| 里程碑 | 目标 | 预计时间 | 状态 |
|--------|------|----------|------|
| M1 | 需求文档完成 | 2026-01-28 | ✅ 已完成 |
| M2 | 计划文档完成 | 2026-01-28 | ✅ 已完成 |
| M3 | 双版本 v1.0.3 统一 | 2026-01-28 | ✅ 已完成 |
| M4 | v1.1.0 功能增强完成 | 待定 | 🔲 计划中 |
| M5 | v1.2.0 更多功能增强完成 | 待定 | 🔲 计划中 |

---

## 11. 附录

### 11.1 文件路径

**脚本文件：**
- Windows 版：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.ps1`
- Linux 版：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.sh`

**文档文件：**
- 需求文档：`Docs\PRD\服务自检\_PRD_服务自检需求文档-新.md`
- 计划文档：`Docs\PRD\服务自检\_PRD_服务自检需求文档_计划执行.md`

**输出文件：**
- Windows 版日志：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\logs\health_check_{时间戳}.log`
- Linux 版日志：`AuxiliaryTool\ScriptTool\ServiceSelfInspection/logs/health_check_{时间戳}.log`
- Windows 版报告：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\Reports\health_report_{IP}_{时间戳}.md`
- Linux 版报告：`AuxiliaryTool\ScriptTool\ServiceSelfInspection/Reports/health_report_{IP}_{时间戳}.md`

### 11.2 相关文档

- 代码规范：`Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结：`Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结：`Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范：`Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范：`Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`

### 11.3 快速参考

**Windows 版运行：**
```powershell
cd C:\PycharmData\ubains-module-test\AuxiliaryTool\ScriptTool\ServiceSelfInspection
.\check_server_health.ps1
```

**Linux 版运行：**
```bash
cd /path/to/AuxiliaryTool/ScriptTool/ServiceSelfInspection
chmod +x check_server_health.sh
./check_server_health.sh
```

### 11.4 联系方式

如有问题或建议，请联系：
- 技术负责人：[待填写]
- 项目经理：[待填写]

---

**文档版本历史：**

| 版本 | 日期 | 变更内容 | 作者 |
|------|------|----------|------|
| V1.1 | 2026-01-28 | 更新双版本版本号为 1.0.3 | Claude |
| V1.0 | 2026-01-28 | 初始版本 | Claude |
