# _PRD_服务自检需求文档-新.md

> 版本：V1.1
> 更新日期：2026-01-28
> 适用范围：服务自检脚本（Windows 远程版本 + Linux 本机版本）
> 实现脚本：
> - Windows 版：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.ps1`
> - Linux 版：`AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.sh`

---

## 1. 背景与目标

### 1.1 背景
会议预定系统和统一平台部署在 Linux 服务器上，核心服务运行在 Docker 容器中（ujava/upython/upython_voice）。为降低运维成本，需要实现服务健康检查工具，并自动修复常见问题。

### 1.2 目标
实现两套功能一致的服务自检脚本，具备：
- 自动识别平台类型（新统一平台/传统平台）
- 检测容器内服务进程和端口监听状态
- DNS/NTP/防火墙等系统级检测与自动修复
- 生成详细的健康检查报告（Markdown 格式）

### 1.3 双版本说明

| 版本 | 文件名 | 运行环境 | 版本号 | 说明 |
|------|--------|----------|--------|------|
| Windows 版 | check_server_health.ps1 | Windows 10+ | 1.0.3 | 通过 SSH 远程连接 Linux 服务器进行检测 |
| Linux 版 | check_server_health.sh | Linux 服务器 | 1.0.3 | 直接在服务器本机运行，无需 SSH 连接 |

**重要说明：**
- 两版本核心功能保持一致，后续功能优化需**同步更新**两个脚本
- 差异部分见下节"版本差异说明"

---

## 1.4 版本差异说明

### 1.4.1 运行环境差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 运行位置 | Windows 端 | Linux 服务器本机 |
| 服务器连接 | 需要远程 SSH 连接 | 无需连接，直接执行本地命令 |
| 服务器选择 | 支持预设列表/手动输入 | 自动检测本机 IP |

### 1.4.2 依赖检查差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 运行环境要求 | PowerShell 5.1+ | Bash 4.0+ |
| SSH 工具要求 | plink.exe / pscp.exe 或 sshpass | 无需 SSH 工具 |
| plink 查找优先级 | 脚本同目录 > 远程容器更新目录 > 系统 PATH | - |
| adb 工具路径 | 系统 PATH 中的 adb | 脚本同目录 `linux_x86_adb/adb` |

### 1.4.3 命令执行方式差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 命令执行 | 通过 SSH 远程执行 | 直接执行本地命令 |
| 日志输出 | 自定义 Write-Log 函数 | exec + tee 实现实时打印和日志 |
| 日志输出目标 | 控制台 + 日志文件 | 控制台 + 日志文件（同步） |

### 1.4.4 修复脚本调用差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 调用方式 | 通过 SSH 上传并执行远程脚本 | 直接调用同目录的 `issue_handler.sh` |
| 函数名 | `Upload_the_repair_script` | `run_issue_handler` |
| 参数格式 | `--action {action} --platform {platform}` | `--action {action} --platform {platform} --non-interactive --yes` |

### 1.4.5 日志导出差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 导出方式 | pscp.exe 远程下载 | cp 本地复制 |
| 目标目录 | Windows 端 `output/{IP}/logs/` | 服务器端 `output/{IP}/logs/` |

### 1.4.6 安卓设备自检差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| adb 工具 | 使用 Windows 端 adb | 使用脚本同目录 `linux_x86_adb/adb` |
| 连接方式 | 从 Windows 端连接 | 从服务器端连接 |
| 日志保存 | Windows 端目录 | 服务器端目录 |

### 1.4.7 数据备份差异

| 差异项 | Windows 版 (.ps1) | Linux 版 (.sh) |
|--------|-------------------|----------------|
| 备份位置 | 远程服务器 | 本机 |
| 下载方式 | 通过 SSH 下载到本地 | 本地复制，无需下载 |

### 1.4.8 新增功能（Linux 版独有）

| 功能 | 说明 |
|------|------|
| 定时任务查询 | 检测系统定时任务（crontab）配置 |

---

## 2. 总体范围

### 2.1 纳入检测对象

#### 2.1.1 平台类型
1. **新统一平台**
   - 检测标志：存在 `/data/services` 目录
2. **传统平台**
   - 检测标志：不存在 `/data/services` 目录

#### 2.1.2 容器类型
| 容器名 | 说明 | 检测方式 |
|--------|------|----------|
| ujava* | Java 服务容器 | docker ps 匹配 `^ujava\d*$` |
| upython* | 运维集控系统 | docker ps 匹配 `^upython\d*$`（非 voice） |
| upython_voice* | 转录系统 | docker ps 匹配 `^upython_voice\d*$` |

#### 2.1.3 新统一平台 - ujava 容器内服务
| 服务key | jar文件名 | 说明 |
|---------|-----------|------|
| auth | ubains-auth.jar | 认证服务 |
| gateway | ubains-gateway.jar | 网关服务 |
| system | ubains-modules-system.jar | 系统服务 |
| meeting2.0 | ubains-meeting-inner-api-1.0-SNAPSHOT.jar | 对内2.0服务 |
| meeting3.0 | ubains-meeting-inner-api-1.0-SNAPSHOT.jar | 对内3.0服务 |
| mqtt | ubains-meeting-mqtt-1.0-SNAPSHOT.jar | MQTT服务 |
| quartz | ubains-meeting-quartz-1.0-SNAPSHOT.jar | 定时任务服务 |
| message | ubains-meeting-message-scheduling-1.0-SNAPSHOT.jar | 信息调度服务 |

#### 2.1.4 新统一平台 - ujava 宿主机服务
| 服务key | jar文件名 | 路径 |
|---------|-----------|------|
| extapi | ubains-meeting-api-1.0-SNAPSHOT.jar | /data/services/api/java-meeting/java-meeting-extapi/ |

#### 2.1.5 传统平台 - ujava 容器内服务
| 服务key | 检测模式 | 说明 |
|---------|----------|------|
| nginx | nginx: master process | Nginx 主进程 |
| meeting | ubains-meeting-inner-api-1.0-SNAPSHOT.jar | 对内后端服务 |

#### 2.1.6 传统平台 - ujava 宿主机服务
| 服务key | jar文件名 | 路径 |
|---------|-----------|------|
| extapi | ubains-meeting-api-1.0-SNAPSHOT.jar | /var/www/java/external-meeting-api/ |

#### 2.1.7 容器端口检测

**upython 容器（运维集控系统）:**
| 端口 | 进程名 | 描述 |
|------|--------|------|
| 11211 | memcached | Memcached 缓存服务 |
| 8000 | uwsgi | uWSGI 应用服务 |

**upython_voice 容器（转录系统）:**
| 端口 | 进程名 | 描述 |
|------|--------|------|
| 1883 | mosquitto | MQTT Broker 服务 |
| 8000 | uwsgi | uWSGI 应用服务 |
| 9001 | mosquitto | MQTT WebSocket 服务 |
| 11211 | memcached | Memcached 缓存服务 |
| 8080 | nginx | Nginx 代理服务 (8080) |
| 80 | nginx | Nginx Web 服务 (80) |

**传统平台 upython 容器:**
| 端口 | 进程名 | 描述 |
|------|--------|------|
| 8081 | nginx | Nginx 代理服务 (8081) |
| 8443 | nginx | Nginx HTTPS 服务 (8443) |
| 8000 | uwsgi | uWSGI 应用服务 |
| 8002 | httpd | Apache HTTPD 服务 |
| 11211 | memcached | Memcached 缓冲服务 |

### 2.2 不在本期范围（可扩展）
- 实时监控告警（钉钉/邮件/短信）
- 服务性能指标监控（响应时间、吞吐量）
- 自动扩缩容策略
- 多服务器批量检测

---

## 3. 术语说明

| 术语 | 说明 |
|------|------|
| 服务 key | 脚本内部用于标识服务的字符串，如 `auth`、`gateway` |
| jar标识 | 用于 ps 命令匹配进程的 jar 文件名 |
| 平台类型 | `new`（新统一平台）或 `old`（传统平台） |
| 系统类型 | 容器名称，如 `ujava2`、`upython`、`upython_voice` |
| 时间戳 | 格式 `yyyy-MM-dd HH:mm:ss` 或 `yyyyMMdd_HHmmss` |
| 双版本同步 | Windows 版和 Linux 版功能保持一致，优化时需同步更新 |

---

## 4. 功能需求

### 4.1 依赖检查

#### 4.1.1 Windows 版依赖

**检查项:**
- PowerShell 版本 >= 5.1
- SSH 密码认证工具：plink.exe 或 sshpass

**plink.exe 查找优先级:**
1. 脚本同目录下
2. 上级目录的 `远程容器更新\plink.exe`
3. 系统 PATH 中

**下载地址:**
- plink.exe: https://the.earth.li/~sgtatham/putty/latest/w64/plink.exe

**处理策略:**
- 未检测到依赖工具时，提示用户下载并放置到指定位置
- 输出详细的错误信息和下载链接

#### 4.1.2 Linux 版依赖

**检查项:**
- Bash 4.0+
- Docker 命令
- 常用系统命令：docker, ps, grep, awk, sed, netstat/ss, free, df, 等

**处理策略:**
- 脚本通过 `command_exists` 函数检查命令可用性
- 缺少命令时跳过相关检测或使用替代方案

---

### 4.2 服务器连接

#### 4.2.1 Windows 版 - 预设服务器列表
| 编号 | IP地址 | 用户名 | 密码 | 描述 |
|------|--------|--------|------|------|
| 1 | 192.168.5.48 | root | Ubains@123 | 标准版预定运维服务器 |
| 2 | 192.168.5.67 | root | Ubains@123 | 阿曼项目预定服务器 |
| 3 | 192.168.5.47 | root | Ubains@1234 | 标准版预定运维测试发布服务器 |
| 4 | 192.168.5.44 | root | Ubains@123 | 新统一平台测试服务器 |

#### 4.2.2 Windows 版 - 手动输入模式
- 支持 IP 地址、SSH 端口（默认 22）、用户名（默认 root）、密码输入

#### 4.2.3 Windows 版 - 连接测试
- 执行 `echo CONNECTION_OK` 验证 SSH 连接
- 处理首次连接主机密钥确认问题

#### 4.2.4 Linux 版 - 自动检测
- 自动检测本机 IP 地址
- 无需用户选择服务器

---

### 4.3 平台自动检测

#### 4.3.1 检测逻辑
```bash
[ -d /data/services ] && echo 'NEW_PLATFORM' || echo 'OLD_PLATFORM'
```

#### 4.3.2 平台类型
| 类型 | 判定条件 | 说明 |
|------|----------|------|
| new | 存在 /data/services 目录 | 新统一平台 |
| old | 不存在 /data/services 目录 | 传统平台 |

**版本差异:**
- Windows 版：通过 SSH 远程执行检测命令
- Linux 版：直接执行本地检测命令

---

### 4.4 系统类型检测

#### 4.4.1 容器检测命令
```bash
docker ps --format '{{.Names}}'
```

#### 4.4.2 容器匹配规则
| 容器类型 | 匹配模式 | 变量存储 |
|----------|----------|----------|
| ujava | `^ujava\d*$` | UjavaContainer |
| upython | `^upython\d*$`（非 voice） | UpythonContainer |
| upython_voice | `^upython_voice\d*$` | UpythonVoiceContainer |

#### 4.4.3 ujava 系统细分（传统平台）
```bash
[ -d /var/www/java/unifiedPlatform ] && echo 'UNIFIED' || echo 'MEETING'
```
- `unified`: 统一平台系统（会议预定系统变体）
- `meeting`: 会议预定系统

**版本差异:**
- Windows 版：通过 `Invoke-SSHCommand` 执行
- Linux 版：直接执行本地命令

---

### 4.5 服务检测

#### 4.5.1 ujava 容器内服务检测

**检测命令（容器内）:**
```bash
docker exec {container} ps aux | grep -v grep | grep '{jar文件名}' | wc -l
```

**特殊处理（meeting2.0/meeting3.0）:**
- meeting2.0: 需同时匹配路径中包含 `java-meeting2.0`
- meeting3.0: 需同时匹配路径中包含 `java-meeting3.0`

**判定逻辑:**
- 进程数 > 0: 运行中
- 进程数 = 0: 未运行

**回退机制:**
- 容器内检测失败时，自动尝试在宿主机检测

**版本差异:**
- Windows 版：通过 SSH 执行 `docker exec` 命令
- Linux 版：直接执行 `docker exec` 命令

#### 4.5.2 ujava 宿主机服务检测

**检测命令（宿主机）:**
```bash
ps aux | grep -v grep | grep '{jar文件名}' | wc -l
```

**新统一平台路径:**
- extapi: /data/services/api/java-meeting/java-meeting-extapi/

**传统平台路径:**
- extapi: /var/www/java/external-meeting-api/

**版本差异:**
- Windows 版：通过 SSH 执行命令
- Linux 版：直接执行本地命令

#### 4.5.3 传统平台 ujava 容器内服务检测

**检测命令:**
```bash
docker exec {container} ps aux | grep -v grep | grep '{pattern}' | wc -l
```

#### 4.5.4 容器端口检测

**检测命令:**
```bash
docker exec {container} netstat -tlnp | grep ':{端口}'
# 或
docker exec {container} ss -tlnp | grep ':{端口}'
```

**判定逻辑:**
- 端口在监听: 正常
- 端口未监听: 异常

**版本差异:**
- Windows 版：通过 SSH 执行命令，支持 netstat/ss/lsof
- Linux 版：直接执行本地命令，支持 netstat/ss

---

### 4.6 DNS 解析检测

#### 4.6.1 DNS 配置检查
**检查文件:** `/etc/resolv.conf`

**检查命令:**
```bash
cat /etc/resolv.conf | grep -E '^nameserver' | head -n 3
```

**输出信息:**
- DNS 服务器列表

#### 4.6.2 DNS 解析测试
**测试域名:**
- www.baidu.com
- www.qq.com
- www.aliyun.com

**测试命令:**
```bash
nslookup {domain}
# 或
host {domain}
```

#### 4.6.3 网络连通性测试（Windows 版）
**测试命令:**
```bash
ping -c 2 -W 2 {domain}
```

#### 4.6.4 自动修复
**触发条件:**
- DNS 配置异常（未找到 nameserver）
- DNS 解析失败（所有域名解析失败）

**修复方式:**
- Windows 版：调用远程修复脚本 `fix_dns_config`
- Linux 版：直接调用同目录 `issue_handler.sh --action fix_dns_config`
- 修复后复检 DNS 解析功能

**版本差异:**
| 差异项 | Windows 版 | Linux 版 |
|--------|-----------|----------|
| 修复调用 | `Upload_the_repair_script` | `run_issue_handler` |
| 执行位置 | 远程服务器 | 本机 |
| 参数 | `--action fix_dns_config --platform auto` | `--action fix_dns_config --platform auto --non-interactive --yes` |

---

### 4.7 服务器资源分析

#### 4.7.1 操作系统信息
**检测命令:**
```bash
cat /etc/os-release | grep -E '^(NAME|VERSION)='
```

#### 4.7.2 系统架构
**检测命令:**
```bash
uname -m && uname -r
```

#### 4.7.3 CPU 使用情况
**检测命令:**
```bash
top -bn1 | grep 'Cpu(s)' | awk '{print $2+$4}'
nproc
```

**状态判定:**
- < 70%: 正常
- 70-90%: 警告
- > 90%: 危险

#### 4.7.4 内存使用情况
**检测命令:**
```bash
free -m | awk -F"[[:space:]]+" '$1 == "Mem:" { ... }'
```

**状态判定:**
- < 70%: 正常
- 70-90%: 警告
- > 90%: 危险

#### 4.7.5 磁盘使用情况
**检测命令:**
```bash
df -h | grep -E '^/dev/'
```

**状态判定:**
- < 70%: 正常
- 70-90%: 警告
- > 90%: 危险

#### 4.7.6 防火墙状态
**检测命令:**
```bash
systemctl is-active firewalld
# 或
service iptables status
```

**开放端口查询:**
```bash
firewall-cmd --list-ports
firewall-cmd --list-services
# 或
iptables -L INPUT -n
```

#### 4.7.7 防火墙自动修复
**触发条件:**
- 防火墙未启用或状态异常

**修复方式:**
- Windows 版：调用远程修复脚本 `fix_port_access`
- Linux 版：⚠️ **暂未实现自动修复功能**，仅检测状态

**修复后复检:**
- Windows 版：修复后复检防火墙状态
- Linux 版：不适用

#### 4.7.8 系统负载
**检测命令:**
```bash
uptime | awk -F'load average:' '{print $2}'
```

**版本差异:**
- Windows 版：通过 SSH 执行所有命令
- Linux 版：直接执行本地命令

---

### 4.8 NTP 服务检测

#### 4.8.1 服务状态检测
**检测命令:**
```bash
systemctl is-active chronyd
```

#### 4.8.2 时区配置检查
**检测命令:**
```bash
timedatectl | grep 'Time zone'
```

#### 4.8.3 时间偏差检测
**检测命令:**
```bash
chronyc tracking | grep 'Last offset'
```

#### 4.8.4 自动修复
**触发条件:**
- chronyd 服务未运行
- 时区配置异常
- 时间偏差超过阈值

**修复方式:**
- Windows 版：调用远程修复脚本 `fix_ntp_config --platform auto --ntp-auto`
- Linux 版：调用本地修复脚本 `fix_ntp_config --ntp-auto`
- 修复后复检时间同步状态

**版本差异:**
| 差异项 | Windows 版 | Linux 版 |
|--------|-----------|----------|
| 修复调用 | `Upload_the_repair_script` | `run_issue_handler` |
| 执行位置 | 远程服务器 | 本机 |
| 额外参数 | `--platform auto --ntp-auto` | `--ntp-auto` |

---

### 4.9 文件权限检测

#### 4.9.1 检测文件
根据平台类型和系统类型，检测关键脚本和配置文件权限：
- run.sh 启动脚本
- 配置文件
- 日志文件

#### 4.9.2 权限要求
- 脚本文件: 可执行 (755 或 775)
- 配置文件: 可读 (644 或 664)
- 日志文件: 可写 (644 或 664)

**版本差异:**
- Windows 版：通过 SSH 执行检测
- Linux 版：直接执行本地检测

---

### 4.10 容器信息收集

#### 4.10.1 容器列表
**检测命令:**
```bash
docker ps -a --format '{{.ID}} {{.Names}} {{.Status}}'
```

#### 4.10.2 容器详细信息
| 信息项 | 命令 |
|--------|------|
| 镜像 | `docker inspect -f '{{.Config.Image}}' {name}` |
| 状态 | `docker inspect -f '{{.State.Status}}' {name}` |
| 健康检查 | `docker inspect -f '{{if .State.Health}}{{.State.Health.Status}}{{end}}' {name}` |
| 重启策略 | `docker inspect -f '{{.HostConfig.RestartPolicy.Name}}' {name}` |
| 重启次数 | `docker inspect -f '{{.RestartCount}}' {name}` |
| IP地址 | `docker inspect -f '{{range $k,$v := .NetworkSettings.Networks}}{{$v.IPAddress}}{{end}}' {name}` |
| 端口 | `docker port {name}` |
| 网络 | `docker inspect -f '{{range $k,$v := .NetworkSettings.Networks}}{{$k}}:{{$v.IPAddress}}{{end}}' {name}` |
| 挂载 | `docker inspect -f '{{range .Mounts}}{{.Source}}:{{.Destination}}({{.Mode}});{{end}}' {name}` |
| 大小 | `docker ps -a --size --filter "name=^/{name}$" --format "{{.Size}}"` |

**版本差异:**
- Windows 版：通过 SSH 执行命令
- Linux 版：直接执行本地命令

---

### 4.11 Redis/Emqx 容器异常处理

#### 4.11.1 Redis 容器检测
**检测目标:** uredis 容器

**异常判定:**
- uredis 未运行
- 且无其他 redis 容器运行中

**日志路径:**
- 新统一平台: `/data/middleware/redis/data/redis.log`
- 传统平台: `/var/www/redis/data/redis.log`

**自动修复:**
- Windows 版：调用远程修复脚本 `redis_container_exception`
- Linux 版：调用 `issue_handler.sh --action redis_container_exception`
- 修复后复检容器状态

#### 4.11.2 Emqx 容器检测
**检测目标:** uemqx 容器

**异常判定:**
- uemqx 未运行
- 且无其他 emqx 容器运行中

**日志路径:**
- 新统一平台: `/data/middleware/emqx/log/emqx.log.1`
- 传统平台: `/var/www/emqx/log/emqx.log.1`

**说明:** Emqx 容器异常暂不自动修复，仅记录状态

**版本差异:**
- Windows 版：日志导出到 Windows 端，修复通过远程脚本
- Linux 版：日志保留在服务器端，修复通过本地脚本

---

### 4.12 对外服务异常处理

#### 4.12.1 检测目标
ubains-meeting-api-1.0-SNAPSHOT.jar 进程

#### 4.12.2 异常判定
- 宿主机未检测到 extapi 进程

#### 4.12.3 自动修复
- Windows 版：调用远程修复脚本 `fix_external_service_disconnect`
- Linux 版：调用 `issue_handler.sh --action fix_external_service_disconnect`
- 修复后复检进程状态

---

### 4.13 配置文件 IP 检测

#### 4.13.1 新统一平台
**检测路径:**
- `/data/services/api/auth/`
- `/data/services/api/java-meeting/`
- `/data/middleware/`

**检测方式:**
- grep 搜索 IP 地址模式
- 输出匹配的文件和行号

#### 4.13.2 传统平台
**检测路径（会议预定系统）:**
- `/var/www/java/api-java-meeting2.0/`
- `/var/www/html/`

**检测路径（统一平台系统）:**
- `/var/www/java/unifiedPlatform/`

**检测方式:**
- grep 搜索 IP 地址模式
- 输出匹配的文件和行号

**版本差异:**
- Windows 版：通过 SSH 执行 grep 命令
- Linux 版：直接执行本地 grep 命令

---

### 4.14 安卓设备自检

#### 4.14.1 Windows 版

**adb 工具检测:**
```powershell
adb version
```

**设备连接测试:**
```powershell
adb devices
```

**日志拉取:**
1. 用户输入设备 IP
2. 执行 adb connect
3. 拉取日志文件到 Windows 端本地
4. 执行 adb disconnect

#### 4.14.2 Linux 版

**adb 工具路径:**
- 优先使用脚本同目录 `linux_x86_adb/adb`
- 备选系统 PATH 中的 adb

**设备连接测试:**
```bash
./linux_x86_adb/adb devices
```

**日志拉取:**
1. 用户输入设备 IP
2. 执行 adb connect
3. 拉取日志文件到服务器端本地
4. 执行 adb disconnect

---

### 4.15 定时任务查询（Linux 版独有）

#### 4.15.1 检测内容
- root 用户的 crontab 定时任务
- 系统级定时任务（/etc/cron.d/）

#### 4.15.2 检测命令
```bash
crontab -l 2>/dev/null
ls -la /etc/cron.d/ 2>/dev/null
```

#### 4.15.3 输出内容
- 定时任务列表
- 任务执行时间
- 任务执行命令

---

### 4.16 服务日志导出

#### 4.16.1 新统一平台日志
| 日志名 | 远程路径 |
|--------|----------|
| auth_log.out | /data/services/api/auth/auth-sso-auth/log.out |
| gatway_log.out | /data/services/api/auth/auth-sso-gatway/log.out |
| system_log.out | /data/services/api/auth/auth-sso-system/log.out |
| 对内2.0_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |
| 对内3.0_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-meeting3.0/logs/ubains-INFO-AND-ERROR.log |
| 对外服务_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-meeting-extapi/logs/ubains-INFO-AND-ERROR.log |
| 信息调度_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-message-scheduling/logs/ubains-INFO-AND-ERROR.log |
| MQTT_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-mqtt/logs/ubains-INFO-AND-ERROR.log |
| 定时任务_ubains-INFO-AND-ERROR.log | /data/services/api/java-meeting/java-quartz/logs/ubains-INFO-AND-ERROR.log |

#### 4.16.2 传统平台 ujava 日志
| 日志名 | 远程路径 |
|--------|----------|
| 对内后端_ubains-INFO-AND-ERROR.log | /var/www/java/api-java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |
| 对外后端_ubains-INFO-AND-ERROR.log | /var/www/java/external-meeting-api/logs/ubains-INFO-AND-ERROR.log |

#### 4.16.3 传统平台 upython 日志
| 日志名 | 远程路径 |
|--------|----------|
| 运维集控_error.log | /var/www/html/log/error.log |
| 运维集控_uinfo.log | /var/www/html/log/uinfo.log |
| 运维集控_uwsgi.log | /var/www/html/log/uwsgi.log |

#### 4.16.4 导出方式

**Windows 版:**
- 使用 pscp.exe 远程下载
- 目标目录：Windows 端 `output/{IP}/logs/`

**Linux 版:**
- 使用 cp 本地复制
- 目标目录：服务器端 `output/{IP}/logs/`

---

### 4.17 数据备份（可选）

#### 4.17.1 备份内容
- 数据库备份（mysqldump）
- 配置文件备份
- 日志文件备份

#### 4.17.2 备份流程

**Windows 版:**
1. 通过 SSH 在远程服务器执行备份
2. 打包备份文件
3. 通过 SSH 下载到 Windows 端本地

**Linux 版:**
1. 在本机执行备份
2. 打包备份文件
3. 保留在服务器端

---

### 4.18 报告生成

#### 4.18.1 报告格式
Markdown 格式

#### 4.18.2 报告路径

**Windows 版:**
`{脚本目录}\Reports\health_report_{服务器IP}_{时间戳}.md`

**Linux 版:**
`{脚本目录}/Reports/health_report_{服务器IP}_{时间戳}.md`

#### 4.18.3 报告内容
| 章节 | 内容 |
|------|------|
| 标题 | 服务器地址、描述、平台类型、检测时间 |
| 系统类型识别 | 检测到的容器类型 |
| ujava 容器内服务状态 | 各服务运行状态 |
| ujava 宿主机服务状态 | extapi 服务状态 |
| upython 容器服务状态 | 端口监听状态 |
| upython_voice 容器服务状态 | 端口监听状态 |
| DNS 解析检测结果 | 配置、解析、连通性状态 |
| 服务器资源分析 | OS、架构、CPU、内存、磁盘、防火墙、负载 |
| NTP 服务检测 | 服务状态、时区、时间偏差 |
| 文件权限检测 | 权限检查结果 |
| 容器信息 | 容器列表和详细信息 |
| 安卓设备自检 | adb 连接和日志拉取结果 |
| 定时任务 | crontab 定时任务列表（Linux 版） |
| 检测总结 | 总服务数、正常数、异常数、结论 |
| 服务日志导出 | 导出状态和文件列表 |

**版本差异:**
- Linux 版报告额外包含定时任务信息

---

## 5. 主流程

### 5.1 Windows 版主流程

```
1. 依赖检查（plink.exe/pscp.exe）
2. 选择服务器（预设列表/手动输入）
3. 测试 SSH 连接
4. 检测平台类型（new/old）
5. 检测系统类型（容器）
6. 服务检测
   ├── 新统一平台: ujava容器内服务 + ujava宿主机服务 + upython + upython_voice
   └── 传统平台: ujava容器内服务 + ujava宿主机服务 + upython
7. DNS 解析检测（含自动修复）
8. 服务器资源分析（含防火墙自动修复）
9. 容器信息收集（含 Redis/Emqx 异常处理）
10. 配置文件 IP 检测
11. NTP 服务检测（含自动修复）
12. 文件权限检测
13. 可选: 数据备份（远程执行+下载）
14. 可选: 服务日志导出（远程下载）
15. 安卓设备自检
16. 生成健康检查报告
```

### 5.2 Linux 版主流程

```
1. 初始化日志（exec + tee）
2. 检测平台类型（new/old）
3. 检测系统类型（容器）
4. 服务检测
   ├── 新统一平台: ujava容器内服务 + ujava宿主机服务 + upython + upython_voice
   └── 传统平台: ujava容器内服务 + ujava宿主机服务 + upython
5. DNS 解析检测（含自动修复）
6. 服务器资源分析（含防火墙自动修复）
7. 配置文件 IP 检测
8. NTP 服务检测（含自动修复）
9. 文件权限检测
10. 可选: 数据备份（本地执行）
11. 可选: 服务日志导出（本地复制）
12. 容器信息收集（含 Redis/Emqx 异常处理）
13. 安卓设备自检
14. 定时任务查询
15. 生成健康检查报告
```

---

## 6. 配置与可变项

| 配置项 | Windows 版 | Linux 版 | 说明 |
|--------|-----------|----------|------|
| 脚本版本 | 1.0.3 | 1.0.3 | 用于日志与报告 |
| SSH 超时 | 30秒 | 不适用 | Linux 版无需 SSH |
| 日志目录 | {脚本目录}\logs\ | {脚本目录}/logs/ | 日志文件存储位置 |
| 报告目录 | {脚本目录}\Reports\ | {脚本目录}/Reports/ | Markdown 报告存储位置 |
| 输出目录 | {脚本目录}\output\ | {脚本目录}/output/ | 日志导出存储位置 |
| DNS 测试域名 | www.baidu.com<br>www.qq.com<br>www.aliyun.com | 同左 | DNS 解析测试 |
| 新统一平台检测目录 | /data/services | 同左 | 平台类型判定 |
| 传统平台统一平台检测目录 | /var/www/java/unifiedPlatform | 同左 | ujava 系统细分判定 |
| Redis 日志路径(新平台) | /data/middleware/redis/data/redis.log | 同左 | |
| Redis 日志路径(传统) | /var/www/redis/data/redis.log | 同左 | |
| Emqx 日志路径(新平台) | /data/middleware/emqx/log/emqx.log.1 | 同左 | |
| Emqx 日志路径(传统) | /var/www/emqx/log/emqx.log.1 | 同左 | |
| adb 工具路径 | 系统 PATH 中的 adb | linux_x86_adb/adb | 安卓设备自检 |
| 修复脚本调用 | Upload_the_repair_script | run_issue_handler | |

---

## 7. 异常处理与容错要求

### 7.1 通用异常处理（两版共同）

1. **命令执行失败**: 记录到日志，继续后续检测
2. **自动修复失败**: 记录失败原因，不中断主流程
3. **容器不存在**: 跳过相关检测，输出警告信息
4. **进程检测回退**: 容器内检测失败时自动尝试宿主机检测
5. **端口检测兼容**: 支持 netstat/ss/lsof 多种命令

### 7.2 Windows 版特有异常处理

1. **SSH 连接失败**: 输出详细错误信息，提示检查 IP、端口、密码、网络连通性
2. **依赖工具缺失**: 明确提示下载链接和放置位置
3. **日志文件写入失败**: 不影响主流程，仅记录错误
4. **主机密钥确认**: 自动处理首次连接的主机密钥确认问题

### 7.3 Linux 版特有异常处理

1. **权限不足**: 检测 root 权限，提示使用 sudo
2. **命令不存在**: 使用 `command_exists` 检查，提供替代方案
3. **日志同步**: exec + tee 确保日志实时同步

---

## 8. 交付物

### 8.1 Windows 版交付物
1. **主脚本**: `AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.ps1`
2. **日志文件**: `{脚本目录}\logs\health_check_{时间戳}.log`
3. **健康报告**: `{脚本目录}\Reports\health_report_{IP}_{时间戳}.md`
4. **导出日志**: `{脚本目录}\output\{IP}\logs\`

### 8.2 Linux 版交付物
1. **主脚本**: `AuxiliaryTool\ScriptTool\ServiceSelfInspection\check_server_health.sh`
2. **修复脚本**: `AuxiliaryTool\ScriptTool\ServiceSelfInspection\issue_handler.sh`
3. **日志文件**: `{脚本目录}/logs/health_check_{时间戳}.log`
4. **健康报告**: `{脚本目录}/Reports/health_report_{IP}_{时间戳}.md`
5. **导出日志**: `{脚本目录}/output/{IP}/logs/`

### 8.3 版本同步要求

> **重要：后续功能优化时，必须同时更新两个版本脚本，保持功能一致。**

- 新增功能需要在两个版本中实现
- 修复 Bug 需要在两个版本中同步修复
- 配置变更需要在两个版本中同步更新
- 测试时需要分别测试两个版本

---

## 9. 验收标准

### 9.1 Windows 版验收标准
1. 脚本可在 Windows 10+ 上正常运行
2. 可成功连接预设服务器列表中的服务器
3. 可正确识别新统一平台和传统平台
4. 可检测到容器内服务进程运行状态
5. 可检测到容器端口监听状态
6. DNS/NTP/防火墙异常时可自动修复
7. 可生成完整的 Markdown 格式健康检查报告
8. 所有检测步骤有日志记录，不静默失败

### 9.2 Linux 版验收标准
1. 脚本可在 Linux 服务器上正常运行（需要 root 权限）
2. 可正确识别新统一平台和传统平台
3. 可检测到容器内服务进程运行状态
4. 可检测到容器端口监听状态
5. DNS/NTP/防火墙异常时可自动修复
6. 可生成完整的 Markdown 格式健康检查报告
7. 可查询定时任务配置
8. 所有检测步骤有日志记录，不静默失败

### 9.3 双版本一致性验收
1. 两个版本功能检测结果一致
2. 两个版本报告格式一致
3. 两个版本修复逻辑一致
4. 版本号同步更新

---

## 需求规范

- 代码规范: `Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结: `Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结: `Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范: `Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范: `Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`
