# 计划执行_自动化服务监测脚本开发

> 版本：V1.0
> 创建日期：2026-01-28
> 基于文档：`_PRD_服务监测需求文档.md`
> 交付物：`AutomatedServiceMonitoring.sh`

---

## 一、任务概述

开发一套自动化服务监测脚本，实现对服务器资源的单次执行监测，包括日志审计、内存/MySQL/硬盘资源监测、容器状态检测、ERROR日志聚合分析，并生成Markdown报告发送邮件通知。

---

## 二、开发阶段划分

### 阶段一：基础框架搭建（优先级：高）

| 序号 | 任务 | 描述 | 预计产出 |
|------|------|------|----------|
| 1.1 | 创建脚本文件 | 创建 `AutomatedServiceMonitoring.sh` | 空壳脚本 |
| 1.2 | 实现日志函数 | `log()` 函数，统一日志格式 | 日志工具 |
| 1.3 | 定义全局配置 | 主机名、日志文件、报告目录等配置变量 | 配置段 |
| 1.4 | 邮件通知配置 | 收件人、SMTP配置、钉钉配置 | 通知配置 |
| 1.5 | 依赖检测函数 | `detect_os_and_pkg_mgr()` | 包管理器识别 |

**日志格式规范：**
```bash
[YYYY-MM-DD HH:MM:SS] [LEVEL] 消息内容
```

**全局配置：**
```bash
MYSQL_USER="root"
MYSQL_PASSWORD="密码"
LOG_FILE="./AutomatedServiceMonitoring.sh.log"
REPORT_DIR="./monitor_reports"
HOST_NAME="${HOST_NAME_OVERRIDE:-$(hostname)}"
MAIL_TO="收件人邮箱"
MAIL_SUBJECT_PREFIX="${MAIL_SUBJECT_PREFIX:-自动化服务监测报告}"  # 默认值，可通过环境变量覆盖
```

---

### 阶段二：平台与系统识别（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 2.1 | 平台类型检测 | `detect_platform()` | 检测/data/services目录 |
| 2.2 | 系统容器识别 | `detect_systems()` | 识别ujava/upython/upython_voice |
| 2.3 | 基路径设置 | 根据平台设置BASE_PATH | 新平台/data/services，旧平台/var/www |

**平台检测逻辑：**
```bash
if [ -d "/data/services" ]; then
    PLATFORM_TYPE="new"
    BASE_PATH="/data/services"
else
    PLATFORM_TYPE="legacy"
    BASE_PATH="/var/www"
fi
```

**系统容器识别：**
```bash
# 通过容器名前缀识别系统类型
# ujava   → meeting（会议预定）
# upython → ops（运维管理）
# upython_voice → transcription（语音转写）
```

---

### 阶段三：依赖安装与邮件配置（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 3.1 | mailx自动安装 | `ensure_mailx_installed()` | yum/apt-get自动安装 |
| 3.2 | SMTP配置生成 | `ensure_mailx_smtp_config()` | 生成/etc/mail.rc |
| 3.3 | sendmail安装 | `ensure_sendmail_installed()` | postfix安装 |
| 3.4 | mailx兼容性检测 | `mailx_supports_a_header()` | 检测-a参数支持 |

**依赖安装逻辑：**
```bash
# 检测包管理器（yum/apt）
if command -v yum >/dev/null 2>&1; then
    yum install -y mailx
elif command -v apt-get >/dev/null 2>&1; then
    apt-get install -y mailutils
fi
```

**SMTP配置（/etc/mail.rc）：**
```bash
set from="发件人邮箱"
set smtp="smtps://smtp.exmail.qq.com:465"
set smtp-auth=login
set smtp-auth-user="发件人邮箱"
set smtp-auth-password="密码"
set ssl-verify=ignore
```

---

### 阶段四：钉钉通知功能（优先级：中）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 4.1 | Webhook URL构造 | `build_dingtalk_url()` | access_token+timestamp+sign |
| 4.2 | URL编码实现 | 手动实现RFC3986编码 | 字母/数字/.-_/~保留，空格→+ |
| 4.3 | 消息发送 | `send_dingtalk_markdown()` | text类型消息 |
| 4.4 | @人支持 | at_mobiles+at_all | 支持@指定人 |

**钉钉签名计算：**
```bash
# 1. 构造签名字符串
string_to_sign="${timestamp}"$'\n'"${secret}"

# 2. HMAC-SHA256计算
sign_raw="$(printf '%s' "$string_to_sign" | openssl dgst -sha256 -hmac "$secret" -binary | openssl base64)"

# 3. URL编码（自定义实现）
sign_enc="$(url_encode "$sign_raw")"

# 4. 拼接Webhook URL
url="https://oapi.dingtalk.com/robot/send?access_token=${access_token}&timestamp=${timestamp}&sign=${sign_enc}"
```

---

### 阶段五：日志暴涨审计（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 5.1 | 日志目标解析 | `resolve_log_targets()` | 根据平台+系统确定日志路径 |
| 5.2 | 日志键构造 | `make_log_key()` | sys_name\|log_path格式 |
| 5.3 | 暴涨监测 | `monitor_log_burst_once()` | 300秒窗口检测 |

**日志暴涨监测逻辑：**
```bash
# 监测参数
window_seconds=300      # 时间窗口：5分钟
min_lines_threshold=1000  # 最小行数阈值
rate_threshold_per_sec=5   # 速率阈值：5行/秒

# 监测步骤
1. 初始化：首次执行记录总行数和时间戳
2. 累积：等待窗口期内收集数据
3. 判定：窗口期满后计算速率
4. 告警：满足以下任一条件即触发
   - 新增行数 >= 1000
   - 速率 >= 5行/秒
```

**日志路径映射：**
| 平台 | 系统 | 日志路径 |
| --- | --- | --- |
| 新平台 | meeting-2.0 | /data/services/api/java-meeting/java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |
| 新平台 | meeting-3.0 | /data/services/api/java-meeting/java-meeting3.0/logs/ubains-INFO-AND-ERROR.log |
| 旧平台 | meeting-2.0 | /var/www/java/api-java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |

---

### 阶段六：ERROR日志监测（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 6.1 | 时间戳提取 | `extract_epoch_from_log_line()` | 支持YYYY-MM-DD/YYYY/MM/DD格式 |
| 6.2 | 日志扫描 | `scan_ubains_error_log_to_md()` | 最近N行+1小时窗口 |
| 6.3 | 时间段聚合 | 相邻错误≤60s归为同段 | 按时间戳分组 |
| 6.4 | 报告写入 | `write_error_log_section_to_report()` | Markdown格式输出 |

**ERROR日志聚合参数：**
```bash
ERROR_TAIL_LINES=5000              # 扫描最后5000行
ERROR_GROUP_GAP_SECONDS=60        # 相邻错误≤60s归为同段
ERROR_LOOKBACK_SECONDS=3600       # 最近1小时窗口
ERROR_PRINT_MAX_LINES_PER_RANGE=10 # 每段最多打印10行
ERROR_MAX_RANGES_IN_REPORT=5       # 最多展示5个时间段
```

**聚合逻辑：**
```
1. 扫描日志文件最后N行
2. 提取时间戳并转换为epoch
3. 过滤最近1小时内的记录
4. 按时间排序
5. 相邻错误时间间隔≤60s → 同时间段
6. 每个时间段记录：start|end|count|sample_file
7. 只输出最近N个时间段
8. 每段最多打印M行样例
```

---

### 阶段七：资源监测（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 7.1 | 内存监测 | `monitor_mem_once()` | /proc/meminfo解析 |
| 7.2 | MySQL监测 | `monitor_mysql_once()` | 连接数+连接暴涨 |
| 7.3 | 硬盘监测 | `monitor_disk_once()` | 根分区使用率 |

**内存监测逻辑：**
```bash
# 从/proc/meminfo获取
total_kb=$(cat /proc/meminfo | awk '/^MemTotal:/ {print $2}')
avail_kb=$(cat /proc/meminfo | awk '/^MemAvailable:/ {print $2}')

# 计算使用量（MB）
used_mb=$(( (total_kb - avail_kb) / 1024 ))

# 统计
MEM_SAMPLES+=1
MEM_SUM_USED_MB=$((MEM_SUM_USED_MB + used_mb))
MEM_PEAK_USED_MB=max(MEM_PEAK_USED_MB, used_mb)
```

**MySQL连接暴涨监测：**
```bash
# 获取连接数
conn=$(docker exec mysql_container mysql -u${MYSQL_USER} -p${MYSQL_PASSWORD} -e "SHOW STATUS LIKE 'Threads_connected';" | tail -n1 | cut -f2)

# 暴涨检测（与日志暴涨类似）
window_seconds=300
min_burst_conn=200
rate_threshold_per_sec=1

# 判定条件：增量>=200 或 速率>=1/秒
```

**硬盘空间监测：**
```bash
# 取根分区/使用率
used_pct=$(df -P / | awk 'NR==2 { gsub(/%/,"",$5); print $5 }')

# 阈值：90%
if (( used_pct >= 90 )); then
    log WARN "[硬盘监测] 根分区(/)使用率偏高：当前=${used_pct}%"
fi
```

---

### 阶段八：容器信息检测（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 8.1 | 运行中容器采集 | `collect_container_info()` | docker ps格式化输出 |
| 8.2 | 未运行容器采集 | Exited+非Up状态 | docker ps -a过滤 |
| 8.3 | 表格化输出 | Markdown表格格式 | ID\|名称\|镜像\|状态\|创建时间 |

**容器信息采集：**
```bash
# 运行中容器
docker ps --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}'

# 未运行容器（Exited/非Up）
docker ps -a --filter 'status=exited' --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}'
```

---

### 阶段九：报告生成（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 9.1 | 报告目录创建 | `mkdir -p "$REPORT_DIR"` | 自动创建 |
| 9.2 | 报告文件命名 | `monitor_report_${HOST_NAME}_${file_ts}.md` | 包含主机名和时间戳 |
| 9.3 | Markdown报告写入 | `write_md_report()` | 分章节写入 |
| 9.4 | HTML转换 | `md_to_html_simple()` | awk+sed转换 |

**报告结构：**
```
# 自动化服务监测报告
- 生成时间、主机名、平台类型、系统识别

## 一、日志审计概览
### 日志：meeting-2.0
- 日志路径
- 日志暴涨状态
- 日志暴涨详情

## 二、ERROR日志监测（最近1小时）
### 2.1 对内日志（meeting后端）
### 2.2 对外日志

## 三、内存资源消耗
- 当前/平均/峰值

## 四、MySQL连接数监测
- 当前/平均/峰值
- 暴涨状态

## 五、硬盘空间检测
- 当前/平均/峰值使用率

## 六、容器信息检测
### 6.1 运行中的容器
### 6.2 未运行的容器
```

---

### 阶段十：邮件发送（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 10.1 | 主IP获取 | `get_primary_ip()` | 路由出口优先 |
| 10.2 | 邮件标题构造 | 包含IP+时间戳 | 【内部】192.168.x.x - YYYY-MM-DD HH:MM:SS |
| 10.3 | 纯文本邮件发送 | `send_report_mail()` | mailx/mailx发送 |
| 10.4 | HTML转换支持 | `md_to_html_simple()` | 可选HTML邮件 |

**主IP获取逻辑：**
```bash
# 方法1：通过路由默认出口
ip=$(ip route get 1 2>/dev/null | awk '{for(i=1;i<=NF;i++){if($i=="src"){print $(i+1); exit}}}')

# 方法2：回退到hostname -I
if [[ -z "$ip" ]]; then
    ip="$(hostname -I 2>/dev/null | awk '{print $1}')"
fi
```

**邮件发送逻辑：**
```bash
# 使用mailx（优先）或mail（回退）
if command -v mailx >/dev/null 2>&1; then
    mailx -s "$subject" $to < "$report_md"
else
    mail -s "$subject" $to < "$report_md"
fi
```

---

### 阶段十一：主流程集成（优先级：高）

| 序号 | 任务 | 描述 | 执行顺序 |
|------|------|------|----------|
| 11.1 | 主函数框架 | `main_run_once()` | - |
| 11.2 | 环境准备 | 依赖安装+SMTP配置 | 步骤0 |
| 11.3 | 平台系统识别 | detect_platform+detect_systems | 步骤1-2 |
| 11.4 | 资源监测执行 | 内存+MySQL+硬盘+容器 | 步骤3-6 |
| 11.5 | 报告生成 | write_md_report() | 步骤7 |
| 11.6 | 邮件发送 | send_report_mail() | 步骤8 |

**主流程伪代码：**
```bash
main_run_once() {
    log "[启动] 自动化服务监测脚本（单次执行模式）"

    # 步骤0: 环境准备
    ensure_mailx_installed
    ensure_mailx_smtp_config
    ensure_sendmail_installed

    # 步骤1-2: 平台与系统识别
    detect_platform
    detect_systems

    # 步骤3: 日志暴涨审计
    resolve_log_targets
    for each log_target; do
        monitor_log_burst_once
    done

    # 步骤4-6: 资源监测
    monitor_mem_once
    monitor_mysql_once
    collect_container_info
    monitor_disk_once

    # 步骤7: 报告生成
    report_file=$(write_md_report)

    # 步骤8: 邮件发送
    send_report_mail "$report_file"

    # 钉钉通知（已注释，不执行）
    # DD_TEXT="$dd_text" send_dingtalk_markdown

    log "[结束] 本次监测已完成"
}
```

---

### 阶段十二：异常处理与容错（优先级：高）

| 序号 | 任务 | 描述 | 实现要点 |
|------|------|------|----------|
| 12.1 | MySQL回退机制 | 容器→本机命令→SQL查询 | 多层级回退 |
| 12.2 | 硬盘检测容错 | df不可用时记录ERROR | 不影响主流程 |
| 12.3 | 日志文件缺失 | 文件不存在时记录NO_FILE | 不终止监测 |
| 12.4 | 邮件发送失败 | 记录ERROR但不终止 | 报告已落盘 |
| 12.5 | Docker不可用 | 记录INFO跳过容器检测 | 继续其他监测 |

**MySQL连接回退机制：**
```bash
# 优先级1: 容器内mysql命令
conn=$(docker exec mysql_container mysql -u${MYSQL_USER} -p${MYSQL_PASSWORD} -e "SHOW STATUS LIKE 'Threads_connected';")

# 优先级2: 容器内mysqladmin
conn=$(docker exec mysql_container mysqladmin status | grep -oE 'Threads:[[:space:]]*[0-9]+')

# 优先级3: 本机mysqladmin
conn=$(mysqladmin status | grep -oE 'Threads:[[:space:]]*[0-9]+')

# 优先级4: 本机mysql SQL查询
conn=$(mysql -u${MYSQL_USER} -p${MYSQL_PASSWORD} -e "SHOW STATUS LIKE 'Threads_connected';")
```

---

### 阶段十三：测试与验收（优先级：高）

| 序号 | 测试场景 | 验收标准 | 测试方法 |
|------|----------|----------|----------|
| 13.1 | 脚本执行 | 无语法错误，日志正常输出 | 直接执行脚本 |
| 13.2 | 平台识别 | 正确识别新/旧平台 | 在两类服务器上执行 |
| 13.3 | 日志暴涨 | 满足条件时触发WARN | 模拟日志暴涨 |
| 13.4 | 内存监测 | 正确计算当前/平均/峰值 | 对比free命令 |
| 13.5 | MySQL监测 | 正确获取连接数 | docker exec/mysqladmin对比 |
| 13.6 | 硬盘监测 | 正确获取根分区使用率 | df命令对比 |
| 13.7 | 容器检测 | 正确列出运行/未运行容器 | docker ps对比 |
| 13.8 | ERROR日志聚合 | 正确聚合时间段 | 构造测试日志 |
| 13.9 | 邮件发送 | 收到Markdown格式邮件 | 检查邮箱 |
| 13.10 | 钉钉通知 | Webhook调用成功 | 检查钉钉群 |

---

## 三、文件结构

```
AutomatedServiceMonitoring.sh (1575行)
├── 全局配置段
│   ├── 数据库配置（MYSQL_USER/PASSWORD）
│   ├── 日志配置（LOG_FILE）
│   ├── 报告目录（REPORT_DIR，WORD_REPORT_DIR已定义但未使用）
│   ├── 主机名（HOST_NAME）
│   ├── 邮件通知配置（MAIL_TO/MAIL_SUBJECT_PREFIX/MAIL_SMTP_**）
│   └── 钉钉配置（DINGDING_ACCESS_TOKEN/DINGDING_SECRET/**）
│
├── 日志函数
│   └── log()  # 统一日志输出（控制台+文件）
│
├── 依赖安装函数
│   ├── detect_os_and_pkg_mgr()     # 检测包管理器
│   ├── ensure_mailx_installed()    # 安装mailx/mailutils
│   ├── ensure_mailx_smtp_config()  # 生成/etc/mail.rc
│   ├── mailx_supports_a_header()   # 检测mailx -a参数支持
│   ├── ensure_sendmail_installed() # 安装postfix/sendmail
│
├── 钉钉通知函数
│   ├── build_dingtalk_url()         # 构造Webhook URL（含签名）
│   └── send_dingtalk_markdown()     # 发送text消息
│
├── 平台与系统识别
│   ├── detect_platform()             # 检测新/旧平台
│   └── detect_systems()              # 识别ujava/upython/upython_voice
│
├── 日志暴涨审计
│   ├── resolve_log_targets()        # 解析日志目标路径
│   ├── make_log_key()               # 构造日志键
│   └── monitor_log_burst_once()      # 单次暴涨监测
│
├── ERROR日志监测
│   ├── extract_epoch_from_log_line()        # 提取时间戳epoch
│   ├── get_meeting_service_dirs()           # 获取meeting服务目录
│   ├── get_meeting_internal_error_logs()    # 对内日志列表
│   ├── get_meeting_external_error_logs()    # 对外日志列表
│   ├── scan_ubains_error_log_to_md()        # 扫描并聚合ERROR
│   └── write_error_log_section_to_report()  # 写入报告
│
├── 资源监测函数
│   ├── monitor_mem_once()            # 内存监测
│   ├── monitor_mysql_once()          # MySQL连接数+暴涨监测
│   ├── find_mysql_container()        # 查找MySQL容器
│   ├── get_mysql_threads_connected_via_container()  # 容器内获取连接数
│   ├── monitor_disk_once()           # 硬盘空间监测
│   ├── get_root_disk_used_pct()      # 获取根分区使用率
│   └── get_disk_used_pct_max()       # 获取最大使用率
│
├── 容器信息检测
│   └── collect_container_info()       # 采集运行中/未运行容器
│
├── 工具函数
│   ├── get_primary_ip()              # 获取本机主IP
│   └── md_to_html_simple()           # Markdown转HTML
│
├── 邮件发送
│   └── send_report_mail()            # 发送邮件报告
│
└── 主流程
    └── main_run_once()                # 主函数
```

---

## 四、依赖与规范

### 4.1 依赖文档
- 代码规范：`Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结：`Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结：`Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范：`Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范：`Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`

### 4.2 外部依赖

**必需依赖：**
- `bash`：Shell执行环境
- `docker`：容器操作（容器监测、MySQL容器查找）
- `mysql`/`mysqladmin`：MySQL客户端（本机MySQL连接）
- `df`：磁盘空间检查
- `awk`/`sed`/`grep`：文本处理

**可选依赖：**
- `mailx`/`mail`：邮件发送
- `curl`：钉钉通知（已注释）
- `openssl`：钉钉签名计算

**平台兼容：**
- 支持新统一平台（/data/services）
- 支持传统平台（/var/www）

---

## 五、验收清单

### 5.1 基础功能
- [ ] 脚本可正常执行，无语法错误
- [ ] 日志正确输出到LOG_FILE
- [ ] 平台类型自动检测正确
- [ ] 系统容器识别正确（ujava/upython/upython_voice）

### 5.2 日志审计功能
- [ ] 日志目标路径正确解析
- [ ] 日志暴涨监测正常（300秒窗口、1000行/5行秒）
- [ ] 状态正确记录（INIT/COLLECTING/BURST/OK/NO_FILE/UNKNOWN）
- [ ] 暴涨时触发WARN级别日志

### 5.3 ERROR日志监测
- [ ] 时间戳提取正确
- [ ] 最近1小时窗口过滤正确
- [ ] 时间段聚合正确（≤60秒间隔）
- [ ] 最多展示5个时间段
- [ ] 每段最多打印10行样例

### 5.4 资源监测
- [ ] 内存监测正确（当前/平均/峰值）
- [ ] MySQL连接数获取正确（容器→本机多级回退）
- [ ] MySQL连接暴涨监测正常
- [ ] 硬盘使用率监测正确
- [ ] 90%阈值告警触发

### 5.5 容器检测
- [ ] 运行中容器列表正确
- [ ] 未运行容器列表正确
- [ ] Docker不可用时正确跳过
- [ ] 表格格式输出正确

### 5.6 报告生成
- [ ] Markdown报告正确生成
- [ ] 报告文件命名正确（主机名+时间戳）
- [ ] 报告章节完整（6个章节）
- [ ] 表格格式正确

### 5.7 邮件发送
- [ ] 主IP自动获取正确
- [ ] 邮件标题包含IP+时间戳
- [ ] mailx/mail发送成功
- [ ] SMTP配置自动生成
- [ ] 发送失败时记录ERROR但不终止

### 5.8 钉钉通知（已注释）
- [ ] Webhook URL构造正确
- [ ] 签名计算正确
- [ ] text消息发送成功
- [ ] @人功能正常
- [ ] 注：主流程中钉钉发送代码已注释（main_run_once函数第1524-1569行），如需启用请取消注释

---

## 六、部署说明

### 6.1 文件放置
```
自动化服务监测/
└── AutomatedServiceMonitoring.sh
```

### 6.2 权限设置
```bash
chmod +x AutomatedServiceMonitoring.sh
```

### 6.3 配置修改

**必须修改的配置：**
```bash
# 数据库密码
MYSQL_PASSWORD="your_mysql_password"

# 邮件收件人
MAIL_TO="recipient1@example.com,recipient2@example.com"

# SMTP配置
MAIL_SMTP_USER="your_email@example.com"
MAIL_SMTP_PASS="your_email_password"
```

**可选修改的配置：**
```bash
# 主机名覆盖（默认使用hostname）
export HOST_NAME_OVERRIDE="custom-hostname"

# 邮件标题前缀
export MAIL_SUBJECT_PREFIX="【自定义】"
```

### 6.4 执行方式

**单次执行：**
```bash
./AutomatedServiceMonitoring.sh
```

**后台执行：**
```bash
nohup ./AutomatedServiceMonitoring.sh >/dev/null 2>&1 &
```

**定时执行（crontab）：**
```bash
# 每小时执行一次
0 * * * * /path/to/AutomatedServiceMonitoring.sh

# 每30分钟执行一次
*/30 * * * * /path/to/AutomatedServiceMonitoring.sh
```

### 6.5 报告查看
- Markdown报告：`./monitor_reports/monitor_report_<hostname>_<timestamp>.md`
- 脚本日志：`./AutomatedServiceMonitoring.sh.log`

---

## 七、关键实现要点

### 7.1 MySQL连接多级回退

**需求描述：**
优先从容器内获取连接数，失败则依次回退到本机命令。

**实现代码：**
```bash
get_mysql_threads_connected_via_container() {
    local container="$1"
    local auth="-u${MYSQL_USER} -p${MYSQL_PASSWORD}"

    # 方法1: 容器内mysql命令
    local out
    out="$(docker exec -i "${container}" mysql -ss ${auth} -e "SHOW STATUS LIKE 'Threads_connected';" 2>/dev/null | tail -n1 | cut -f2)"
    if [[ "$out" =~ ^[0-9]+$ ]]; then
        echo "$out"
        return 0
    fi

    # 方法2: 容器内mysqladmin
    out="$(docker exec -i "${container}" mysqladmin ${auth} status 2>/dev/null)"
    local val
    val="$(echo "$out" | grep -oE 'Threads:[[:space:]]*[0-9]+' | awk '{print $2}')"
    if [[ "$val" =~ ^[0-9]+$ ]]; then
        echo "$val"
        return 0
    fi

    return 1
}
```

---

### 7.2 时间戳提取兼容多种格式

**需求描述：**
支持 YYYY-MM-DD HH:MM:SS 和 YYYY/MM/DD HH:MM:SS 格式。

**实现代码：**
```bash
extract_epoch_from_log_line() {
    local line="$1"
    local dt

    # 提取日期时间（兼容-和/分隔符）
    dt="$(echo "$line" | grep -Eo '20[0-9]{2}[-/][0-9]{2}[-/][0-9]{2}[ T][0-9]{2}:[0-9]{2}:[0-9]{2}' | head -n 1)"
    [[ -z "$dt" ]] && return 1

    # 统一成date命令格式：YYYY-MM-DD HH:MM:SS
    dt="${dt//\//-}"      # 替换/为-
    dt="${dt/T/ }"      # 替换T为空格

    date -d "$dt" +%s 2>/dev/null
}
```

---

### 7.3 钉钉签名URL编码

**需求描述：**
严格对齐Python的urllib.parse.quote_plus，实现RFC3986 URL编码。

**编码规则：**
1. 字母/数字/.-/_/~ 保留
2. 空格 → +
3. 其它字符（包括+/=/）都转成 %XX

**实现代码：**
```bash
sign_enc=""
local i ch hex
for ((i=0; i<${#sign_raw}; i++)); do
    ch="${sign_raw:$i:1}"
    case "$ch" in
        [a-zA-Z0-9.~_-])
            sign_enc+="$ch"
            ;;
        ' ')
            sign_enc="+"
            ;;
        *)
            printf -v hex '%%%02X' "'$ch"
            sign_enc+="$hex"
            ;;
    esac
done
```

---

### 7.4 ERROR日志时间段聚合

**需求描述：**
将最近1小时内的ERROR日志按时间间隔≤60秒聚合为时间段。

**聚合逻辑：**
```bash
# 初始化
range_start=0
range_end=0
last_ts=0
printed=0

while IFS='|' read -r ts line; do
    if (( range_start == 0 )); then
        # 第一个有效记录
        range_start=$ts
        range_end=$ts
        last_ts=$ts
        printed=0
        continue
    fi

    local gap=$(( ts - last_ts ))

    if (( gap <= ERROR_GROUP_GAP_SECONDS )); then
        # 同一时间段
        range_end=$ts
        last_ts=$ts
        # 记录样例（最多N行）
        if (( printed < ERROR_PRINT_MAX_LINES_PER_RANGE )); then
            echo "$line" >> "$range_lines_tmp"
            printed=$((printed + 1))
        fi
    else
        # 新时间段：flush旧时间段
        # 保存元数据：start|end|count|sample_file
        # 继续处理下一行
    fi
done
```

---

### 7.5 硬盘空间稳定采集方案

**需求描述：**
为保证稳定性，只采集根分区/的使用率，避免复杂解析导致失败。

**实现代码：**
```bash
get_root_disk_used_pct() {
    if ! command -v df >/dev/null 2>&1; then
        return 1
    fi

    # df -P 输出稳定，Use%在第5列
    df -P / 2>/dev/null | awk 'NR==2 { gsub(/%/,"",$5); print $5 }'
}
```

---

## 八、进度跟踪

| 阶段 | 状态 | 完成时间 | 备注 |
|------|------|----------|------|
| 阶段一：基础框架搭建 | ✅ 已完成 | 2026-01-28 | 日志函数、全局配置、依赖检测 |
| 阶段二：平台与系统识别 | ✅ 已完成 | 2026-01-28 | 平台检测、系统容器识别 |
| 阶段三：依赖安装与邮件配置 | ✅ 已完成 | 2026-01-28 | mailx自动安装、SMTP配置生成 |
| 阶段四：钉钉通知功能 | ✅ 已完成（已注释） | 2026-01-28 | Webhook构造、签名计算、消息发送；主流程中已注释不调用 |
| 阶段五：日志暴涨审计 | ✅ 已完成 | 2026-01-28 | 300秒窗口、速率阈值检测 |
| 阶段六：ERROR日志监测 | ✅ 已完成 | 2026-01-28 | 1小时窗口、时间段聚合 |
| 阶段七：资源监测 | ✅ 已完成 | 2026-01-28 | 内存/MySQL/硬盘监测 |
| 阶段八：容器信息检测 | ✅ 已完成 | 2026-01-28 | 运行中/未运行容器采集 |
| 阶段九：报告生成 | ✅ 已完成 | 2026-01-28 | Markdown报告+HTML转换 |
| 阶段段十：邮件发送 | ✅ 已完成 | 2026-01-28 | 主IP获取、邮件发送 |
| 阶段十一：主流程集成 | ✅ 已完成 | 2026-01-28 | 单次执行主流程 |
| 阶段十二：异常处理与容错 | ✅ 已完成 | 2026-01-28 | MySQL回退、容错处理 |
| 阶段十三：测试与验收 | ⬜ 待执行 | - | 功能测试、邮件发送测试 |

**脚本规模统计：**
| 脚本 | 行数 | 主要功能 |
|------|------|----------|
| AutomatedServiceMonitoring.sh | 1575行 | 自动化服务监测脚本（单次执行版） |
| **合计** | **1575行** | 完整实现 |

---

## 九、重要注意事项

### 9.1 与monitor_inner_api_services.sh的区别

| 特性 | AutomatedServiceMonitoring.sh | monitor_inner_api_services.sh |
| --- | --- | --- |
| 主要用途 | 资源监测+报告生成 | 服务监测+自愈重启 |
| 执行模式 | 单次执行 | 定时执行（crontab） |
| 监测对象 | 日志暴涨+ERROR日志+资源+容器 | 平台API+容器内服务+端口 |
| 输出方式 | Markdown报告+邮件 | 日志文件 |
| 平台支持 | 新平台+传统平台 | 仅预定系统 |

### 9.2 开发顺序建议

1. **先开发基础框架**：日志函数、全局配置
2. **再开发监测功能**：日志暴涨、ERROR聚合、资源监测
3. **最后开发通知功能**：邮件发送、钉钉通知

### 9.3 关键技术点

1. **日志暴涨检测**：使用300秒滑动窗口，行数+速率双重阈值
2. **ERROR日志聚合**：时间戳提取+时间间隔聚合
3. **MySQL多级回退**：容器→本机命令→SQL查询
4. **钉钉签名计算**：HMAC-SHA256+Base64+自定义URL编码
5. **Markdown转HTML**：awk+sed轻量转换器
6. **平台自动识别**：检测/data/services目录
7. **资源统计**：使用全局变量累计计算平均/峰值

### 9.4 测试策略

1. **单元测试**：每个监测函数独立测试
2. **集成测试**：完整流程联调测试
3. **平台测试**：新平台和旧平台分别测试
4. **邮件测试**：验证邮件发送和格式
5. **ERROR日志测试**：构造测试日志验证聚合逻辑

### 9.5 钉钉通知说明

钉钉通知功能已完整实现（`build_dingtalk_url()`、`send_dingtalk_markdown()`），但在 `main_run_once()` 主流程中已注释（第1524-1569行）。如需启用钉钉通知，请取消相关代码的注释。

---

*本文档基于 AutomatedServiceMonitoring.sh 脚本分析生成，如有疑问请参考源脚本。*
