# _PRD_服务监测需求文档

> 版本：V1.0
> 更新日期：2026-01-28
> 适用范围：自动化服务监测脚本
> 实现脚本：`AuxiliaryTool\ScriptTool\自动化服务监测\AutomatedServiceMonitoring.sh`

---

## 1. 背景与目标

### 1.1 背景
服务器运行的核心服务（ujava/upython/upython_voice）会产生大量日志，同时需要持续监控内存、MySQL连接、硬盘空间等资源使用情况。为降低运维成本，需要实现自动化服务监测工具，定期生成监测报告并发送通知。

### 1.2 目标
实现一套自动化服务监测脚本，具备：
- 自动识别平台类型（新统一平台/传统平台）
- 自动识别系统类型（meeting/ops/transcription）
- 日志暴涨检测与告警
- ERROR日志聚合分析（按时间段）
- 资源监测（内存/MySQL连接/硬盘空间）
- 容器信息采集
- Markdown报告生成与邮件通知

---

## 2. 总体范围

### 2.1 纳入监测对象

#### 2.1.1 平台类型
1. **新统一平台**
   - 检测标志：存在 `/data/services` 目录
2. **传统平台**
   - 检测标志：不存在 `/data/services` 目录

#### 2.1.2 系统容器类型
| 容器名 | 说明 | 系统标识 |
|--------|------|----------|
| ujava* | Java 服务容器（会议预定） | meeting |
| upython* | 运维集控系统 | ops |
| upython_voice* | 语音转写系统 | transcription |

#### 2.1.3 日志路径映射

**新统一平台：**
| 系统 | 日志路径 |
|------|----------|
| meeting-2.0 | /data/services/api/java-meeting/java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |
| meeting-3.0 | /data/services/api/java-meeting/java-meeting3.0/logs/ubains-INFO-AND-ERROR.log |

**传统平台：**
| 系统 | 日志路径 |
|------|----------|
| meeting-2.0 | /var/www/java/api-java-meeting2.0/logs/ubains-INFO-AND-ERROR.log |

### 2.2 不在本期范围（可扩展）
- 实时监控告警（钉钉/邮件/短信）
- 服务性能指标监控（响应时间、吞吐量）
- 自动扩缩容策略
- 多服务器批量监测

---

## 3. 术语说明

| 术语 | 说明 |
|------|------|
| 平台类型 | `new`（新统一平台）或 `legacy`（传统平台） |
| 系统类型 | 容器名称对应的服务类型：meeting/ops/transcription |
| 时间戳 | 格式 `YYYY-MM-DD HH:MM:SS` 或 `YYYYMMDD_HHmmss` |
| 日志暴涨窗口 | 监测日志打印速率的时间窗口（默认300秒） |
| ERROR聚合间隔 | 相邻ERROR日志时间间隔≤60秒归为同一时间段 |
| 钉钉签名 | HMAC-SHA256签名算法（加签模式） |

---

## 4. 功能需求

### 4.1 依赖检查

#### 4.1.1 必需依赖
- `bash`：Shell执行环境（4.0+）
- `docker`：容器操作
- `mailx`/`mail`：邮件发送
- `mysql`/`mysqladmin`：MySQL客户端
- `df`：磁盘空间检查
- `awk`/`sed`/`grep`：文本处理

#### 4.1.2 可选依赖
- `curl`：钉钉通知（已注释）
- `openssl`：钉钉签名计算

#### 4.1.3 包管理器检测
自动检测系统包管理器（yum/apt）用于安装mailx和sendmail

---

### 4.2 平台与系统识别

#### 4.2.1 平台类型检测
```bash
[ -d /data/services ] && echo 'NEW_PLATFORM' || echo 'OLD_PLATFORM'
```

| 类型 | 判定条件 | 基路径 |
|------|----------|--------|
| new | 存在 /data/services 目录 | /data/services |
| legacy | 不存在 /data/services 目录 | /var/www |

#### 4.2.2 系统类型检测
通过Docker容器名称匹配：

| 容器匹配 | 系统标识 | 说明 |
|---------|---------|------|
| `ujava` | meeting | 会议预定系统 |
| `upython`（非voice） | ops | 运维集控系统 |
| `upython_voice` | transcription | 语音转写系统 |

---

### 4.3 日志暴涨审计

#### 4.3.1 监测参数
| 参数 | 默认值 | 说明 |
|------|--------|------|
| 窗口时间 | 300秒 | 统计时间窗口 |
| 行数阈值 | 1000行 | 最小新增行数阈值 |
| 速率阈值 | 5行/秒 | 打印速率阈值 |

#### 4.3.2 监测流程
1. **初始化阶段**：首次执行记录总行数和时间戳
2. **累积阶段**：等待窗口期内收集数据
3. **判定阶段**：窗口期满后计算速率
4. **告警触发**：满足以下任一条件即触发
   - 新增行数 ≥ 1000
   - 速率 ≥ 5行/秒

#### 4.3.3 状态值
| 状态 | 说明 |
|------|------|
| INIT | 初始化窗口，首次记录基线数据 |
| COLLECTING | 数据采集中，窗口未满 |
| BURST | 检测到日志暴涨 |
| OK | 未检测到异常 |
| NO_FILE | 日志文件不存在 |
| UNKNOWN | 无法获取总行数 |

#### 4.3.4 判定逻辑
```bash
# 计算增量行数
delta_lines = total_lines - last_total

# 计算时间跨度（秒）
elapsed = now_ts - last_ts

# 计算速率（行/秒）
rate = delta_lines / elapsed

# 判定条件
if (delta_lines >= 1000) || (rate >= 5) then
    status = "BURST"
else
    status = "OK"
fi
```

---

### 4.4 ERROR日志监测

#### 4.4.1 监测参数
| 参数 | 默认值 | 说明 |
|------|--------|------|
| ERROR_TAIL_LINES | 5000 | 扫描最后N行 |
| ERROR_GROUP_GAP_SECONDS | 60 | 相邻错误≤60s归为同段 |
| ERROR_LOOKBACK_SECONDS | 3600 | 最近1小时窗口 |
| ERROR_PRINT_MAX_LINES_PER_RANGE | 10 | 每段最多打印行数 |
| ERROR_MAX_RANGES_IN_REPORT | 5 | 最多展示时间段数 |

#### 4.4.2 监测流程
1. **扫描日志**：读取最后N行日志
2. **提取时间戳**：支持 `YYYY-MM-DD` 和 `YYYY/MM/DD` 格式
3. **时间过滤**：仅保留最近1小时内的记录
4. **时间排序**：按时间戳升序排序
5. **聚合分组**：相邻错误≤60秒归为同一时间段
6. **样例保存**：每个时间段保存最多N行样例
7. **输出报告**：只输出最近N个时间段

#### 4.4.3 时间戳提取
**支持格式：**
- `YYYY-MM-DD HH:MM:SS`
- `YYYY/MM/DD HH:MM:SS`
- `YYYY-MM-DDTHH:MM:SS`

**提取正则：**
```bash
grep -Eo '20[0-9]{2}[-/][0-9]{2}[-/][0-9]{2}[ T][0-9]{2}:[0-9]{2}:[0-9]{2}'
```

#### 4.4.4 聚合逻辑
```
1. 读取日志行并提取时间戳转换为epoch
2. 过滤最近1小时内的记录
3. 按时间升序排序
4. 遍历记录，相邻时间间隔≤60秒 → 同时间段
5. 每个时间段记录：start|end|count|sample_file
6. 只输出最近N个时间段
7. 每个时间段最多打印M行样例
```

#### 4.4.5 日志分类
| 分类 | 说明 |
|------|------|
| 对内日志 | meeting后端服务日志（ubains-ERROR.log） |
| 对外日志 | meeting对外服务日志（与对内同目录或nginx日志） |

---

### 4.5 资源监测

#### 4.5.1 内存监测
**监测方式：**
```bash
cat /proc/meminfo | awk '/^MemTotal:/ {print $2}'  # 总内存(KB)
cat /proc/meminfo | awk '/^MemAvailable:/ {print $2}'  # 可用内存(KB)
```

**统计指标：**
- 当前使用量（MB）
- 平均使用量（MB）
- 峰值使用量（MB）
- 峰值发生时间

#### 4.5.2 MySQL连接数监测
**连接数获取方式（多级回退）：**

1. **优先级1**：容器内mysql命令
```bash
docker exec mysql_container mysql -u{user} -p{password} -e "SHOW STATUS LIKE 'Threads_connected';"
```

2. **优先级2**：容器内mysqladmin
```bash
docker exec mysql_container mysqladmin status | grep 'Threads:'
```

3. **优先级3**：本机mysqladmin
```bash
mysqladmin status | grep 'Threads:'
```

4. **优先级4**：本机mysql SQL查询
```bash
mysql -u{user} -p{password} -e "SHOW STATUS LIKE 'Threads_connected';"
```

**MySQL连接暴涨监测：**
| 参数 | 默认值 | 说明 |
|------|--------|------|
| 窗口时间 | 300秒 | 统计时间窗口 |
| 连接增量阈值 | 200 | 最小新增连接数阈值 |
| 速率阈值 | 1/秒 | 连接速率阈值 |

**判定条件：**
- 增量连接数 ≥ 200 或
- 速率 ≥ 1/秒

#### 4.5.3 硬盘空间监测
**监测方式：**
```bash
df -P / | awk 'NR==2 {gsub(/%/,"",$5); print $5}'  # 根分区/使用率
```

**统计指标：**
- 当前使用率（%）
- 平均使用率（%）
- 峰值使用率（%）
- 峰值发生时间

**告警阈值：**
- 90%：触发WARN级别告警

---

### 4.6 容器信息采集

#### 4.6.1 运行中容器
**采集命令：**
```bash
docker ps --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}'
```

#### 4.6.2 未运行容器
**采集命令：**
```bash
docker ps -a --filter 'status=exited' --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}'
# 补充其它非Up状态容器
docker ps -a --format '{{.ID}}\t{{.Names}}\t{{.Image}}\t{{.Status}}\t{{.CreatedAt}}' | grep -v 'Up '
```

#### 4.6.3 表格化输出
| 容器ID | 名称 | 镜像 | 状态 | 创建时间 |
|--------|------|------|------|----------|

---

### 4.7 报告生成

#### 4.7.1 报告格式
Markdown格式

#### 4.7.2 报告路径
```
./monitor_reports/monitor_report_{主机名}_{时间戳}.md
```

#### 4.7.3 报告内容结构
```
# 自动化服务监测报告
- 生成时间、主机名、平台类型、系统识别

## 一、日志审计概览（仅暴涨情况）
### 日志：meeting-2.0
### 日志：meeting-3.0

## 二、ERROR日志监测（最近1小时，按时间段聚合）
### 2.1 对内日志（meeting 后端）
### 2.2 对外日志

## 三、内存资源消耗
- 当前/平均/峰值

## 四、MySQL连接数监测
- 当前/平均/峰值
- 暴涨状态

## 五、硬盘空间检测
- 当前/平均/峰值使用率

## 六、容器信息检测
### 6.1 运行中的容器
### 6.2 未运行的容器
```

---

### 4.8 邮件发送

#### 4.8.1 邮件依赖安装
**自动安装流程：**
1. 检测包管理器（yum/apt）
2. 安装mailx/mailutils
3. 生成/etc/mail.rc配置文件

#### 4.8.2 SMTP配置
**配置文件：** `/etc/mail.rc`

**配置内容：**
```bash
set from="发件人邮箱"
set smtp="smtps://smtp.exmail.qq.com:465"
set smtp-auth=login
set smtp-auth-user="发件人邮箱"
set smtp-auth-password="密码"
set ssl-verify=ignore
```

#### 4.8.3 邮件标题
**格式：** `【{前缀}】{服务器IP} - {时间戳}`

**示例：** `【内部服务器监测】192.168.5.48 - 2026-01-28 10:00:00`

#### 4.8.4 邮件发送
**发送命令：**
```bash
mailx -s "{标题}" {收件人} < {报告文件}
```

---

### 4.9 钉钉通知（已注释）

#### 4.9.1 钉钉机器人配置
| 配置项 | 说明 |
|--------|------|
| DINGDING_ACCESS_TOKEN | 机器人access_token |
| DINGDING_SECRET | 加签密钥 |
| DINGDING_AT_MOBILES | @手机号列表（逗号分隔） |
| DINGDING_AT_ALL | 是否@所有人（true/false） |

#### 4.9.2 Webhook URL构造
**签名计算流程：**
1. 构造签名字符串：`timestamp + "\n" + secret`
2. HMAC-SHA256计算并Base64编码
3. URL编码（RFC3986）
4. 拼接Webhook URL

**URL编码规则：**
1. 字母/数字/`.-_/~` 保留
2. 空格 → `+`
3. 其它字符（包括+/=/）都转成 `%XX`

#### 4.9.3 消息发送
**消息类型：** text

**消息体格式：**
```json
{
  "msgtype": "text",
  "text": {
    "content": "消息内容"
  },
  "at": {
    "atMobiles": ["手机号1", "手机号2"],
    "isAtAll": false
  }
}
```

---

## 5. 主流程

```
┌─────────────────────────────────────────────────────────────┐
│                  自动化服务监测流程（单次执行）                 │
└─────────────────────────────────────────────────────────────┘

1. [启动] 脚本初始化
   │
2. [环境准备] 安装mailx、配置SMTP、安装sendmail
   │
3. [平台识别] 检测/data/services目录
   │    ├─ 存在 → 新统一平台 (/data/services)
   │    └─ 不存在 → 传统平台 (/var/www)
   │
4. [系统识别] 识别Docker容器（ujava/upython/upython_voice）
   │
5. [日志审计] 日志暴涨检测（300秒窗口、1000行/5行秒）
   │
6. [资源监测]
   │    ├─ 内存监测（/proc/meminfo）
   │    ├─ MySQL连接数+暴涨监测
   │    ├─ 硬盘空间监测（根分区/）
   │    └─ 容器信息采集
   │
7. [ERROR日志] 最近1小时ERROR聚合分析（≤60s分组）
   │
8. [报告生成] Markdown格式报告
   │
9. [邮件发送] 发送报告到指定邮箱
   │
10. [钉钉通知] 发送摘要到钉钉群（已注释）
   │
11. [结束] 本次监测完成
```

---

## 6. 配置与可变项

| 配置项 | 默认值 | 说明 |
|--------|--------|------|
| MYSQL_USER | root | MySQL用户名 |
| MYSQL_PASSWORD | - | MySQL密码（需配置） |
| LOG_FILE | ./AutomatedServiceMonitoring.sh.log | 日志文件路径 |
| REPORT_DIR | ./monitor_reports | 报告目录 |
| HOST_NAME | $(hostname) | 主机名（可通过环境变量覆盖） |
| MAIL_TO | - | 收件人邮箱（逗号分隔，需配置） |
| MAIL_SUBJECT_PREFIX | 【内部服务器监测】 | 邮件标题前缀（可覆盖） |
| MAIL_SMTP_HOST | smtp.exmail.qq.com | SMTP服务器 |
| MAIL_SMTP_PORT | 465 | SMTP端口 |
| MAIL_SMTP_USER | - | SMTP用户名（需配置） |
| MAIL_SMTP_PASS | - | SMTP密码（需配置） |
| DINGDING_ACCESS_TOKEN | - | 钉钉机器人token（已注释） |
| DINGDING_SECRET | - | 钉钉加签密钥（已注释） |
| ERROR_TAIL_LINES | 5000 | ERROR日志扫描行数 |
| ERROR_GROUP_GAP_SECONDS | 60 | ERROR聚合间隔 |
| ERROR_LOOKBACK_SECONDS | 3600 | ERROR时间窗口 |
| ERROR_PRINT_MAX_LINES_PER_RANGE | 10 | 每段样例行数 |
| ERROR_MAX_RANGES_IN_REPORT | 5 | 输出时间段数 |

---

## 7. 异常处理与容错要求

### 7.1 通用异常处理
1. **命令执行失败**：记录到日志，不中断主流程
2. **邮件发送失败**：记录ERROR但报告已落盘
3. **Docker不可用**：跳过容器检测，记录INFO
4. **文件不存在**：记录NO_FILE状态，继续其他监测
5. **解析失败**：记录ERROR，使用默认值或N/A

### 7.2 MySQL连接多级回退
- 容器内mysql命令 → 容器内mysqladmin → 本机mysqladmin → 本机mysql SQL
- 任一方式成功即返回结果

### 7.3 日志时间戳解析容错
- 支持 `-` 和 `/` 两种日期分隔符
- 支持 `T` 和空格两种日期时间分隔符
- 解析失败时跳过该行

---

## 8. 交付物

### 8.1 脚本文件
1. **主脚本**: `AuxiliaryTool\ScriptTool\自动化服务监测\AutomatedServiceMonitoring.sh`

### 8.2 输出文件
1. **日志文件**: `./AutomatedServiceMonitoring.sh.log`
2. **监测报告**: `./monitor_reports/monitor_report_{主机名}_{时间戳}.md`

### 8.3 外部依赖
- **必需**：docker, mailx/mail, mysql/mysqladmin
- **可选**：curl, openssl（钉钉通知用）

---

## 9. 验收标准

### 9.1 基础功能
1. 脚本可正常执行，无语法错误
2. 日志正确输出到LOG_FILE
3. 平台类型自动检测正确
4. 系统容器识别正确（ujava/upython/upython_voice）

### 9.2 日志审计功能
1. 日志目标路径正确解析
2. 日志暴涨监测正常（300秒窗口、1000行/5行秒）
3. 状态正确记录（INIT/COLLECTING/BURST/OK/NO_FILE/UNKNOWN）
4. 暴涨时触发WARN级别日志

### 9.3 ERROR日志监测
1. 时间戳提取正确（支持多种格式）
2. 最近1小时窗口过滤正确
3. 时间段聚合正确（≤60秒间隔）
4. 最多展示5个时间段
5. 每段最多打印10行样例

### 9.4 资源监测
1. 内存监测正确（当前/平均/峰值）
2. MySQL连接数获取正确（多级回退）
3. MySQL连接暴涨监测正常
4. 硬盘使用率监测正确
5. 90%阈值告警触发

### 9.5 容器检测
1. 运行中容器列表正确
2. 未运行容器列表正确
3. Docker不可用时正确跳过
4. 表格格式输出正确

### 9.6 报告生成
1. Markdown报告正确生成
2. 报告文件命名正确（主机名+时间戳）
3. 报告章节完整（6个章节）
4. 表格格式正确

### 9.7 邮件发送
1. 主机名自动获取正确
2. 邮件标题包含IP+时间戳
3. mailx/mail发送成功
4. SMTP配置自动生成
5. 发送失败时记录ERROR但不终止

### 9.8 钉钉通知（可选）
1. Webhook URL构造正确
2. 签名计算正确
3. text消息发送成功
4. @人功能正常

---

## 10. 需求规范

- 代码规范：`Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md`
- 问题总结：`Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md`
- 方法总结：`Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md`
- 文档规范：`Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md`
- 测试规范：`Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md`
