# _PRD_后端服务监测需求文档.md

> 版本：V1.0  
> 更新日期：2026-01-27  
> 适用范围：预定系统后端服务监测与自愈（容器内服务 + 端口服务）  
> 实现脚本：`自动化部署脚本\x86架构\预定系统\定时脚本\monitor_inner_api_services.sh`  

---

## 1. 背景与目标

### 1.1 背景
会议预定系统部署后，核心后端服务主要运行在 `ujava2` 容器中。以及宿主机端口 `6060` 的 `malan` 服务。  
为降低故障恢复人工成本，需要引入定时监测与自动恢复能力。

### 1.2 目标
实现一套可定时执行的服务监测与自愈脚本，具备：
- 容器内关键服务进程监测与拉起
- 平台 API 可用性检查，异常时强制重启关键服务（inner）
- 宿主机 6060 端口监测，未监听时启动 malan
- 全流程日志输出与审计

---

## 2. 总体范围

### 2.1 纳入监测对象
1. **平台 API 可用性**
   - URL：`https://服务器实际IP地址/api/system/getVerifyCode`
2. **容器：`ujava2` 内部服务进程**
   - inner
3. **宿主机 6060 端口及 malan 服务**
   - 端口：6060
   - 目录：`/var/www/malan`
   - 启动命令：`./malan`

### 2.2 不在本期范围（可扩展）
- 指标型监控（CPU/内存/磁盘阈值与告警）
- 日志关键字检索与告警
- 统一告警通道（钉钉/邮件/短信）
- 容器资源限制/扩容策略

---

## 3. 术语说明

- **服务 key**：脚本内部用于标识服务的字符串，如 `meeting2.0`
- **关键服务**：inner（平台 API 异常时强制重启）
- **时间戳**：统一格式 `YYYY-MM-DD HH:MM:SS`

---

## 4. 功能需求

### 4.1 日志与审计
#### 4.1.1 日志文件
- 主日志：`/var/log/monitor-inner-api-services.log`

#### 4.1.2 日志格式
每行必须包含：
- 时间戳：`timestamp()`
- 级别/动作标识：`[START] [STOP] [RUNNING] [STOPPED] [SUCCESS] [FAILED] [WARNING] [ERROR] [SUMMARY]`
- 目标对象：服务 key / 容器名 / 端口

示例：
- `2026-01-27 10:00:00 [RUNNING] gateway (PID: 1234)`
- `2026-01-27 10:00:10 [WARNING] 检测到 4 个服务停止，将重启unacos2容器`

---

### 4.2 平台 API 可用性检查（前置检查）
#### 4.2.1 检查逻辑
请求：
- `GET https://服务器实际IP地址/api/system/getVerifyCode`
- `curl -k -m 10`

判定：
- HTTP 状态码必须为 `200`
- 响应内容必须包含：`"操作成功"` 且 `code:200`（允许空格）

#### 4.2.2 处理策略
- 若 API 检查失败：触发 **强制重启内部服务**（见 4.3）
- API 正常：继续后续检查流程

---

### 4.3 容器 ujava2 内部服务监测与自愈
#### 4.3.1 服务清单
| 服务key | jar标识/定位 | 启动脚本 |
| --- | --- | --- |
| meeting2.0 | `ubains-meeting-inner-api` | `/var/www/java/api-java-meeting2.0/run.sh` |

> 注：meeting2.0/3.0 通过 ps 组合条件避免误匹配（脚本内为特判逻辑）。

#### 4.3.2 运行状态判定
  说明：容器名称不一定叫ujava2，也可能是ujava3、ujava6，需要做模糊匹配。
  判断1：
    - 获取 PID：通过 `docker exec ujava2` 在容器内 `ps aux | grep` 定位
    - 判定运行：PID 非空 且 `ps -p $pid` 成功
  判断2：
    - code接口调用：通过curl -v https:/服务器实际IP地址/api/system/getVerifyCode

#### 4.3.3 自愈动作：run.sh
- 启动：在容器内执行：
  - `cd /var/www/java/api-java-meeting2.0/`
  - `./run.sh`
- **注意**：必须使用 `./run.sh` 而非 `bash run.sh`，因为脚本可能依赖执行路径
- 等待启动：超时 30 秒
- 成功：输出 `[SUCCESS] service_key (PID: xxx)`
- 失败：输出 `[FAILED] service_key 启动超时`

#### 4.3.4 服务检查：check_services
- 输出本轮检查开始标识：`===== timestamp 服务状态检查 =====`
- 遍历全部服务输出 RUNNING/STOPPED
- 统计 STOPPED 数量 problems
- 调用 `restart_unacos_if_needed problems`
- 返回 problems 作为流程判断依据

---

### 4.4 宿主机 6060 端口与 malan 监测与启动
#### 4.4.1 6060端口检查
端口监听判定满足任一：
- `netstat -tuln | grep ':6060 '`
- `ss -tuln | grep ':6060 '`
- `lsof -i:6060`

#### 4.4.2 启动 malan
- 目录：`/var/www/malan`
- 启动命令：`bash -c "source /etc/profile && ./malan" &`
- 等待端口就绪 30 秒
- 成功：记录 `6060端口已监听`
- 失败：记录 `启动超时，6060端口未监听`

---

## 5. 主流程（顺序要求）

脚本主流程必须按以下顺序执行：

1. **平台 API 检查**
   - 若失败 → `restart_critical_services`
2. **容器内服务检查**
   - `check_services`
   - 若返回非 0 → `restart_problem_services`
3. **6060 端口检查**
   - 若未监听 → `start_malan_service`

最后输出：
- `===== timestamp 操作完成 =====`

---

## 6. 配置与可变项

| 配置项 | 默认/当前值 | 说明 |
| --- | --- | --- |
| 服务器IP | **自动获取** | 脚本自动检测本机IP，优先获取非127.0.0.1的IPv4地址 |
| ujava容器名 | `ujava*` | 支持模糊匹配（ujava2/ujava3/ujava6等） |
| 平台 API URL | `https://自动获取的IP/api/system/getVerifyCode` | 用于判断平台核心可用性 |
| malan 目录 | `/var/www/malan` | 6060端口服务 |
| 服务启动等待 | 30s | start_service/restart_extapi/malan 统一超时 |
| 调试模式 | `true` | 启用时打印详细运行参数，便于排查问题 |

**服务器IP获取逻辑：**
- 优先获取与Docker容器同网段的IP地址
- 自动过滤 `127.0.0.1` 本地回环地址
- 支持多网卡环境，选择首个有效IP

**调试模式说明：**
当 `DEBUG_MODE=true` 时，脚本会在日志中输出以下运行参数：
- 服务器IP、容器名、API_URL
- Malan服务目录和端口配置
- 超时配置参数
- 各服务的jar包标识和路径配置

**调试输出示例：**
```
2026-01-27 19:10:00 [DEBUG] ========== 运行参数 ==========
2026-01-27 19:10:00 [DEBUG] 服务器IP: 192.168.5.47
2026-01-27 19:10:00 [DEBUG] 容器名: ujava6
2026-01-27 19:10:00 [DEBUG] API_URL: https://192.168.5.47/api/system/getVerifyCode
2026-01-27 19:10:00 [DEBUG] MALAN_DIR: /var/www/malan
2026-01-27 19:10:00 [DEBUG] MALAN_PORT: 6060
2026-01-27 19:10:00 [DEBUG] START_TIMEOUT: 30秒
2026-01-27 19:10:00 [DEBUG] RESTART_WAIT: 30秒
2026-01-27 19:10:00 [DEBUG] 服务[meeting2.0]: jar=ubains-meeting-inner-api, path=/var/www/java/api-java-meeting2.0/
2026-01-27 19:10:00 [DEBUG] ==============================
```

---

## 7. 异常处理与容错要求

1. 任何一步失败必须写日志（含原因/路径/命令关键点）。
2. `run.sh` 不存在必须明确提示（各服务）。
3. 重启 unacos 成功后必须等待 30 秒再继续（避免依赖未就绪）。
4. 端口检测必须兼容不同系统命令（netstat/ss/lsof 任一存在即可）。

---

## 8. 交付物

1. 定时脚本：
   - `monitor_inner_api_services.sh`
2. 日志文件输出：
   - `/var/log/monitor-inner-api-services.log`
3. 使用说明：
   - 需要通过 crontab 或 systemd timer 定时执行（频率由运维决定，如每 1~5 分钟一次）。

---

## 9. 验收标准

1. 当任一容器内服务停止时：
   - 日志出现 `[STOPPED]` 与后续 `[START]/[SUCCESS]`，服务恢复运行。
2. 当 6060 未监听：
   - 能启动 malan 并在 30 秒内监听成功，否则输出失败原因。
3. 所有执行过程有可追溯日志，且不会静默失败。

---

## 需求规范
    代码规范：Docs/PRD/01规范文档/_PRD_规范文档_代码规范.md
    问题总结：Docs/PRD/01规范文档/_PRD_问题总结_记录文档.md
    方法总结：Docs/PRD/01规范文档/_PRD_方法总结_记录文档.md
    文档规范：Docs/PRD/01规范文档/_PRD_规范文档_文档规范.md
    测试规范：Docs/PRD/01规范文档/_PRD_规范文档_测试规范.md