## 📝 业务操作流程

### 一、远程容器升级操作流程

以下是运维人员在主服务器上执行远程容器升级的完整操作步骤：

#### 步骤 1：启动远程升级脚本

在主服务器的镜像目录下，执行远程升级脚本：

```bash
cd /path/to/container-images
./remote_update.sh
```

#### 步骤 2：选择要升级的容器类型

脚本会显示可选的容器列表，根据提示输入对应编号：

```
可选择的容器：
  [1] ujava      - Java 服务容器
  [2] uemqx      - EMQX 消息队列容器
  [3] uredis     - Redis 缓存容器
  [4] upython    - Python 服务容器
  [5] nacos      - Nacos 注册中心容器
  [6] unginx     - Nginx 反向代理容器

请输入容器编号: _
```

#### 步骤 3：选择目标服务器

脚本提供两种方式选择目标服务器：

**方式一：选择预设服务器**

```
可选择的目标服务器：
  [1] 标准版预定运维服务器 (192.168.5.48 root)
  [2] 阿曼项目预定服务器 (192.168.5.67 root)
  [3] 标准版预定运维测试发布服务器 (192.168.5.47 root)
  [0] 手动输入服务器信息

请输入服务器编号: _
```

**方式二：手动输入服务器信息（输入 0）**

```
请输入目标服务器 IP 地址: 192.168.1.100
请输入 SSH 端口号 [默认 22]: 22
请输入登录用户名 [默认 root]: root
请输入登录密码: ********
```

#### 步骤 4：等待架构校验

脚本会自动连接目标服务器，校验其 CPU 架构是否为 x86 系列：

```
[2025-12-07 10:30:00] [INFO] 开始校验远端架构 (192.168.1.100)
[2025-12-07 10:30:02] [INFO] 远端架构 x86_64 校验通过
```

> ⚠️ 如果目标服务器为 ARM 架构，脚本将终止执行并提示错误。

#### 步骤 5：等待文件传输

脚本自动将镜像文件和部署脚本传输到目标服务器：

```
[2025-12-07 10:30:05] [INFO] 创建远端目录 /home/containerUpdate
[2025-12-07 10:30:06] [INFO] 传输镜像与部署脚本到远端目录
java1.8.0_472.tar.gz                    100%  1.2GB  50.0MB/s   00:24
container_update.sh                     100%   45KB  10.0MB/s   00:00
```

#### 步骤 6：确认旧容器处理

脚本会自动检测并停止远端的旧版本容器：

```
[2025-12-07 10:31:00] [INFO] 查找并停止远端旧容器
[2025-12-07 10:31:02] [INFO] 检测到旧容器 ujava2，执行停止
[2025-12-07 10:31:05] [INFO] ✅ 旧容器 ujava2 已停止
```

#### 步骤 7：自动检测平台类型

脚本会自动检测目标服务器的平台类型（通过检查 `/data/services` 目录是否存在）：

```
[2025-12-07 10:30:10] [INFO] 自动检测目标服务器平台类型...
[2025-12-07 10:30:11] [INFO] ✅ 检测到 /data/services 目录存在，自动识别为新统一平台
```

| 检测结果 | 平台类型 | 目录结构 |
|----------|----------|----------|
| 存在 `/data/services` | 新统一平台 | `/data/` 目录 |
| 不存在 `/data/services` | 传统平台 | `/var/www/` 目录 |

> 💡 如果自动检测失败，脚本会回退到手动确认模式。

#### 步骤 8：等待资产同步（部分容器）

根据容器类型，脚本会同步相关配置文件和数据目录：

| 容器 | 同步内容 | 状态 | 备注 |
|------|----------|------|------|
| EMQX | 配置文件、数据目录、日志目录 | ✅ 已实现 | 自动备份远端现有目录 |
| Python | ~~代码目录、配置文件~~ | ⏸️ 暂停 | **暂不同步，功能保留待后续启用** |
| Nginx | 配置文件、HTML、证书目录 | ✅ 已实现 | 仅支持新统一平台 |

```
[2025-12-07 10:31:10] [INFO] 准备同步 EMQX 目录
[2025-12-07 10:31:12] [INFO] 远端目录已备份到 /data/middleware/emqx_backup_20251207_103112
[2025-12-07 10:31:15] [INFO] 使用 rsync 同步 EMQX 目录
[2025-12-07 10:31:30] [INFO] EMQX 目录同步完成
```

#### 步骤 9：等待远端部署执行

脚本在远端服务器上执行容器部署：

```
[2025-12-07 10:31:35] [INFO] 新容器名称确定为 ujava3
[2025-12-07 10:31:36] [INFO] 开始执行远端部署脚本
[2025-12-07 10:31:40] [INFO] 🔍 检查 Java 镜像是否存在...
[2025-12-07 10:31:42] [INFO] ❌ 镜像不存在，开始加载离线包...
[2025-12-07 10:32:00] [INFO] 🎉 镜像加载成功
[2025-12-07 10:32:02] [INFO] 🚀 正在启动 Java 容器: ujava3 ...
[2025-12-07 10:32:10] [INFO] ✅ Java 容器启动成功，等待初始化...
[2025-12-07 10:32:18] [INFO] 🎉 Java 服务部署完成！
```

#### 步骤 10：确认部署结果

部署完成后，脚本会输出容器状态信息：

```
NAMES    STATUS         PORTS
ujava3   Up 8 seconds   0.0.0.0:8085->8085/tcp, ...

[2025-12-07 10:32:20] [INFO] 远端部署执行完成
```

#### 步骤 11：自动清理远端镜像包

部署完成后，脚本会自动清理远端服务器上的镜像包和部署脚本：

```
[2025-12-07 10:32:21] [INFO] 开始清理远端镜像包...
[2025-12-07 10:32:22] [INFO] ✅ 远端镜像包清理完成
[2025-12-07 10:32:22] [INFO]    已删除镜像包: /home/containerUpdate/java1.8.0_472.tar.gz
[2025-12-07 10:32:22] [INFO]    已删除部署脚本: /home/containerUpdate/container_update.sh
[2025-12-07 10:32:22] [INFO] 远程升级流程结束
```

> 💡 清理过程会自动删除镜像包、部署脚本，如果目录为空还会删除整个目录。

---