#!/usr/bin/env bash

# 修复中文换行问题的专用工具脚本

SCRIPT_PATH="issue_handler.sh"

echo "开始修复中文换行问题..."

# 备份原文件
cp "$SCRIPT_PATH" "${SCRIPT_PATH}.bak"
echo "已创建备份文件: ${SCRIPT_PATH}.bak"

# 修复Windows换行符问题
sed -i 's/\r$//' "$SCRIPT_PATH"

# 修复可能的编码问题
if command -v dos2unix >/dev/null 2>&1; then
    dos2unix "$SCRIPT_PATH"
    echo "使用dos2unix处理文件"
elif command -v fromdos >/dev/null 2>&1; then
    fromdos "$SCRIPT_PATH"
    echo "使用fromdos处理文件"
else
    echo "未找到dos2unix或fromdos工具，跳过DOS格式转换"
fi

# 确保文件以Unix换行符结尾
tail -c1 < "$SCRIPT_PATH" | read -r _ || echo "" >> "$SCRIPT_PATH"

echo "中文换行问题修复完成！"
echo "请测试运行脚本: bash $SCRIPT_PATH"